/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.api.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ehrbase.api.rest.HttpRestContextHandler;

public class HttpRestContext {
    public static CtxAttr<String> QUERY = new Query();
    public static CtxAttr<String> QUERY_ID = new QueryId();
    public static CtxAttr<String> LOCATION = new Location();
    public static CtxAttr<Integer> VERSION = new Version();
    public static CtxAttr<UUID> EHR_ID = new EhrId();
    public static CtxAttr<String> TEMPLATE_ID = new TemplateId();
    public static CtxAttr<UUID> COMPOSITION_ID = new CompositionId();
    public static CtxAttr<String> DIRECTORY_ID = new DirectoryId();
    public static CtxAttr<UUID> CONTRIBUTION_ID = new ContributionId();
    public static CtxAttr<Set<String>> REMOVED_PATIENTS = new RemovedPatients();
    public static CtxAttr<Boolean> QUERY_EXECUTE_ENDPOINT = new QueryExecuteEndpoint();
    private static ThreadLocal<HttpCtxMap> httpContext = ThreadLocal.withInitial(() -> new HttpCtxMap());

    public static void clear() {
        httpContext.remove();
    }

    public <T> T getValueBy(CtxAttr<T> key) {
        Map ctxMap = httpContext.get();
        return (T)ctxMap.get(key);
    }

    public static <V> void register(CtxAttr<V> key, V value) {
        httpContext.get().put(key, value);
    }

    public static <V0, V1> void register(CtxAttr<V0> key0, V0 value0, CtxAttr<V1> key1, V1 value1) {
        HttpRestContext.register(key0, value0);
        HttpRestContext.register(key1, value1);
    }

    public static <V0, V1, V2> void register(CtxAttr<V0> key0, V0 value0, CtxAttr<V1> key1, V1 value1, CtxAttr<V2> key2, V2 value2) {
        HttpRestContext.register(key0, value0);
        HttpRestContext.register(key1, value1);
        HttpRestContext.register(key2, value2);
    }

    public static <V0, V1, V2, V3> void register(CtxAttr<V0> key0, V0 value0, CtxAttr<V1> key1, V1 value1, CtxAttr<V2> key2, V2 value2, CtxAttr<V3> key3, V3 value3) {
        HttpRestContext.register(key0, value0);
        HttpRestContext.register(key1, value1);
        HttpRestContext.register(key2, value2);
        HttpRestContext.register(key3, value3);
    }

    public static <V0, V1, V2, V3, V4> void register(CtxAttr<V0> key0, V0 value0, CtxAttr<V1> key1, V1 value1, CtxAttr<V2> key2, V2 value2, CtxAttr<V3> key3, V3 value3, CtxAttr<V4> key4, V4 value4) {
        HttpRestContext.register(key0, value0);
        HttpRestContext.register(key1, value1);
        HttpRestContext.register(key2, value2);
        HttpRestContext.register(key3, value3);
        HttpRestContext.register(key4, value4);
    }

    public static void handle(HttpRestContextHandler handler) {
        handler.handle(httpContext.get());
    }

    public static final class HttpCtxMap
    extends HashMap<CtxAttr<?>, Object> {
        private static final long serialVersionUID = -910609086038543024L;

        private HttpCtxMap() {
        }
    }

    public static abstract class CtxAttr<T> {
        private final String name = this.getClass().getSimpleName();

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return this.name.equals(obj);
        }
    }

    private static class Query
    extends CtxAttr<String> {
        private Query() {
        }
    }

    private static class QueryId
    extends CtxAttr<String> {
        private QueryId() {
        }
    }

    private static class Location
    extends CtxAttr<String> {
        private Location() {
        }
    }

    private static class Version
    extends CtxAttr<Integer> {
        private Version() {
        }
    }

    private static class EhrId
    extends CtxAttr<UUID> {
        private EhrId() {
        }
    }

    private static class TemplateId
    extends CtxAttr<String> {
        private TemplateId() {
        }
    }

    private static class CompositionId
    extends CtxAttr<UUID> {
        private CompositionId() {
        }
    }

    private static class DirectoryId
    extends CtxAttr<String> {
        private DirectoryId() {
        }
    }

    private static class ContributionId
    extends CtxAttr<UUID> {
        private ContributionId() {
        }
    }

    private static class RemovedPatients
    extends CtxAttr<Set<String>> {
        private RemovedPatients() {
        }
    }

    private static class QueryExecuteEndpoint
    extends CtxAttr<Boolean> {
        private QueryExecuteEndpoint() {
        }
    }
}

