/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config;

import java.util.Formatter;
import org.ehrbase.application.config.SecurityConfig;
import org.ehrbase.application.config.SecurityYAMLConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@EnableWebSecurity
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private SecurityYAMLConfig securityYAMLConfig;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Formatter formatter = new Formatter();

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser(this.securityYAMLConfig.getAuthUser()).password(this.passwordEncoder().encode((CharSequence)this.securityYAMLConfig.getAuthPassword())).authorities(new String[]{"ROLE_USER"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        switch (1.$SwitchMap$org$ehrbase$application$config$SecurityYAMLConfig$AuthTypes[this.securityYAMLConfig.getAuthType().ordinal()]) {
            case 1: {
                this.logger.info("Using basic authentication.");
                this.logger.info(this.formatter.format("Username: %s Password: %s", this.securityYAMLConfig.getAuthUser(), this.securityYAMLConfig.getAuthPassword()).toString());
                ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().anyRequest()).authenticated().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).httpBasic();
                break;
            }
            default: {
                this.logger.warn("Authentication disabled!");
                this.logger.warn("To enable security set security.authType to BASIC in yaml properties file.");
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().anyRequest()).permitAll();
            }
        }
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

