/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.abac;

import java.net.URI;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.ehrbase.application.abac.AbacConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name={"abac.enabled"})
@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix="abac")
public class AbacConfig {
    private URI server;
    private String organizationClaim;
    private String patientClaim;
    private Map<AbacType, Policy> policy;

    @Bean
    public AbacCheck abacCheck(HttpClient httpClient) {
        return new AbacCheck(httpClient);
    }

    public URI getServer() {
        return this.server;
    }

    public void setServer(URI server) {
        this.server = server;
    }

    public String getOrganizationClaim() {
        return this.organizationClaim;
    }

    public void setOrganizationClaim(String organizationClaim) {
        this.organizationClaim = organizationClaim;
    }

    public String getPatientClaim() {
        return this.patientClaim;
    }

    public void setPatientClaim(String patientClaim) {
        this.patientClaim = patientClaim;
    }

    public Map<AbacType, Policy> getPolicy() {
        return this.policy;
    }

    public void setPolicy(Map<AbacType, Policy> policy) {
        this.policy = policy;
    }
}

