/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.abac;

import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.application.abac.AbacConfig;
import org.ehrbase.response.ehrscape.CompositionDto;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.response.openehr.OriginalVersionResponseData;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class CustomMethodSecurityExpressionRoot
extends SecurityExpressionRoot
implements MethodSecurityExpressionOperations {
    static final String ORGANIZATION = "organization";
    static final String PATIENT = "patient";
    static final String TEMPLATE = "template";
    static final String PRE = "pre";
    static final String POST = "post";
    private final AbacConfig abacConfig;
    private final AbacConfig.AbacCheck abacCheck;
    private CompositionService compositionService;
    private ContributionService contributionService;
    private EhrService ehrService;
    private Object filterObject;
    private Object returnObject;

    public CustomMethodSecurityExpressionRoot(Authentication authentication, AbacConfig abacConfig, AbacConfig.AbacCheck abacCheck) {
        super(authentication);
        this.abacConfig = abacConfig;
        this.abacCheck = abacCheck;
    }

    public void setCompositionService(CompositionService compositionService) {
        this.compositionService = compositionService;
    }

    public void setContributionService(ContributionService contributionService) {
        this.contributionService = contributionService;
    }

    public void setEhrService(EhrService ehrService) {
        this.ehrService = ehrService;
    }

    public boolean checkAbacPost(String type, String subject, Object payload, String contentType) throws IOException, InterruptedException {
        return this.checkAbac(type, subject, payload, contentType, POST);
    }

    public boolean checkAbacPostQuery(Object payload) throws IOException, InterruptedException {
        return this.checkAbac("query", null, payload, null, POST);
    }

    public boolean checkAbacPre(String type, String subject, Object payload, String contentType) throws IOException, InterruptedException {
        return this.checkAbac(type, subject, payload, contentType, PRE);
    }

    public boolean checkAbacPre(String type, String subject) throws IOException, InterruptedException {
        return this.checkAbac(type, subject, null, null, PRE);
    }

    private boolean checkAbac(String type, String subject, Object payload, String contentType, String authType) throws IOException, InterruptedException {
        boolean patientMatch;
        List<AbacConfig.PolicyParameter> policyParameters;
        String requestUrl = this.abacConfig.getServer().toString();
        Map policy = this.abacConfig.getPolicy();
        switch (type) {
            case "ehr": {
                policyParameters = Arrays.asList(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.EHR)).getParameters());
                requestUrl = requestUrl.concat(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.EHR)).getName());
                break;
            }
            case "ehrstatus": {
                policyParameters = Arrays.asList(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.EHR_STATUS)).getParameters());
                requestUrl = requestUrl.concat(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.EHR_STATUS)).getName());
                break;
            }
            case "composition": {
                policyParameters = Arrays.asList(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.COMPOSITION)).getParameters());
                requestUrl = requestUrl.concat(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.COMPOSITION)).getName());
                break;
            }
            case "contribution": {
                policyParameters = Arrays.asList(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.CONTRIBUTION)).getParameters());
                requestUrl = requestUrl.concat(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.CONTRIBUTION)).getName());
                break;
            }
            case "query": {
                policyParameters = Arrays.asList(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.QUERY)).getParameters());
                requestUrl = requestUrl.concat(((AbacConfig.Policy)policy.get(AbacConfig.AbacType.QUERY)).getName());
                break;
            }
            default: {
                throw new InternalServerException("ABAC: Invalid type given from Pre- or PostAuthorize");
            }
        }
        JwtAuthenticationToken jwt = this.getJwtAuthenticationToken(this.authentication);
        HashMap requestMap = new HashMap();
        if (policyParameters.contains(AbacConfig.PolicyParameter.ORGANIZATION)) {
            this.organizationHandling(jwt, requestMap);
        }
        if (policyParameters.contains(AbacConfig.PolicyParameter.PATIENT) && !(patientMatch = this.patientHandling(jwt, subject, requestMap, type, payload))) {
            return false;
        }
        if (policyParameters.contains(AbacConfig.PolicyParameter.TEMPLATE)) {
            this.templateHandling(type, payload, contentType, requestMap, authType);
        }
        if ((policyParameters.contains(AbacConfig.PolicyParameter.ORGANIZATION) || policyParameters.contains(AbacConfig.PolicyParameter.PATIENT) || policyParameters.contains(AbacConfig.PolicyParameter.TEMPLATE)) && requestMap.size() == 0) {
            throw new InternalServerException("ABAC: Parameters were configured, but request parameters are empty.");
        }
        return this.abacCheckRequest(requestUrl, requestMap);
    }

    private void organizationHandling(JwtAuthenticationToken jwt, Map<String, Object> requestMap) {
        if (!jwt.getTokenAttributes().containsKey(this.abacConfig.getOrganizationClaim())) {
            throw new IllegalArgumentException("ABAC use of an organization claim is configured but can't be retrieved from the given JWT.");
        }
        String orgaId = (String)jwt.getTokenAttributes().get(this.abacConfig.getOrganizationClaim());
        requestMap.put(ORGANIZATION, orgaId);
    }

    private boolean patientHandling(JwtAuthenticationToken jwt, String subject, Map<String, Object> requestMap, String type, Object payload) {
        if (!jwt.getTokenAttributes().containsKey(this.abacConfig.getPatientClaim())) {
            throw new IllegalArgumentException("ABAC: Patient parameter configured, but no claim attribute available.");
        }
        String tokenPatient = (String)jwt.getTokenAttributes().get(this.abacConfig.getPatientClaim());
        if (type.equals("query")) {
            if (payload instanceof Map) {
                if (((Map)payload).containsKey("ehr_id/value")) {
                    Set ehrs = (Set)((Map)payload).get("ehr_id/value");
                    HashSet<String> patientSet = new HashSet<String>();
                    for (UUID ehr : ehrs) {
                        String subjectId = this.ehrService.getSubjectExtRef(ehr.toString());
                        if (tokenPatient.equals(subjectId) || subjectId == null) {
                            patientSet.add(tokenPatient);
                            continue;
                        }
                        return false;
                    }
                    requestMap.put(PATIENT, patientSet);
                    return true;
                }
                throw new InternalServerException("ABAC: AQL audit patient data unavailable.");
            }
            throw new InternalServerException("ABAC: AQL audit patient data malformed.");
        }
        if (!tokenPatient.equals(subject) && subject != null) {
            return false;
        }
        requestMap.put(PATIENT, tokenPatient);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void templateHandling(String type, Object payload, String contentType, Map<String, Object> requestMap, String authType) {
        switch (type) {
            case "ehr": {
                throw new IllegalArgumentException("ABAC: Unsupported configuration: Can't set template ID for EHR type.");
            }
            case "ehrstatus": {
                throw new IllegalArgumentException("ABAC: Unsupported configuration: Can't set template ID for EHR_STATUS type.");
            }
            case "composition": {
                String templateId;
                String content = "";
                if (authType.equals(POST)) {
                    if (!((ResponseEntity)payload).hasBody()) throw new InternalServerException("ABAC: unexpected empty response body");
                    Object body = ((ResponseEntity)payload).getBody();
                    if (((ResponseEntity)payload).getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
                        Object error;
                        if (body instanceof Map && (error = ((Map)body).get("error")) != null && ((String)error).contains("delet")) return;
                        throw new InternalServerException("ABAC: Unexpected empty response from composition reuquest");
                    }
                    if (body instanceof OriginalVersionResponseData) {
                        if (((OriginalVersionResponseData)body).getData() instanceof Composition) {
                            String template = Objects.requireNonNull(((Composition)((OriginalVersionResponseData)body).getData()).getArchetypeDetails().getTemplateId()).getValue();
                            requestMap.put(TEMPLATE, template);
                            return;
                        }
                    } else {
                        if (!(body instanceof String)) throw new InternalServerException("ABAC: unexpected composition payload object");
                        content = (String)body;
                    }
                } else {
                    if (!authType.equals(PRE)) throw new InternalServerException("ABAC: invalid auth type given.");
                    try {
                        ObjectVersionId versionId = new ObjectVersionId((String)payload);
                        UUID compositionUid = UUID.fromString(versionId.getRoot().getValue());
                        Optional compoDto = this.compositionService.retrieve(compositionUid, null);
                        if (!compoDto.isPresent()) {
                            throw new InternalServerException("ABAC: unexpected empty response from composition delete");
                        }
                        Composition c = ((CompositionDto)compoDto.get()).getComposition();
                        requestMap.put(TEMPLATE, c.getArchetypeDetails().getTemplateId().getValue());
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        content = (String)payload;
                    }
                }
                if (MediaType.parseMediaType((String)contentType).isCompatibleWith(MediaType.APPLICATION_JSON)) {
                    templateId = this.compositionService.getTemplateIdFromInputComposition(content, CompositionFormat.JSON);
                } else {
                    if (!MediaType.parseMediaType((String)contentType).isCompatibleWith(MediaType.APPLICATION_XML)) throw new IllegalArgumentException("ABAC: Only JSON and XML composition are supported.");
                    templateId = this.compositionService.getTemplateIdFromInputComposition(content, CompositionFormat.XML);
                }
                requestMap.put(TEMPLATE, templateId);
                return;
            }
            case "contribution": {
                CompositionFormat format;
                if (MediaType.parseMediaType((String)contentType).isCompatibleWith(MediaType.APPLICATION_JSON)) {
                    format = CompositionFormat.JSON;
                } else {
                    if (!MediaType.parseMediaType((String)contentType).isCompatibleWith(MediaType.APPLICATION_XML)) throw new IllegalArgumentException("ABAC: Only JSON and XML composition are supported.");
                    format = CompositionFormat.XML;
                }
                if (!(payload instanceof String)) throw new InternalServerException("ABAC: invalid POST contribution payload.");
                Set templates = this.contributionService.getListOfTemplates((String)payload, format);
                requestMap.put(TEMPLATE, templates);
                return;
            }
            case "query": {
                if (!(payload instanceof Map)) throw new InternalServerException("ABAC: AQL audit template data malformed.");
                if (!((Map)payload).containsKey("archetype_details/template_id/value")) throw new InternalServerException("ABAC: AQL audit template data unavailable.");
                Set templates = (Set)((Map)payload).get("archetype_details/template_id/value");
                HashSet templateSet = new HashSet(templates);
                requestMap.put(TEMPLATE, templateSet);
                return;
            }
            default: {
                throw new InternalServerException("ABAC: Invalid type given from Pre- or PostAuthorize");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean abacCheckRequest(String url, Map<String, Object> bodyMap) throws IOException, InterruptedException {
        HashMap<String, String> request = new HashMap<String, String>();
        if (bodyMap.containsKey(ORGANIZATION)) {
            request.put(ORGANIZATION, (String)bodyMap.get(ORGANIZATION));
        }
        if (bodyMap.containsKey(PATIENT)) {
            if (bodyMap.get(PATIENT) instanceof Set) {
                if (!bodyMap.containsKey(TEMPLATE)) return this.sendRequestForEach(PATIENT, url, bodyMap, request);
                if (bodyMap.get(TEMPLATE) instanceof Set) {
                    Set setP = (Set)bodyMap.get(PATIENT);
                    for (String p : setP) {
                        request.put(PATIENT, p);
                        boolean success = this.sendRequestForEach(TEMPLATE, url, bodyMap, request);
                        if (success) continue;
                        return false;
                    }
                    return true;
                }
            } else {
                if (!(bodyMap.get(PATIENT) instanceof String)) throw new InternalServerException("ABAC: Invalid patient attribute content.");
                request.put(PATIENT, (String)bodyMap.get(PATIENT));
            }
        }
        if (!bodyMap.containsKey(TEMPLATE)) return this.abacCheck.execute(url, request);
        if (bodyMap.get(TEMPLATE) instanceof Set) {
            return this.sendRequestForEach(TEMPLATE, url, bodyMap, request);
        }
        if (!(bodyMap.get(TEMPLATE) instanceof String)) throw new InternalServerException("ABAC: Invalid template attribute content.");
        request.put(TEMPLATE, (String)bodyMap.get(TEMPLATE));
        return this.abacCheck.execute(url, request);
    }

    private boolean sendRequestForEach(String type, String url, Map<String, Object> bodyMap, Map<String, String> request) throws IOException, InterruptedException {
        Set set = (Set)bodyMap.get(type);
        for (String s : set) {
            request.put(type, s);
            boolean allowed = this.abacCheck.execute(url, request);
            if (allowed) continue;
            return false;
        }
        return true;
    }

    private JwtAuthenticationToken getJwtAuthenticationToken(Authentication auth) {
        if (!(auth instanceof JwtAuthenticationToken)) {
            throw new IllegalArgumentException("ABAC: Invalid authentication, no JWT available.");
        }
        JwtAuthenticationToken jwt = (JwtAuthenticationToken)auth;
        return jwt;
    }

    public Object getFilterObject() {
        return this.filterObject;
    }

    public void setFilterObject(Object filterObject) {
        this.filterObject = filterObject;
    }

    public Object getReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(Object returnObject) {
        this.returnObject = returnObject;
    }

    public Object getThis() {
        return this;
    }
}

