/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config;

import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.application.util.IsoDateTimeConverter;
import org.ehrbase.rest.openehr.audit.CompositionAuditInterceptor;
import org.ehrbase.rest.openehr.audit.EhrAuditInterceptor;
import org.ehrbase.rest.openehr.audit.QueryAuditInterceptor;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private final AuditContext auditContext;
    private final EhrService ehrService;
    private final CompositionService compositionService;

    public WebMvcConfig(AuditContext auditContext, EhrService ehrService, CompositionService compositionService) {
        this.auditContext = auditContext;
        this.ehrService = ehrService;
        this.compositionService = compositionService;
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new IsoDateTimeConverter());
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**");
    }

    public void addInterceptors(@NonNull InterceptorRegistry registry) {
        if (this.auditContext.isAuditEnabled()) {
            registry.addInterceptor((HandlerInterceptor)new CompositionAuditInterceptor(this.auditContext, this.ehrService, this.compositionService)).addPathPatterns(new String[]{"/rest/openehr/v1/**/composition/**"});
            registry.addInterceptor((HandlerInterceptor)new EhrAuditInterceptor(this.auditContext, this.ehrService)).addPathPatterns(new String[]{"/rest/openehr/v1/ehr", "/rest/openehr/v1/ehr/*"});
            registry.addInterceptor((HandlerInterceptor)new QueryAuditInterceptor(this.auditContext, this.ehrService)).addPathPatterns(new String[]{"/rest/openehr/v1/query/**"});
        }
    }
}

