/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.security;

import javax.annotation.PostConstruct;
import org.ehrbase.application.config.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;

@Configuration
@ConditionalOnProperty(prefix="security", name={"authType"}, havingValue="basic")
@EnableWebSecurity
public class BasicAuthSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthSecurityConfiguration.class);
    private final SecurityProperties properties;

    public BasicAuthSecurityConfiguration(SecurityProperties securityProperties) {
        this.properties = securityProperties;
    }

    @PostConstruct
    public void initialize() {
        LOG.info("Using basic authentication.");
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        ((InMemoryUserDetailsManagerConfigurer)auth.inMemoryAuthentication().withUser(this.properties.getAuthUser()).password("{noop}" + this.properties.getAuthPassword()).roles(new String[]{"USER"}).and()).withUser(this.properties.getAuthAdminUser()).password("{noop}" + this.properties.getAuthAdminPassword()).roles(new String[]{"ADMIN"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().ignoringAntMatchers(new String[]{"/rest/**"}).and()).authorizeRequests().antMatchers(new String[]{"/rest/admin/**", "/management/**"})).hasRole("ADMIN").anyRequest()).hasAnyRole(new String[]{"ADMIN", "USER"}).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).httpBasic();
    }
}

