/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.cache;

import org.ehrbase.application.config.cache.CacheInitializer;
import org.ehrbase.application.config.cache.CacheProperties;
import org.ehrbase.cache.CacheOptions;
import org.ehrbase.service.KnowledgeCacheService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CacheProperties.class})
@EnableCaching
public class CacheConfiguration {
    @Bean
    public CacheOptions cacheOptions(CacheProperties properties) {
        CacheOptions options = new CacheOptions();
        options.setPreBuildQueries(properties.isPreBuildQueries());
        options.setPreBuildQueriesDepth(properties.getPreBuildQueriesDepth().intValue());
        return options;
    }

    @Bean
    @ConditionalOnProperty(prefix="cache", name={"init-on-startup"}, havingValue="true")
    public CacheInitializer cacheInitializer(KnowledgeCacheService knowledgeCacheService) {
        return new CacheInitializer(knowledgeCacheService);
    }
}

