/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.ehrbase.application.config.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;

@Configuration
@ConditionalOnProperty(prefix="security", name={"auth-type"}, havingValue="oauth")
@EnableWebSecurity
public class OAuth2SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2SecurityConfiguration.class);
    @Value(value="${spring.security.oauth2.resourceserver.jwt.issuer-uri}")
    private String issuerUri;
    public static final String PROFILE_SCOPE = "PROFILE";
    private final SecurityProperties properties;

    public OAuth2SecurityConfiguration(SecurityProperties properties) {
        this.properties = properties;
    }

    @PostConstruct
    public void initialize() {
        LOG.info("Using OAuth2 authentication.");
        LOG.info("Using issuer URI: {}", (Object)this.issuerUri);
        LOG.info("Using user role: {}", (Object)this.properties.getOauth2UserRole());
        LOG.info("Using admin role: {}", (Object)this.properties.getOauth2AdminRole());
    }

    protected void configure(HttpSecurity http) throws Exception {
        String userRole = this.properties.getOauth2UserRole();
        String adminRole = this.properties.getOauth2AdminRole();
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.cors().and()).authorizeRequests().antMatchers(new String[]{"/rest/admin/**", "/management/**"})).hasRole(adminRole).anyRequest()).hasAnyRole(new String[]{adminRole, userRole, PROFILE_SCOPE}).and()).oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.getJwtAuthenticationConverter());
    }

    private Converter<Jwt, AbstractAuthenticationToken> getJwtAuthenticationConverter() {
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        converter.setJwtGrantedAuthoritiesConverter(jwt -> {
            Map realmAccess = (Map)jwt.getClaims().get("realm_access");
            HashSet authority = new HashSet();
            if (realmAccess != null && realmAccess.containsKey("roles")) {
                authority.addAll(((List)realmAccess.get("roles")).stream().map(roleName -> "ROLE_" + roleName.toUpperCase()).map(SimpleGrantedAuthority::new).collect(Collectors.toList()));
            }
            if (jwt.getClaims().containsKey("scope")) {
                authority.addAll(Arrays.stream(jwt.getClaims().get("scope").toString().split(" ")).map(roleName -> "ROLE_" + roleName.toUpperCase()).map(SimpleGrantedAuthority::new).collect(Collectors.toList()));
            }
            return authority;
        });
        return converter;
    }
}

