/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.validation;

import java.util.Map;
import org.apache.http.client.HttpClient;
import org.ehrbase.application.config.validation.ValidationProperties;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupportChain;
import org.ehrbase.validation.constraints.terminology.FhirTerminologyValidationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"validation.external-terminology.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ValidationProperties.class})
public class ValidationConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationConfiguration.class);
    private final ValidationProperties properties;
    private final HttpClient httpClient;

    public ValidationConfiguration(ValidationProperties properties, HttpClient httpClient) {
        this.properties = properties;
        this.httpClient = httpClient;
    }

    @Bean
    public ExternalTerminologyValidationSupport externalTerminologyValidator() {
        Map providers = this.properties.getProvider();
        if (providers.isEmpty()) {
            throw new IllegalStateException("At least one external terminology provider must be defined if 'validation.external-validation.enabled' is set to 'true'");
        }
        if (providers.size() == 1) {
            Map.Entry provider = providers.entrySet().iterator().next();
            return this.buildExternalTerminologyValidator(provider);
        }
        ExternalTerminologyValidationSupportChain chain = new ExternalTerminologyValidationSupportChain();
        for (Map.Entry provider : providers.entrySet()) {
            chain.addExternalTerminologyValidationSupport(this.buildExternalTerminologyValidator(provider));
        }
        return chain;
    }

    private ExternalTerminologyValidationSupport buildExternalTerminologyValidator(Map.Entry<String, ValidationProperties.Provider> provider) {
        LOG.info("Initializing '{}' external terminology provider (type: {})", (Object)provider.getKey(), (Object)provider.getValue().getType());
        if (provider.getValue().getType() == ValidationProperties.ProviderType.FHIR) {
            return this.fhirTerminologyValidationSupport(provider.getValue().getUrl());
        }
        throw new IllegalArgumentException("Invalid provider type: " + provider.getValue().getType());
    }

    private FhirTerminologyValidationSupport fhirTerminologyValidationSupport(String url) {
        return new FhirTerminologyValidationSupport(url, this.properties.isFailOnError(), this.httpClient);
    }
}

