/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.ehrbase.application.config.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;

@Configuration
@ConditionalOnProperty(prefix="security", name={"auth-type"}, havingValue="oauth")
@EnableWebSecurity
public class OAuth2SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    public static final String PROFILE_SCOPE = "PROFILE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SecurityProperties securityProperties;
    private final OAuth2ResourceServerProperties oAuth2rProperties;

    public OAuth2SecurityConfiguration(SecurityProperties securityProperties, OAuth2ResourceServerProperties oAuth2rProperties) {
        this.securityProperties = securityProperties;
        this.oAuth2rProperties = oAuth2rProperties;
    }

    @PostConstruct
    public void initialize() {
        this.logger.info("Using OAuth2 authentication");
        this.logger.debug("Using issuer URI: {}", (Object)this.oAuth2rProperties.getJwt().getIssuerUri());
        this.logger.debug("Using user role: {}", (Object)this.securityProperties.getOauth2UserRole());
        this.logger.debug("Using admin role: {}", (Object)this.securityProperties.getOauth2AdminRole());
    }

    protected void configure(HttpSecurity http) throws Exception {
        String userRole = this.securityProperties.getOauth2UserRole();
        String adminRole = this.securityProperties.getOauth2AdminRole();
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.cors().and()).authorizeRequests().antMatchers(new String[]{"/rest/admin/**", "/management/**"})).hasRole(adminRole).anyRequest()).hasAnyRole(new String[]{adminRole, userRole, PROFILE_SCOPE}).and()).oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.getJwtAuthenticationConverter());
    }

    private Converter<Jwt, AbstractAuthenticationToken> getJwtAuthenticationConverter() {
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        converter.setJwtGrantedAuthoritiesConverter(jwt -> {
            Map realmAccess = (Map)jwt.getClaims().get("realm_access");
            HashSet authority = new HashSet();
            if (realmAccess != null && realmAccess.containsKey("roles")) {
                authority.addAll(((List)realmAccess.get("roles")).stream().map(roleName -> "ROLE_" + roleName.toUpperCase()).map(SimpleGrantedAuthority::new).collect(Collectors.toList()));
            }
            if (jwt.getClaims().containsKey("scope")) {
                authority.addAll(Arrays.stream(jwt.getClaims().get("scope").toString().split(" ")).map(roleName -> "ROLE_" + roleName.toUpperCase()).map(SimpleGrantedAuthority::new).collect(Collectors.toList()));
            }
            return authority;
        });
        return converter;
    }
}

