/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.plugin;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.application.config.plugin.EhrBasePluginManager;
import org.ehrbase.application.config.plugin.PluginManagerProperties;
import org.ehrbase.plugin.EhrBasePluginManagerInterface;
import org.pf4j.PluginWrapper;
import org.pf4j.spring.ExtensionsInjector;
import org.pf4j.spring.SpringPluginManager;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class EhrBasePluginManager
extends SpringPluginManager
implements EhrBasePluginManagerInterface {
    private static final Map<String, PropertySourceLoader> PROPERTY_SOURCE_LOADER_MAP = Stream.of(new YamlPropertySourceLoader(), new PropertiesPropertySourceLoader(), new JsonPropertySourceLoader()).flatMap(p -> Arrays.stream(p.getFileExtensions()).map(e -> Pair.of((Object)e, (Object)p))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    private final PluginManagerProperties properties;
    private boolean init = false;

    public EhrBasePluginManager(PluginManagerProperties properties) {
        super(properties.getPluginDir());
        this.properties = properties;
    }

    public void init() {
    }

    public void initPlugins() {
        if (!this.init) {
            this.startPlugins();
            AbstractAutowireCapableBeanFactory beanFactory = (AbstractAutowireCapableBeanFactory)this.getApplicationContext().getAutowireCapableBeanFactory();
            ExtensionsInjector extensionsInjector = new ExtensionsInjector((SpringPluginManager)this, beanFactory);
            extensionsInjector.injectExtensions();
            this.init = true;
        }
    }

    protected PropertySource<?> getConfig(String fileName, PluginWrapper pluginWrapper) {
        Path totalPath = Path.of(this.properties.getPluginConfigDir().toString(), pluginWrapper.getPluginId(), fileName);
        return (PropertySource)Optional.of(fileName).map(FilenameUtils::getExtension).map(PROPERTY_SOURCE_LOADER_MAP::get).map(p -> {
            try {
                return p.load(fileName, (Resource)new FileSystemResource(totalPath));
            }
            catch (IOException e) {
                throw new InternalServerException((Throwable)e);
            }
        }).stream().flatMap(Collection::stream).findAny().orElseThrow(() -> new InternalServerException(String.format("No Property Source found for %s", totalPath)));
    }

    public List<PropertySource<?>> loadConfig(PluginWrapper pluginWrapper) {
        Path totalPath = Path.of(this.properties.getPluginConfigDir().toString(), pluginWrapper.getPluginId());
        if (Files.exists(totalPath, new LinkOption[0])) {
            List<PropertySource<?>> list;
            block9: {
                Stream<Path> walk = Files.walk(totalPath, new FileVisitOption[0]);
                try {
                    list = walk.filter(p -> PROPERTY_SOURCE_LOADER_MAP.keySet().contains(FilenameUtils.getExtension((String)p.toString()))).map(p -> this.getConfig(p.getFileName().toString(), pluginWrapper)).collect(Collectors.toList());
                    if (walk == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (walk != null) {
                            try {
                                walk.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new InternalServerException((Throwable)e);
                    }
                }
                walk.close();
            }
            return list;
        }
        return Collections.emptyList();
    }
}

