/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.validation;

import java.util.Map;
import org.apache.http.client.HttpClient;
import org.ehrbase.application.config.validation.ValidationProperties;
import org.ehrbase.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.validation.terminology.ExternalTerminologyValidationChain;
import org.ehrbase.validation.terminology.FhirTerminologyValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ValidationProperties.class})
public class ValidationConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ValidationProperties properties;
    private final HttpClient httpClient;
    @Value(value="${validation.external-terminology.enabled}")
    private Boolean enableExternalValidation;

    public ValidationConfiguration(ValidationProperties properties, HttpClient httpClient) {
        this.properties = properties;
        this.httpClient = httpClient;
    }

    @Bean
    public ExternalTerminologyValidation externalTerminologyValidator() {
        if (!this.enableExternalValidation.booleanValue()) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        Map providers = this.properties.getProvider();
        if (providers.isEmpty()) {
            throw new IllegalStateException("At least one external terminology provider must be defined if 'validation.external-validation.enabled' is set to 'true'");
        }
        if (providers.size() == 1) {
            Map.Entry provider = providers.entrySet().iterator().next();
            return this.buildExternalTerminologyValidation(provider);
        }
        ExternalTerminologyValidationChain chain = new ExternalTerminologyValidationChain();
        for (Map.Entry provider : providers.entrySet()) {
            chain.addExternalTerminologyValidationSupport(this.buildExternalTerminologyValidation(provider));
        }
        return chain;
    }

    private ExternalTerminologyValidation buildExternalTerminologyValidation(Map.Entry<String, ValidationProperties.Provider> provider) {
        this.logger.info("Initializing '{}' external terminology provider (type: {})", (Object)provider.getKey(), (Object)provider.getValue().getType());
        if (provider.getValue().getType() == ValidationProperties.ProviderType.FHIR) {
            return this.fhirTerminologyValidation(provider.getValue().getUrl());
        }
        throw new IllegalArgumentException("Invalid provider type: " + provider.getValue().getType());
    }

    private FhirTerminologyValidation fhirTerminologyValidation(String url) {
        return new FhirTerminologyValidation(url, this.properties.isFailOnError(), this.httpClient);
    }
}

