/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.ehr.EhrStatus;
import org.ehrbase.api.mapper.StructuredStringJSonSerializer;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.serialisation.mapper.RmObjectJsonDeSerializer;
import org.ehrbase.serialisation.mapper.RmObjectJsonSerializer;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;

@Configuration
public class JacksonConfiguration {
    @Bean
    public Jackson2ObjectMapperBuilderCustomizer addCustomSerialization() {
        return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.serializerByType(StructuredString.class, (JsonSerializer)new StructuredStringJSonSerializer()).serializerByType(RMObject.class, (JsonSerializer)new RmObjectJsonSerializer()).deserializerByType(EhrStatus.class, (JsonDeserializer)new RmObjectJsonDeSerializer()).deserializerByType(Folder.class, (JsonDeserializer)new RmObjectJsonDeSerializer()).modules(new Module[]{new JavaTimeModule()});
    }

    @Bean
    @Primary
    public MappingJackson2XmlHttpMessageConverter mappingJackson2XmlHttpMessageConverter(Jackson2ObjectMapperBuilder builder) {
        XmlMapper objectMapper = (XmlMapper)builder.createXmlMapper(true).build();
        objectMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        return new MappingJackson2XmlHttpMessageConverter((ObjectMapper)objectMapper);
    }
}

