/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.client;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.ehrbase.application.config.client.HttpClientProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;

@Configuration
@EnableConfigurationProperties(value={HttpClientProperties.class})
public class HttpClientConfiguration {
    @Bean
    public HttpClient httpClient(HttpClientProperties properties) throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        HttpClientBuilder builder = HttpClients.custom();
        if (properties.getSsl().isEnabled()) {
            builder.setSSLContext(this.buildSSLContext(properties.getSsl()));
            builder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        if (properties.getProxy().getHost() != null && properties.getProxy().getPort() != null) {
            builder.setProxy(new HttpHost(properties.getProxy().getHost(), properties.getProxy().getPort().intValue()));
            if (properties.getProxy().getUsername() != null && properties.getProxy().getPassword() != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(properties.getProxy().getUsername(), properties.getProxy().getPassword());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return builder.build();
    }

    private SSLContext buildSSLContext(HttpClientProperties.Ssl properties) throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        SSLContextBuilder builder = SSLContextBuilder.create();
        if (properties.getKeyStoreType() != null) {
            builder.setKeyStoreType(properties.getKeyStoreType());
        }
        builder.loadKeyMaterial(ResourceUtils.getFile((String)properties.getKeyStore()), properties.getKeyStorePassword().toCharArray(), properties.getKeyPassword().toCharArray());
        if (properties.getTrustStoreType() != null) {
            builder.setKeyStoreType(properties.getTrustStoreType());
        }
        builder.loadTrustMaterial(ResourceUtils.getFile((String)properties.getTrustStore()), properties.getTrustStorePassword().toCharArray(), (TrustStrategy)TrustAllStrategy.INSTANCE);
        return builder.build();
    }
}

