/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config;

import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix="httpclient")
public class HttpClientConfig {
    private HttpClient client;
    private URI proxy;
    private int proxyPort;

    public HttpClient getClient() {
        if (this.client == null) {
            HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NEVER).connectTimeout(Duration.ofSeconds(20L));
            if (this.proxy != null && this.proxyPort != 0) {
                builder.proxy(ProxySelector.of(new InetSocketAddress(this.proxy.toString(), this.proxyPort)));
            }
            this.client = builder.build();
        }
        return this.client;
    }

    public URI getProxy() {
        return this.proxy;
    }

    public void setProxy(URI proxy) {
        this.proxy = proxy;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }
}

