/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.ehrbase.application.config.cache.CacheProperties;
import org.ehrbase.cache.CacheOptions;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CacheProperties.class})
@EnableCaching
public class CacheConfiguration {
    @Bean
    public CacheOptions cacheOptions(CacheProperties properties) {
        CacheOptions options = new CacheOptions();
        options.setPreBuildQueries(properties.isPreBuildQueries());
        options.setPreBuildQueriesDepth(properties.getPreBuildQueriesDepth().intValue());
        options.setPreInitialize(properties.isInitOnStartup());
        return options;
    }

    @Bean
    @ConditionalOnExpression(value="T(org.springframework.boot.autoconfigure.cache.CacheType).CAFFEINE.name().equalsIgnoreCase(\"${spring.cache.type}\")")
    public CacheManagerCustomizer<CaffeineCacheManager> cacheManagerCustomizer() {
        return cm -> {
            cm.registerCustomCache("introspectCache", Caffeine.newBuilder().build());
            cm.registerCustomCache("queryCache", Caffeine.newBuilder().build());
            cm.registerCustomCache("fieldsCache", Caffeine.newBuilder().build());
            cm.registerCustomCache("multivaluedCache", Caffeine.newBuilder().build());
            cm.registerCustomCache("conceptCacheId", Caffeine.newBuilder().build());
            cm.registerCustomCache("conceptCacheConceptId", Caffeine.newBuilder().build());
            cm.registerCustomCache("conceptCacheDescription", Caffeine.newBuilder().build());
            cm.registerCustomCache("territoryCache", Caffeine.newBuilder().build());
            cm.registerCustomCache("languageCache", Caffeine.newBuilder().build());
            cm.registerCustomCache("userIdCache", Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());
            cm.registerCustomCache("sysTenant", Caffeine.newBuilder().build());
        };
    }
}

