/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.security;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.ehrbase.service.IAuthenticationFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="security", name={"auth-type"}, havingValue="none")
public class NoOpSecurityConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void initialize() {
        this.logger.warn("Security is disabled. Configure 'security.auth-type' to disable this warning.");
    }

    @Bean
    @Primary
    public IAuthenticationFacade anonymousAuthentication() {
        AnonymousAuthenticationFilter filter = new AnonymousAuthenticationFilter("key");
        return () -> new AnonymousAuthenticationToken("key", filter.getPrincipal(), (Collection)filter.getAuthorities());
    }
}

