/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.ehrbase.application.config.security.SecurityFilter;
import org.ehrbase.application.config.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationFilter;

@Deprecated
@Configuration
@EnableWebSecurity
@ConditionalOnProperty(prefix="security", name={"auth-type"}, havingValue="oauth")
public class OAuth2SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final String PUBLIC = "PUBLIC";
    private static final String PRIVATE = "PRIVATE";
    public static final String ADMIN_ONLY = "ADMIN_ONLY";
    public static final String PROFILE_SCOPE = "PROFILE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${management.endpoints.web.access:ADMIN_ONLY}")
    private String managementEndpointsAccessType;
    private final SecurityProperties securityProperties;
    private final OAuth2ResourceServerProperties oAuth2Properties;
    private final WebEndpointProperties managementWebEndpointProperties;

    public OAuth2SecurityConfiguration(SecurityProperties securityProperties, OAuth2ResourceServerProperties oAuth2Properties, WebEndpointProperties managementWebEndpointProperties) {
        this.securityProperties = securityProperties;
        this.oAuth2Properties = oAuth2Properties;
        this.managementWebEndpointProperties = managementWebEndpointProperties;
    }

    @PostConstruct
    public void initialize() {
        this.logger.info("Using OAuth2 authentication");
        this.logger.debug("Using issuer URI: {}", (Object)this.oAuth2Properties.getJwt().getIssuerUri());
        this.logger.debug("Using user role: {}", (Object)this.securityProperties.getOauth2UserRole());
        this.logger.debug("Using admin role: {}", (Object)this.securityProperties.getOauth2AdminRole());
    }

    protected void configure(HttpSecurity http) throws Exception {
        String userRole = this.securityProperties.getOauth2UserRole();
        String adminRole = this.securityProperties.getOauth2AdminRole();
        http.addFilterBefore((Filter)new SecurityFilter(), BearerTokenAuthenticationFilter.class);
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry = ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.cors().and()).authorizeRequests().antMatchers(new String[]{"/rest/admin/**"})).hasRole(adminRole).antMatchers(new String[]{"/swagger-ui/**", "/v3/api-docs/**"})).permitAll();
        ExpressionUrlAuthorizationConfigurer.AuthorizedUrl managementAuthorizedUrl = (ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)registry.and()).authorizeRequests().antMatchers(new String[]{this.managementWebEndpointProperties.getBasePath() + "/**"});
        switch (this.managementEndpointsAccessType) {
            case "ADMIN_ONLY": {
                managementAuthorizedUrl.hasRole(adminRole);
                break;
            }
            case "PRIVATE": {
                managementAuthorizedUrl.hasAnyRole(new String[]{adminRole, userRole, PROFILE_SCOPE});
                break;
            }
            case "PUBLIC": {
                managementAuthorizedUrl.permitAll();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unexpected management endpoints access control type %s", this.managementEndpointsAccessType));
            }
        }
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.anyRequest()).hasAnyRole(new String[]{adminRole, userRole, PROFILE_SCOPE}).and()).oauth2ResourceServer().jwt().jwtAuthenticationConverter(this.getJwtAuthenticationConverter());
    }

    private Converter<Jwt, AbstractAuthenticationToken> getJwtAuthenticationConverter() {
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        converter.setJwtGrantedAuthoritiesConverter(jwt -> {
            Map realmAccess = (Map)jwt.getClaims().get("realm_access");
            HashSet authority = new HashSet();
            if (realmAccess != null && realmAccess.containsKey("roles")) {
                authority.addAll(((List)realmAccess.get("roles")).stream().map(roleName -> "ROLE_" + roleName.toUpperCase()).map(SimpleGrantedAuthority::new).collect(Collectors.toList()));
            }
            if (jwt.getClaims().containsKey("scope")) {
                authority.addAll(Arrays.stream(jwt.getClaims().get("scope").toString().split(" ")).map(roleName -> "ROLE_" + roleName.toUpperCase()).map(SimpleGrantedAuthority::new).collect(Collectors.toList()));
            }
            return authority;
        });
        return converter;
    }
}

