/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.web;

import org.ehrbase.application.config.web.AuditInterceptorHandler;
import org.ehrbase.application.config.web.CorsProperties;
import org.ehrbase.application.util.IsoDateTimeConverter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CorsProperties.class})
public class WebConfiguration
implements WebMvcConfigurer {
    private final CorsProperties properties;
    AuditInterceptorHandler auditInterceptorHandler;

    public WebConfiguration(CorsProperties properties, AuditInterceptorHandler auditInterceptorHandler) {
        this.properties = properties;
        this.auditInterceptorHandler = auditInterceptorHandler;
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new IsoDateTimeConverter());
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").combine(this.properties.toCorsConfiguration());
    }

    public void addInterceptors(@NonNull InterceptorRegistry registry) {
        this.auditInterceptorHandler.registerAuditInterceptors(registry);
    }
}

