/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.abac;

import org.aopalliance.intercept.MethodInvocation;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.application.abac.AbacConfig;
import org.ehrbase.application.abac.CustomMethodSecurityExpressionRoot;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"abac.enabled"})
@Component
public class CustomMethodSecurityExpressionHandler
extends DefaultMethodSecurityExpressionHandler {
    private final AbacConfig abacConfig;
    private final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private final CompositionService compositionService;
    private final ContributionService contributionService;
    private final EhrService ehrService;
    private final AbacConfig.AbacCheck abacCheck;

    @Lazy
    public CustomMethodSecurityExpressionHandler(AbacConfig abacConfig, CompositionService compositionService, ContributionService contributionService, EhrService ehrService, AbacConfig.AbacCheck abacCheck) {
        this.abacConfig = abacConfig;
        this.compositionService = compositionService;
        this.contributionService = contributionService;
        this.ehrService = ehrService;
        this.abacCheck = abacCheck;
    }

    protected MethodSecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, MethodInvocation invocation) {
        CustomMethodSecurityExpressionRoot root = new CustomMethodSecurityExpressionRoot(authentication, this.abacConfig, this.abacCheck);
        root.setCompositionService(this.compositionService);
        root.setContributionService(this.contributionService);
        root.setEhrService(this.ehrService);
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        root.setTrustResolver(this.trustResolver);
        root.setRoleHierarchy(this.getRoleHierarchy());
        return root;
    }
}

