/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.plugin;

import jakarta.servlet.Servlet;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.application.config.plugin.EhrBasePluginManager;
import org.ehrbase.application.config.plugin.PluginManagerProperties;
import org.ehrbase.plugin.WebMvcEhrBasePlugin;
import org.pf4j.PluginWrapper;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
@EnableConfigurationProperties(value={PluginManagerProperties.class})
@ConditionalOnProperty(prefix="plugin-manager", name={"enable"}, havingValue="true")
public class PluginConfig {
    @Bean
    public EhrBasePluginManager pluginManager(Environment environment) {
        return new EhrBasePluginManager(this.getPluginManagerProperties(environment));
    }

    private PluginManagerProperties getPluginManagerProperties(Environment environment) {
        return (PluginManagerProperties)Binder.get((Environment)environment).bind("plugin-manager", PluginManagerProperties.class).get();
    }

    @Bean
    public BeanFactoryPostProcessor beanFactoryPostProcessor(EhrBasePluginManager pluginManager, Environment environment) {
        PluginManagerProperties pluginManagerProperties = this.getPluginManagerProperties(environment);
        HashMap registeredUrl = new HashMap();
        return beanFactory -> {
            pluginManager.loadPlugins();
            pluginManager.getPlugins().stream().map(PluginWrapper::getPlugin).filter(p -> WebMvcEhrBasePlugin.class.isAssignableFrom(p.getClass())).map(WebMvcEhrBasePlugin.class::cast).forEach(p -> this.register(beanFactory, pluginManagerProperties, registeredUrl, p));
        };
    }

    private void register(ConfigurableListableBeanFactory beanFactory, PluginManagerProperties pluginManagerProperties, Map<String, String> registeredUrl, WebMvcEhrBasePlugin p) {
        String pluginId = p.getWrapper().getPluginId();
        String uri = UriComponentsBuilder.newInstance().path(pluginManagerProperties.getPluginContextPath()).path(p.getContextPath()).path("/*").build().getPath();
        registeredUrl.entrySet().stream().filter(e -> ((String)e.getValue()).equals(uri)).findAny().ifPresent(e -> {
            throw new InternalServerException(String.format("uri %s for plugin %s already registered by plugin %s", uri, pluginId, e.getKey()));
        });
        registeredUrl.put(pluginId, uri);
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)p.getDispatcherServlet(), new String[]{uri});
        bean.setLoadOnStartup(1);
        bean.setOrder(1);
        bean.setName(pluginId);
        beanFactory.initializeBean((Object)bean, pluginId);
        beanFactory.autowireBean((Object)bean);
        beanFactory.registerSingleton(pluginId, (Object)bean);
    }

    @Bean
    ApplicationListener<ServletWebServerInitializedEvent> servletWebServerInitializedEventApplicationListener(EhrBasePluginManager pluginManager) {
        return event -> pluginManager.initPlugins();
    }
}

