/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.security;

import jakarta.servlet.Filter;
import javax.annotation.PostConstruct;
import org.ehrbase.application.config.security.SecurityFilter;
import org.ehrbase.application.config.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@ConditionalOnProperty(prefix="security", name={"authType"}, havingValue="basic")
@EnableWebSecurity
public class BasicAuthSecurityConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void initialize() {
        this.logger.info("Using basic authentication");
    }

    @Bean
    public InMemoryUserDetailsManager inMemoryUserDetailsManager(SecurityProperties properties, ObjectProvider<PasswordEncoder> passwordEncoder) {
        return new InMemoryUserDetailsManager(new UserDetails[]{User.withUsername((String)properties.getAuthUser()).password("{noop}" + properties.getAuthPassword()).roles(new String[]{"USER"}).build(), User.withUsername((String)properties.getAuthAdminUser()).password("{noop}" + properties.getAuthAdminPassword()).roles(new String[]{"ADMIN"}).build()});
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.addFilterBefore((Filter)new SecurityFilter(), BasicAuthenticationFilter.class);
        http.cors(Customizer.withDefaults()).csrf(c -> c.ignoringRequestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/rest/**")})).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/rest/admin/**"), AntPathRequestMatcher.antMatcher((String)"/management/**")})).hasRole("ADMIN").anyRequest()).hasAnyRole(new String[]{"ADMIN", "USER"})).sessionManagement(s -> s.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).httpBasic(Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }
}

