/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.security;

import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.ehrbase.application.config.security.SecurityFilter;
import org.ehrbase.application.config.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.web.authentication.BearerTokenAuthenticationFilter;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@ConditionalOnProperty(prefix="security", name={"auth-type"}, havingValue="oauth")
public class OAuth2SecurityConfiguration {
    private static final String PUBLIC = "PUBLIC";
    private static final String PRIVATE = "PRIVATE";
    public static final String ADMIN_ONLY = "ADMIN_ONLY";
    public static final String PROFILE_SCOPE = "PROFILE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${management.endpoints.web.access:ADMIN_ONLY}")
    private String managementEndpointsAccessType;
    private final SecurityProperties securityProperties;
    private final OAuth2ResourceServerProperties oAuth2Properties;
    private final WebEndpointProperties managementWebEndpointProperties;

    public OAuth2SecurityConfiguration(SecurityProperties securityProperties, OAuth2ResourceServerProperties oAuth2Properties, WebEndpointProperties managementWebEndpointProperties) {
        this.securityProperties = securityProperties;
        this.oAuth2Properties = oAuth2Properties;
        this.managementWebEndpointProperties = managementWebEndpointProperties;
    }

    @PostConstruct
    public void initialize() {
        this.logger.info("Using OAuth2 authentication");
        this.logger.debug("Using issuer URI: {}", (Object)this.oAuth2Properties.getJwt().getIssuerUri());
        this.logger.debug("Using user role: {}", (Object)this.securityProperties.getOauth2UserRole());
        this.logger.debug("Using admin role: {}", (Object)this.securityProperties.getOauth2AdminRole());
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        String userRole = this.securityProperties.getOauth2UserRole();
        String adminRole = this.securityProperties.getOauth2AdminRole();
        http.addFilterBefore((Filter)new SecurityFilter(), BearerTokenAuthenticationFilter.class);
        http.cors(Customizer.withDefaults()).authorizeHttpRequests(auth -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry registry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/rest/admin/**")})).hasRole(adminRole);
            AuthorizeHttpRequestsConfigurer.AuthorizedUrl managementAuthorizedUrl = (AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)(this.managementWebEndpointProperties.getBasePath() + "/**"))});
            switch (this.managementEndpointsAccessType) {
                case "ADMIN_ONLY": {
                    managementAuthorizedUrl.hasRole(adminRole);
                    break;
                }
                case "PRIVATE": {
                    managementAuthorizedUrl.hasAnyRole(new String[]{adminRole, userRole, PROFILE_SCOPE});
                    break;
                }
                case "PUBLIC": {
                    managementAuthorizedUrl.permitAll();
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected management endpoints access control type %s", this.managementEndpointsAccessType));
                }
            }
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()).hasAnyRole(new String[]{adminRole, userRole, PROFILE_SCOPE});
        }).oauth2ResourceServer(o -> o.jwt(j -> j.jwtAuthenticationConverter(this.getJwtAuthenticationConverter())));
        return (SecurityFilterChain)http.build();
    }

    private Converter<Jwt, AbstractAuthenticationToken> getJwtAuthenticationConverter() {
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        converter.setJwtGrantedAuthoritiesConverter(jwt -> {
            Map realmAccess = (Map)jwt.getClaims().get("realm_access");
            HashSet<SimpleGrantedAuthority> authority = new HashSet<SimpleGrantedAuthority>();
            if (realmAccess != null && realmAccess.containsKey("roles")) {
                authority.addAll(((List)realmAccess.get("roles")).stream().map(roleName -> "ROLE_" + roleName.toUpperCase()).map(SimpleGrantedAuthority::new).toList());
            }
            if (jwt.getClaims().containsKey("scope")) {
                authority.addAll(Arrays.stream(jwt.getClaims().get("scope").toString().split(" ")).map(roleName -> "ROLE_" + roleName.toUpperCase()).map(SimpleGrantedAuthority::new).toList());
            }
            return authority;
        });
        return converter;
    }
}

