/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.config.web;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehrbase.api.audit.interceptor.AuditCompensationInterceptor;
import org.ehrbase.api.audit.interceptor.AuditCompositionInterceptor;
import org.ehrbase.api.audit.interceptor.AuditContributionInterceptor;
import org.ehrbase.api.audit.interceptor.AuditDirectoryInterceptor;
import org.ehrbase.api.audit.interceptor.AuditEhrAdminInterceptor;
import org.ehrbase.api.audit.interceptor.AuditEhrInterceptor;
import org.ehrbase.api.audit.interceptor.AuditEhrStatusInterceptor;
import org.ehrbase.api.audit.interceptor.AuditInterceptor;
import org.ehrbase.api.audit.interceptor.AuditQueryInterceptor;
import org.ehrbase.application.config.web.AuditHandlerInterceptorDelegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

@Component
public class AuditInterceptorHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ANY_SEGMENT = "*";
    private static final String ROLLBACK = "rollback";
    private static final String ANY_TRAILING_SEGMENTS = "**";
    @Value(value="${openehr-api.context-path:/rest/openehr}/v1")
    protected String apiContextPath;
    @Value(value="${admin-api.context-path:/rest/admin}")
    protected String adminApiContextPath;
    @Autowired(required=false)
    AuditEhrInterceptor ehrInterceptor;
    @Autowired(required=false)
    AuditQueryInterceptor queryInterceptor;
    @Autowired(required=false)
    AuditEhrAdminInterceptor ehrAdminInterceptor;
    @Autowired(required=false)
    AuditEhrStatusInterceptor ehrStatusInterceptor;
    @Autowired(required=false)
    AuditCompositionInterceptor compositionInterceptor;
    @Autowired(required=false)
    AuditContributionInterceptor contributionInterceptor;
    @Autowired(required=false)
    AuditCompensationInterceptor compensationInterceptor;
    @Autowired(required=false)
    AuditDirectoryInterceptor directoryInterceptor;

    public void registerAuditInterceptors(InterceptorRegistry registry) {
        if (this.shouldRegisterInterceptors()) {
            this.registerEhrInterceptor(registry);
            this.registerQueryInterceptor(registry);
            this.registerEhrAdminInterceptor(registry);
            this.registerEhrStatusInterceptor(registry);
            this.registerCompositionInterceptor(registry);
            this.registerContributionInterceptor(registry);
            this.registerCompensationInterceptor(registry);
            this.registerDirectoryInterceptor(registry);
        }
    }

    private void registerEhrStatusInterceptor(InterceptorRegistry registry) {
        if (this.ehrStatusInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)new AuditHandlerInterceptorDelegator((AuditInterceptor)this.ehrStatusInterceptor)).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT, "ehr_status"}), this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT, "ehr_status", ANY_TRAILING_SEGMENTS})}).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT, "ehr_status"}), this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT, "versioned_ehr_status", ANY_TRAILING_SEGMENTS})});
        } else {
            this.log.info("Ehr Status interceptor bean is not available.");
        }
    }

    private void registerQueryInterceptor(InterceptorRegistry registry) {
        if (this.queryInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)new AuditHandlerInterceptorDelegator((AuditInterceptor)this.queryInterceptor)).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"query", ANY_TRAILING_SEGMENTS})}).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"definition", "query", ANY_TRAILING_SEGMENTS})});
        } else {
            this.log.info("Query interceptor bean is not available.");
        }
    }

    private void registerEhrAdminInterceptor(InterceptorRegistry registry) {
        if (this.ehrAdminInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)new AuditHandlerInterceptorDelegator((AuditInterceptor)this.ehrAdminInterceptor)).addPathPatterns(new String[]{this.contextAdminPathPattern(new String[]{"ehr"}), this.contextAdminPathPattern(new String[]{"ehr", ANY_SEGMENT})});
        } else {
            this.log.info("Ehr admin interceptor bean is not available.");
        }
    }

    private void registerEhrInterceptor(InterceptorRegistry registry) {
        if (this.ehrInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)new AuditHandlerInterceptorDelegator((AuditInterceptor)this.ehrInterceptor)).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"ehr"}), this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT})});
        } else {
            this.log.info("Ehr interceptor bean is not available.");
        }
    }

    private void registerContributionInterceptor(InterceptorRegistry registry) {
        if (this.contributionInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)new AuditHandlerInterceptorDelegator((AuditInterceptor)this.contributionInterceptor)).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT, "contribution", ANY_TRAILING_SEGMENTS})}).addPathPatterns(new String[]{this.contextAdminPathPattern(new String[]{"ehr", ANY_SEGMENT, "contribution", ANY_TRAILING_SEGMENTS})});
        } else {
            this.log.info("Contribution interceptor bean is not available.");
        }
    }

    private void registerCompositionInterceptor(InterceptorRegistry registry) {
        if (this.compositionInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)new AuditHandlerInterceptorDelegator((AuditInterceptor)this.compositionInterceptor)).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT, "composition", ANY_TRAILING_SEGMENTS})}).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT, "versioned_composition", ANY_TRAILING_SEGMENTS})}).addPathPatterns(new String[]{this.contextAdminPathPattern(new String[]{"ehr", ANY_SEGMENT, "composition", ANY_SEGMENT})});
        } else {
            this.log.info("Composition interceptor bean is not available.");
        }
    }

    private void registerCompensationInterceptor(InterceptorRegistry registry) {
        if (this.compensationInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)new AuditHandlerInterceptorDelegator((AuditInterceptor)this.compensationInterceptor)).addPathPatterns(new String[]{this.getPathPattern("", new String[]{"ehr", ANY_SEGMENT, "contribution", ANY_SEGMENT, ROLLBACK})});
        } else {
            this.log.info("Compensation interceptor bean is not available.");
        }
    }

    private void registerDirectoryInterceptor(InterceptorRegistry registry) {
        if (this.directoryInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)new AuditHandlerInterceptorDelegator((AuditInterceptor)this.directoryInterceptor)).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT, "directory"})}).addPathPatterns(new String[]{this.contextPathPattern(new String[]{"ehr", ANY_SEGMENT, "directory", ANY_SEGMENT})}).addPathPatterns(new String[]{this.contextAdminPathPattern(new String[]{"ehr", ANY_SEGMENT, "directory", ANY_SEGMENT})});
        } else {
            this.log.info("Directory interceptor bean is not available.");
        }
    }

    private boolean shouldRegisterInterceptors() {
        return this.compositionInterceptor != null || this.ehrInterceptor != null || this.ehrAdminInterceptor != null || this.queryInterceptor != null || this.contributionInterceptor != null || this.ehrStatusInterceptor != null || this.directoryInterceptor != null || this.compensationInterceptor != null;
    }

    private String contextPathPattern(String ... segments) {
        return this.getPathPattern(this.apiContextPath, segments);
    }

    private String contextAdminPathPattern(String ... segments) {
        return this.getPathPattern(this.adminApiContextPath, segments);
    }

    private String getPathPattern(String apiContextPath, String ... segments) {
        return Stream.concat(Stream.of(apiContextPath), Arrays.stream(segments)).collect(Collectors.joining("/"));
    }
}

