/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=-2147483648)
public class LoggingContextFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        try {
            MDC.put((String)"traceId", (String)this.generateTraceId());
            this.logger.trace((Object)"Set traceId for current request");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            MDC.remove((String)"traceId");
        }
    }

    private String generateTraceId() {
        return Long.toString(ThreadLocalRandom.current().nextLong(Long.MAX_VALUE), 16);
    }
}

