/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.application.cli;

import java.util.Map;
import org.ehrbase.cli.CliConfiguration;
import org.ehrbase.cli.CliRunner;
import org.ehrbase.configuration.EhrBaseCliConfiguration;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.Import;

@SpringBootApplication(exclude={WebMvcAutoConfiguration.class, RedisAutoConfiguration.class})
@Import(value={EhrBaseCliConfiguration.class, CliConfiguration.class})
public class EhrBaseCli
implements CommandLineRunner {
    private final CliRunner cliRunner;

    public static SpringApplication build(String[] args) {
        return new SpringApplicationBuilder(new Class[]{EhrBaseCli.class}).web(WebApplicationType.NONE).headless(true).properties(Map.of("spring.main.allow-bean-definition-overriding", "true", "spring.banner.location", "classpath:banner-cli.txt")).bannerMode(Banner.Mode.CONSOLE).logStartupInfo(false).build(args);
    }

    public EhrBaseCli(CliRunner cliRunner) {
        this.cliRunner = cliRunner;
    }

    public void run(String ... args) {
        this.cliRunner.run(args);
    }
}

