/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslAndQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFalseQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslTrueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ComparisonOperatorConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.LogicalOperatorConditionWrapper;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.TemporalPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.util.OpenEHRDateTimeParseUtils;
import org.jooq.JSONB;

public final class AslUtils {
    private AslUtils() {
    }

    public static Stream<ComparisonOperatorConditionWrapper> streamConditionDescriptors(ConditionWrapper condition) {
        if (condition == null) {
            return Stream.empty();
        }
        if (condition instanceof ComparisonOperatorConditionWrapper) {
            ComparisonOperatorConditionWrapper cd = (ComparisonOperatorConditionWrapper)condition;
            return Stream.of(cd);
        }
        if (condition instanceof LogicalOperatorConditionWrapper) {
            LogicalOperatorConditionWrapper ld = (LogicalOperatorConditionWrapper)condition;
            return ld.logicalOperands().stream().flatMap(AslUtils::streamConditionDescriptors);
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(condition));
    }

    public static String translateAqlLikePatternToSql(String aqlLike) {
        StringBuilder sb = new StringBuilder(aqlLike.length());
        int l = aqlLike.length();
        block10: for (int pos = 0; pos < l; ++pos) {
            char c = aqlLike.charAt(pos);
            switch (c) {
                case '%': 
                case '_': {
                    sb.append('\\').append(c);
                    continue block10;
                }
                case '\\': {
                    if (++pos >= l) {
                        throw new IllegalArgumentException("Invalid LIKE pattern: %s".formatted(aqlLike));
                    }
                    char next = aqlLike.charAt(pos);
                    switch (next) {
                        case '*': 
                        case '?': {
                            sb.append(next);
                            continue block10;
                        }
                        case '\\': {
                            sb.append("\\\\");
                            continue block10;
                        }
                    }
                    throw new IllegalArgumentException("Invalid LIKE pattern: %s".formatted(aqlLike));
                }
                case '?': {
                    sb.append('_');
                    continue block10;
                }
                case '*': {
                    sb.append('%');
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static OffsetDateTime toOffsetDateTime(StringPrimitive sp) {
        boolean hasOffset;
        TemporalAccessor temporal;
        if (sp instanceof TemporalPrimitive) {
            TemporalPrimitive tp = (TemporalPrimitive)sp;
            temporal = tp.getTemporal();
        } else {
            temporal = AslUtils.parseDateTimeOrTimeWithHigherPrecision((String)((Object)sp.getValue())).orElse(null);
        }
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)temporal;
            return odt;
        }
        if (!temporal.isSupported(ChronoField.YEAR)) {
            return null;
        }
        boolean hasTime = temporal.isSupported(ChronoField.HOUR_OF_DAY);
        boolean bl = hasOffset = hasTime && temporal.isSupported(ChronoField.OFFSET_SECONDS);
        if (hasOffset) {
            return OffsetDateTime.from(temporal);
        }
        if (hasTime) {
            return LocalDateTime.from(temporal).atOffset(ZoneOffset.UTC);
        }
        return LocalDate.from(temporal).atStartOfDay().atOffset(ZoneOffset.UTC);
    }

    public static Optional<TemporalAccessor> parseDateTimeOrTimeWithHigherPrecision(String val) {
        block4: {
            int dotIdx = val.indexOf(46);
            int tIdx = val.indexOf(84);
            int length = val.length();
            try {
                if (dotIdx == 19 && tIdx == 10 && length > 20 || dotIdx == 15 && tIdx == 8 && length > 16) {
                    return Optional.of(OpenEHRDateTimeParseUtils.parseDateTime((String)val));
                }
                if (tIdx == -1 && (dotIdx == 8 && length > 9 || dotIdx == 10 && length > 11)) {
                    return Optional.of(OpenEHRDateTimeParseUtils.parseTime((String)val));
                }
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof DateTimeException) break block4;
                throw e;
            }
        }
        return Optional.empty();
    }

    public static AslColumnField findFieldForOwner(AslStructureColumn structureField, List<AslField> fields, AslQuery owner) {
        return AslUtils.findFieldForOwner(structureField.getFieldName(), fields, owner);
    }

    public static AslColumnField findFieldForOwner(String fieldName, List<AslField> fields, AslQuery owner) {
        return fields.stream().filter(f -> f.getOwner() == owner).filter(AslColumnField.class::isInstance).map(AslColumnField.class::cast).filter(f -> fieldName.equals(f.getColumnName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Field '%s' does not exist for owner '%s'".formatted(fieldName, owner.getAlias())));
    }

    static AslQueryCondition structurePredicateCondition(ComparisonOperatorPredicate predicate, AslStructureQuery query, Function<String, Optional<UUID>> templateUuidLookupFunc) {
        HashSet<String> candidateTypes = new HashSet<String>(query.getRmTypes());
        if (candidateTypes.isEmpty() && query.getType() == AslStructureQuery.AslSourceRelation.EHR) {
            candidateTypes.add("EHR");
        }
        AslExtractedColumn extractedColumn = AslExtractedColumn.find((String)candidateTypes.iterator().next(), predicate.getPath()).filter(ec -> ec.getAllowedRmTypes().containsAll(candidateTypes)).orElseThrow();
        ConditionWrapper.ComparisonConditionOperator operator = ConditionWrapper.ComparisonConditionOperator.valueOf(predicate.getOperator().name());
        AslQueryCondition.AslConditionOperator aslOperator = operator.getAslOperator();
        AslField.FieldSource ownerSource = AslField.FieldSource.withOwner(query);
        List<Primitive> value = List.of((Primitive)predicate.getValue());
        AslFieldValueQueryCondition condition = switch (extractedColumn) {
            default -> throw new MatchException(null, null);
            case AslExtractedColumn.NAME_VALUE -> new AslFieldValueQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.ENTITY_NAME, query.getSelect(), (AslQuery)query), aslOperator, AslUtils.conditionValue(value, operator, String.class));
            case AslExtractedColumn.VO_ID -> new AslFieldValueQueryCondition(AslComplexExtractedColumnField.voIdField(ownerSource), aslOperator, AslUtils.conditionValue(value, operator, String.class));
            case AslExtractedColumn.EHR_ID -> new AslFieldValueQueryCondition(AslUtils.findFieldForOwner("id", query.getSelect(), (AslQuery)query), aslOperator, AslUtils.conditionValue(value, operator, String.class));
            case AslExtractedColumn.ARCHETYPE_NODE_ID -> new AslFieldValueQueryCondition<AslRmTypeAndConcept>(AslComplexExtractedColumnField.archetypeNodeIdField(ownerSource), aslOperator, AslUtils.archetypeNodeIdConditionValues(value, operator));
            case AslExtractedColumn.TEMPLATE_ID -> {
                List<UUID> templateUuids = AslUtils.templateIdConditionValues(value, operator, templateUuidLookupFunc);
                yield new AslFieldValueQueryCondition<UUID>(AslUtils.findFieldForOwner(AslStructureColumn.TEMPLATE_ID, query.getSelect(), (AslQuery)query), aslOperator, templateUuids);
            }
            case AslExtractedColumn.OV_CONTRIBUTION_ID, AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.AD_SYSTEM_ID, AslExtractedColumn.AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_PREFERRED_TERM, AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING, AslExtractedColumn.AD_CHANGE_TYPE_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_DV, AslExtractedColumn.AD_DESCRIPTION_VALUE, AslExtractedColumn.AD_DESCRIPTION_DV, AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_TIME_CREATED_DV, AslExtractedColumn.EHR_SYSTEM_ID, AslExtractedColumn.EHR_SYSTEM_ID_DV -> throw new IllegalArgumentException("Unexpected structure predicate on %s".formatted(new Object[]{extractedColumn}));
        };
        if (condition.getValues().isEmpty()) {
            return switch (condition.getOperator()) {
                case AslQueryCondition.AslConditionOperator.IN, AslQueryCondition.AslConditionOperator.EQ, AslQueryCondition.AslConditionOperator.LIKE -> new AslFalseQueryCondition();
                case AslQueryCondition.AslConditionOperator.NEQ -> new AslTrueQueryCondition();
                default -> throw new IllegalArgumentException("Unexpected operator %s".formatted(new Object[]{condition.getOperator()}));
            };
        }
        return condition;
    }

    @Nonnull
    static List<AslRmTypeAndConcept> archetypeNodeIdConditionValues(List<Primitive> comparison, ConditionWrapper.ComparisonConditionOperator operator) {
        return AslUtils.conditionValue(comparison, operator, String.class).stream().map(String.class::cast).map(AslRmTypeAndConcept::fromArchetypeNodeId).toList();
    }

    @Nonnull
    static List<UUID> templateIdConditionValues(List<Primitive> operands, ConditionWrapper.ComparisonConditionOperator operator, Function<String, Optional<UUID>> templateUuidLookupFunc) {
        if (EnumSet.of(ConditionWrapper.ComparisonConditionOperator.LIKE, ConditionWrapper.ComparisonConditionOperator.GT_EQ, ConditionWrapper.ComparisonConditionOperator.GT, ConditionWrapper.ComparisonConditionOperator.LT_EQ, ConditionWrapper.ComparisonConditionOperator.LT).contains((Object)operator)) {
            throw new IllegalArgumentException("unexpected operator for template_id: %s".formatted(new Object[]{operator}));
        }
        return AslUtils.conditionValue(operands, operator, String.class).stream().filter(Objects::nonNull).map(String.class::cast).map(templateUuidLookupFunc).flatMap(Optional::stream).toList();
    }

    static Stream<StringPrimitive> streamStringPrimitives(ComparisonOperatorConditionWrapper c) {
        return c.rightComparisonOperands().stream().filter(StringPrimitive.class::isInstance).map(StringPrimitive.class::cast);
    }

    static Optional<AslQueryCondition> reduceConditions(ConditionWrapper.LogicalConditionOperator setOp, Stream<AslQueryCondition> conditions) {
        List<AslQueryCondition> list = conditions.filter(setOp::filterNotNoop).toList();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        Optional<AslQueryCondition> shortCircuit = list.stream().filter(setOp::filterShortCircuit).findFirst();
        if (shortCircuit.isPresent()) {
            return shortCircuit;
        }
        if (list.size() == 1) {
            return list.stream().findFirst();
        }
        return Optional.of(setOp.build(list));
    }

    static Optional<AslQueryCondition> predicates(List<AndOperatorPredicate> orPredicates, Function<ComparisonOperatorPredicate, AslQueryCondition> comparisonOperatorHandler) {
        return AslUtils.reduceConditions(ConditionWrapper.LogicalConditionOperator.OR, CollectionUtils.emptyIfNull(orPredicates).stream().map(p -> AslUtils.reduceConditions(ConditionWrapper.LogicalConditionOperator.AND, p.getOperands().stream().map(comparisonOperatorHandler))).flatMap(Optional::stream));
    }

    static List<?> conditionValue(List<Primitive> values, ConditionWrapper.ComparisonConditionOperator operator, Class<?> type) {
        boolean isJsonbField = JSONB.class.isAssignableFrom(type);
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case ConditionWrapper.ComparisonConditionOperator.EXISTS -> Collections.emptyList();
            case ConditionWrapper.ComparisonConditionOperator.MATCHES, ConditionWrapper.ComparisonConditionOperator.EQ, ConditionWrapper.ComparisonConditionOperator.NEQ -> values.stream().map(Primitive::getValue).filter(p -> isJsonbField || type.isInstance(p) || UUID.class.isAssignableFrom(type) && p instanceof String).toList();
            case ConditionWrapper.ComparisonConditionOperator.LT, ConditionWrapper.ComparisonConditionOperator.GT_EQ, ConditionWrapper.ComparisonConditionOperator.GT, ConditionWrapper.ComparisonConditionOperator.LT_EQ -> values.stream().map(Primitive::getValue).toList();
            case ConditionWrapper.ComparisonConditionOperator.LIKE -> values.stream().map(Primitive::getValue).map(String.class::cast).map(AslUtils::translateAqlLikePatternToSql).filter(p -> isJsonbField || type.isInstance(p) || UUID.class.isAssignableFrom(type)).toList();
        };
    }

    static AslQueryCondition and(Stream<AslQueryCondition> conditionStream) {
        List<AslQueryCondition> conditions = conditionStream.toList();
        return switch (conditions.size()) {
            case 0 -> null;
            case 1 -> conditions.getFirst();
            default -> new AslAndQueryCondition(conditions);
        };
    }

    static final class AliasProvider {
        private final Map<String, Integer> aliasCounters = new HashMap<String, Integer>();

        AliasProvider() {
        }

        public String uniqueAlias(String alias) {
            return alias + "_" + String.valueOf(this.aliasCounters.compute(alias, (k, v) -> v == null ? 0 : v + 1));
        }
    }
}

