/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.featurecheck;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.featurecheck.ClauseType;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheckUtils;
import org.ehrbase.openehr.dbformat.AncestorStructureRmType;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.dbformat.StructureRoot;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentNotOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentVersionExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.util.AqlUtil;

final class FromCheck
implements FeatureCheck {
    private final SystemService systemService;

    public FromCheck(SystemService systemService) {
        this.systemService = systemService;
    }

    @Override
    public void ensureSupported(AqlQuery aqlQuery) {
        ContainmentClassExpression fc;
        Containment currentContainment = aqlQuery.getFrom();
        if (currentContainment == null) {
            throw new AqlFeatureNotImplementedException("FROM must be specified");
        }
        if (currentContainment instanceof ContainmentClassExpression && "EHR".equals((fc = (ContainmentClassExpression)currentContainment).getType())) {
            currentContainment = fc.getContains();
        } else if (!(currentContainment instanceof AbstractContainmentExpression)) {
            throw new AqlFeatureNotImplementedException("AND/OR/NOT only allowed after CONTAINS");
        }
        FromCheck.ensureContainmentSupported(currentContainment, null);
        AqlUtil.streamContainments((Containment)aqlQuery.getFrom()).forEach(this::ensureContainmentPredicateSupported);
    }

    private static Pair<Containment, StructureRoot> ensureStructureContainsSupported(ContainmentClassExpression nextContainment, StructureRoot structure) {
        Set structureRmTypes = StructureRmType.byTypeName((String)nextContainment.getType()).map(Set::of).or(() -> FromCheck.ensureAbstractStructureContainsSupported(nextContainment, structure).map(AncestorStructureRmType::getDescendants)).orElseThrow(() -> FromCheck.cremateUnsupportedType(nextContainment));
        if (CollectionUtils.containsAny((Collection)structureRmTypes, EnumSet.of(StructureRmType.FOLDER))) {
            throw new AqlFeatureNotImplementedException("CONTAINS %s is not supported".formatted(nextContainment.getType()));
        }
        if (!structureRmTypes.stream().allMatch(StructureRmType::isStructureEntry)) {
            throw new AqlFeatureNotImplementedException("CONTAINS %s is currently not supported".formatted(nextContainment.getType()));
        }
        if (structure == null && structureRmTypes.stream().map(StructureRmType::getStructureRoot).anyMatch(Objects::isNull)) {
            throw new IllegalAqlException("It is unclear if %s targets a COMPOSITION or EHR_STATUS".formatted(nextContainment.getType()));
        }
        StructureRoot structureRoot = structureRmTypes.stream().map(StructureRmType::getStructureRoot).collect(Collectors.reducing((a, b) -> a == b ? a : null)).orElse(null);
        return Pair.of((Object)nextContainment.getContains(), (Object)structureRoot);
    }

    private static IllegalAqlException cremateUnsupportedType(ContainmentClassExpression nextContainment) {
        return new IllegalAqlException("Type %s is not supported in FROM, only: EHR, %s".formatted(nextContainment.getType(), Stream.of(Arrays.stream(AncestorStructureRmType.values()).filter(at -> at.getNonStructureDescendants().isEmpty()).filter(at -> at.getDescendants().stream().allMatch(StructureRmType::isStructureEntry)), Arrays.stream(StructureRmType.values()).filter(StructureRmType::isStructureEntry)).flatMap(s -> s).map(Enum::name).collect(Collectors.joining(", "))));
    }

    private static void ensureContainmentSupported(Containment c, StructureRoot parentStructure) {
        Containment containment = c;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContainmentClassExpression.class, ContainmentVersionExpression.class, ContainmentSetOperator.class, ContainmentNotOperator.class}, (Object)containment, n)) {
            case -1: {
                break;
            }
            case 0: {
                ContainmentClassExpression cce = (ContainmentClassExpression)containment;
                Pair<Containment, StructureRoot> next = FromCheck.ensureStructureContainsSupported(cce, parentStructure);
                StructureRoot structureRoot = Optional.of(next).map(Pair::getRight).orElse(parentStructure);
                FromCheck.ensureContainmentSupported((Containment)next.getLeft(), structureRoot);
                FromCheck.ensureContainmentStructureSupported(parentStructure, cce, structureRoot);
                break;
            }
            case 1: {
                ContainmentVersionExpression cve = (ContainmentVersionExpression)containment;
                FromCheck.ensureVersionContaimentSupported(cve);
                break;
            }
            case 2: {
                ContainmentSetOperator cso = (ContainmentSetOperator)containment;
                cso.getValues().forEach(nc -> FromCheck.ensureContainmentSupported(nc, parentStructure));
                break;
            }
            case 3: {
                ContainmentNotOperator __ = (ContainmentNotOperator)containment;
                throw new AqlFeatureNotImplementedException("NOT CONTAINS");
            }
            default: {
                throw new IllegalAqlException("Unknown containment type: %s".formatted(c.getClass().getSimpleName()));
            }
        }
    }

    private static void ensureVersionContaimentSupported(ContainmentVersionExpression cve) {
        Containment nextContainment = cve.getContains();
        if (nextContainment == null) {
            throw new IllegalAqlException("VERSION containment must be followed by another CONTAINS expression");
        }
        if (nextContainment instanceof ContainmentVersionExpression) {
            throw new IllegalAqlException("VERSION cannot contain another VERSION");
        }
        if (nextContainment instanceof ContainmentSetOperator || nextContainment instanceof ContainmentNotOperator) {
            throw new AqlFeatureNotImplementedException("AND/OR/NOT operator as next containment after VERSION");
        }
        FromCheck.ensureContainmentSupported(nextContainment, null);
    }

    private static void ensureContainmentStructureSupported(StructureRoot parentStructure, ContainmentClassExpression cce, StructureRoot structure) {
        StructureRoot structureRoot = parentStructure;
        int n = 0;
        boolean containmentStructureSupported = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FOLDER", "COMPOSITION", "EHR_STATUS"}, (StructureRoot)structureRoot, n)) {
            case -1 -> {
                if (structure != null) {
                    yield true;
                }
                yield false;
            }
            case 0 -> {
                if (structure == StructureRoot.FOLDER || structure == StructureRoot.COMPOSITION) {
                    yield true;
                }
                yield false;
            }
            case 1, 2 -> {
                if (parentStructure == structure) {
                    yield true;
                }
                yield false;
            }
            default -> throw new RuntimeException("%s is not root structure".formatted(parentStructure));
        };
        if (!containmentStructureSupported) {
            throw new IllegalAqlException("Structure %s cannot CONTAIN %s (of structure %s)".formatted(Optional.ofNullable(parentStructure).map(Object::toString).orElse("EHR"), cce.getType(), structure));
        }
    }

    private void ensureContainmentPredicateSupported(AbstractContainmentExpression containment) {
        ContainmentVersionExpression cve;
        ContainmentVersionExpression.VersionPredicateType pType;
        if (containment instanceof ContainmentVersionExpression && (pType = (cve = (ContainmentVersionExpression)containment).getVersionPredicateType()) != ContainmentVersionExpression.VersionPredicateType.LATEST_VERSION && pType != ContainmentVersionExpression.VersionPredicateType.NONE) {
            throw new AqlFeatureNotImplementedException("Only VERSION queries without predicate or on LATEST_VERSION supported");
        }
        if (containment.hasPredicates()) {
            List condition = containment.getPredicates();
            AqlUtil.streamPredicates((List)condition).forEach(predicate -> {
                IdentifiedPath identifiedPath = new IdentifiedPath();
                identifiedPath.setRoot(containment);
                identifiedPath.setPath(predicate.getPath());
                FeatureCheckUtils.PathDetails pathWithType = FeatureCheckUtils.findSupportedIdentifiedPath(identifiedPath, false, ClauseType.FROM_PREDICATE, this.systemService.getSystemId());
                if (identifiedPath.getPath().equals((Object)AslExtractedColumn.ARCHETYPE_NODE_ID.getPath()) && !EnumSet.of(ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, ComparisonOperatorPredicate.PredicateComparisonOperator.NEQ).contains(predicate.getOperator())) {
                    throw new AqlFeatureNotImplementedException("Predicates on 'archetype_node_id' only support = and !=");
                }
                FeatureCheckUtils.ensureOperandSupported(pathWithType, predicate.getValue(), this.systemService.getSystemId());
            });
        }
    }

    private static Optional<AncestorStructureRmType> ensureAbstractStructureContainsSupported(ContainmentClassExpression nextContainment, StructureRoot structure) {
        Optional abstractType = AncestorStructureRmType.byTypeName((String)nextContainment.getType());
        abstractType.ifPresent(at -> {
            if (structure == null && at.getStructureRoot() == null) {
                throw new IllegalAqlException("It is unclear if %s targets a COMPOSITION or EHR_STATUS".formatted(nextContainment.getType()));
            }
            if (!at.getNonStructureDescendants().isEmpty()) {
                throw new AqlFeatureNotImplementedException("CONTAINS %s: abstract type with non structure descendants (%s) not yet supported".formatted(nextContainment.getType(), at.getNonStructureDescendants().stream().map(Class::getSimpleName).toList()));
            }
        });
        return abstractType;
    }
}

