/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.pathanalysis;

import com.nedap.archie.rm.datavalues.quantity.DvOrdered;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.openehr.aqlengine.AqlQueryUtils;
import org.ehrbase.openehr.aqlengine.pathanalysis.ANode;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathAnalysis;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathCohesionAnalysis;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsWrapper;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.orderby.OrderByExpression;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;

public final class PathInfo {
    private static final Set<String> DV_ORDERED_TYPES = ArchieRMInfoLookup.getInstance().getTypeInfo(DvOrdered.class).getAllDescendantClasses().stream().map(RMTypeInfo::getRmName).collect(Collectors.toSet());
    private final PathCohesionAnalysis.PathCohesionTreeNode cohesionTreeRoot;
    private final Map<IdentifiedPath, Pair<ANode, Map<ANode, Map<String, PathAnalysis.AttInfo>>>> pathAttributeInfo;
    private final Map<PathCohesionAnalysis.PathCohesionTreeNode, NodeInfo> nodeTypeInfo;
    private final Map<IdentifiedPath, Set<QueryClause>> pathToQueryClause;

    public PathInfo(PathCohesionAnalysis.PathCohesionTreeNode cohesionTreeRoot, Map<IdentifiedPath, Set<QueryClause>> pathToQueryClause) {
        this.cohesionTreeRoot = cohesionTreeRoot;
        this.pathAttributeInfo = cohesionTreeRoot.getPaths().stream().collect(Collectors.toMap(ip -> ip, ip -> {
            String string;
            AbstractContainmentExpression root = ip.getRoot();
            if (root instanceof ContainmentClassExpression) {
                ContainmentClassExpression cce = (ContainmentClassExpression)root;
                string = cce.getType();
            } else {
                string = "ORIGINAL_VERSION";
            }
            ANode analyzed = PathAnalysis.analyzeAqlPathTypes(string, ip.getRootPredicate(), root.getPredicates(), ip.getPath(), null);
            if (analyzed.getCandidateTypes().isEmpty()) {
                throw new IllegalArgumentException("Path %s is not valid".formatted(ip.render()));
            }
            return Pair.of((Object)analyzed, PathAnalysis.createAttributeInfos(analyzed));
        }));
        this.nodeTypeInfo = this.fillNodeTypeInfo(cohesionTreeRoot, -1, new HashMap<PathCohesionAnalysis.PathCohesionTreeNode, NodeInfo>());
        this.pathToQueryClause = pathToQueryClause;
    }

    private Map<PathCohesionAnalysis.PathCohesionTreeNode, NodeInfo> fillNodeTypeInfo(PathCohesionAnalysis.PathCohesionTreeNode currentNode, int level, Map<PathCohesionAnalysis.PathCohesionTreeNode, NodeInfo> nodeTypeInfo) {
        NodeInfo nodeInfo = currentNode.getPaths().stream().map(ip -> this.nodeTypeInfoForPathAtLevel((IdentifiedPath)ip, level)).reduce((a, b) -> new NodeInfo(PathInfo.mergeNodeCategories(a.category(), b.category()), PathInfo.mutableUnion(a.rmTypes(), b.rmTypes()), a.pathFromRoot(), a.multipleValued() || b.multipleValued(), PathInfo.mutableUnion(a.dvOrderedTypes(), b.dvOrderedTypes()))).orElseThrow();
        nodeTypeInfo.put(currentNode, nodeInfo);
        currentNode.getChildren().forEach(pcn -> this.fillNodeTypeInfo((PathCohesionAnalysis.PathCohesionTreeNode)pcn, level + 1, nodeTypeInfo));
        return nodeTypeInfo;
    }

    private static <T> Set<T> mutableUnion(Set<T> a, Set<T> b) {
        return new HashSet(SetUtils.union(a, b));
    }

    public static ANode.NodeCategory mergeNodeCategories(ANode.NodeCategory a, ANode.NodeCategory b) {
        if (a == b) {
            return a;
        }
        boolean sorted = a.ordinal() < b.ordinal();
        ANode.NodeCategory c0 = sorted ? a : b;
        ANode.NodeCategory c1 = sorted ? b : a;
        switch (c0) {
            default: {
                throw new MatchException(null, null);
            }
            case STRUCTURE: 
            case STRUCTURE_INTERMEDIATE: {
                throw new IllegalArgumentException("Incompatible node types: %s, %s".formatted(new Object[]{a, b}));
            }
            case RM_TYPE: 
            case FOUNDATION: {
                break;
            }
            case FOUNDATION_EXTENDED: {
                throw new IllegalArgumentException("Inconsistent node types: %s, %s".formatted(new Object[]{a, b}));
            }
        }
        return ANode.NodeCategory.FOUNDATION_EXTENDED;
    }

    public static List<AqlObjectPath.PathNode> pathNodes(AqlObjectPath path) {
        return Optional.ofNullable(path).map(AqlObjectPath::getPathNodes).orElseGet(List::of);
    }

    private NodeInfo nodeTypeInfoForPathAtLevel(IdentifiedPath ip, int level) {
        Pair<ANode, Map<ANode, Map<String, PathAnalysis.AttInfo>>> aNodeWithInfo = this.pathAttributeInfo.get(ip);
        ANode aNode = (ANode)aNodeWithInfo.getLeft();
        Map attributeInfos = (Map)aNodeWithInfo.getRight();
        List<AqlObjectPath.PathNode> pathNodes = PathInfo.pathNodes(ip.getPath());
        String attribute = null;
        PathAnalysis.AttInfo attInfo = null;
        for (int i = 0; i <= level; ++i) {
            attribute = pathNodes.get(i).getAttribute();
            attInfo = (PathAnalysis.AttInfo)((Map)attributeInfos.get(aNode)).get(attribute);
            aNode = aNode.getAttribute(attribute);
        }
        ANode.NodeCategory nodeCategory = (ANode.NodeCategory)((Object)aNode.getCategories().stream().reduce(PathInfo::mergeNodeCategories).orElseThrow());
        return new NodeInfo(nodeCategory, Optional.ofNullable(attInfo).map(PathAnalysis.AttInfo::targetTypes).orElse(aNode.getCandidateTypes()), level < 0 ? List.of() : Collections.unmodifiableList(PathInfo.pathNodes(ip.getPath()).subList(0, level + 1)), Optional.ofNullable(attInfo).map(PathAnalysis.AttInfo::multipleValued).orElse(false), Optional.ofNullable(attInfo).map(PathAnalysis.AttInfo::targetTypes).map(t -> SetUtils.intersection((Set)t, DV_ORDERED_TYPES)).orElse(Collections.emptySet()));
    }

    public static Map<ContainsWrapper, PathInfo> createPathInfos(AqlQuery aqlQuery, Map<AbstractContainmentExpression, ContainsWrapper> containsDescs) {
        Map<AbstractContainmentExpression, PathCohesionAnalysis.PathCohesionTreeNode> pathCohesion = PathCohesionAnalysis.analyzePathCohesion(aqlQuery);
        Map pathToQueryClause = Collections.unmodifiableMap(Stream.of(aqlQuery.getSelect().getStatement().stream().flatMap(AqlQueryUtils::allIdentifiedPaths).map(p -> Pair.of((Object)p, (Object)((Object)QueryClause.SELECT))), AqlQueryUtils.streamWhereConditions(aqlQuery.getWhere()).flatMap(AqlQueryUtils::allIdentifiedPaths).map(p -> Pair.of((Object)p, (Object)((Object)QueryClause.WHERE))), Optional.of(aqlQuery).map(AqlQuery::getOrderBy).stream().flatMap(Collection::stream).map(OrderByExpression::getStatement).map(p -> Pair.of((Object)p, (Object)((Object)QueryClause.ORDER_BY)))).flatMap(s -> s).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toUnmodifiableSet()))));
        return containsDescs.entrySet().stream().filter(e -> pathCohesion.containsKey(e.getKey())).filter(e -> {
            ContainmentClassExpression cce;
            Object patt0$temp = e.getKey();
            return !(patt0$temp instanceof ContainmentClassExpression && "EHR".equals((cce = (ContainmentClassExpression)patt0$temp).getType()));
        }).collect(Collectors.toMap(Map.Entry::getValue, e -> new PathInfo((PathCohesionAnalysis.PathCohesionTreeNode)pathCohesion.get(e.getKey()), pathToQueryClause), (a, b) -> null, LinkedHashMap::new));
    }

    public PathCohesionAnalysis.PathCohesionTreeNode getCohesionTreeRoot() {
        return this.cohesionTreeRoot;
    }

    public ANode.NodeCategory getNodeCategory(PathCohesionAnalysis.PathCohesionTreeNode node) {
        return Optional.of(node).map(this.nodeTypeInfo::get).map(NodeInfo::category).orElseThrow();
    }

    public Set<String> getTargetTypes(PathCohesionAnalysis.PathCohesionTreeNode node) {
        return Optional.of(node).map(this.nodeTypeInfo::get).map(NodeInfo::rmTypes).orElseThrow();
    }

    public Set<String> getDvOrderedTypes(PathCohesionAnalysis.PathCohesionTreeNode node) {
        return Optional.of(node).map(this.nodeTypeInfo::get).map(NodeInfo::dvOrderedTypes).orElseThrow();
    }

    public boolean isUsedInSelect(PathCohesionAnalysis.PathCohesionTreeNode node) {
        return Optional.of(node).stream().map(PathCohesionAnalysis.PathCohesionTreeNode::getPathsEndingAtNode).flatMap(Collection::stream).map(this.pathToQueryClause::get).filter(Objects::nonNull).flatMap(Collection::stream).anyMatch(QueryClause.SELECT::equals);
    }

    public boolean isUsedInWhereOrOrderBy(PathCohesionAnalysis.PathCohesionTreeNode node) {
        return Optional.of(node).stream().map(PathCohesionAnalysis.PathCohesionTreeNode::getPathsEndingAtNode).flatMap(Collection::stream).map(this.pathToQueryClause::get).filter(Objects::nonNull).flatMap(Collection::stream).anyMatch(c -> QueryClause.WHERE.equals(c) || QueryClause.ORDER_BY.equals(c));
    }

    public boolean isMultipleValued(PathCohesionAnalysis.PathCohesionTreeNode node) {
        return Optional.of(node).map(this.nodeTypeInfo::get).map(NodeInfo::multipleValued).orElseThrow();
    }

    public List<AqlObjectPath.PathNode> getPathToNode(PathCohesionAnalysis.PathCohesionTreeNode node) {
        return Optional.of(node).map(this.nodeTypeInfo::get).map(NodeInfo::pathFromRoot).orElseThrow();
    }

    private static boolean isData(ANode.NodeCategory nc) {
        return switch (nc) {
            default -> throw new MatchException(null, null);
            case ANode.NodeCategory.STRUCTURE, ANode.NodeCategory.STRUCTURE_INTERMEDIATE -> false;
            case ANode.NodeCategory.RM_TYPE, ANode.NodeCategory.FOUNDATION, ANode.NodeCategory.FOUNDATION_EXTENDED -> true;
        };
    }

    public JoinMode joinMode(PathCohesionAnalysis.PathCohesionTreeNode node) {
        boolean hasData;
        if (node.isRoot()) {
            return JoinMode.ROOT;
        }
        boolean bl = hasData = !node.getPathsEndingAtNode().isEmpty() || node.getChildren().stream().anyMatch(c -> PathInfo.isData(this.getNodeCategory((PathCohesionAnalysis.PathCohesionTreeNode)c)));
        if (hasData) {
            return JoinMode.DATA;
        }
        int structureChildCount = (int)node.getChildren().stream().filter(c -> !PathInfo.isData(this.getNodeCategory((PathCohesionAnalysis.PathCohesionTreeNode)c))).count();
        return switch (structureChildCount) {
            case 0 -> throw new IllegalArgumentException("Internal node without children: %s".formatted(node));
            case 1 -> JoinMode.INTERNAL_SINGLE_CHILD;
            default -> JoinMode.INTERNAL_FORK;
        };
    }

    public record NodeInfo(ANode.NodeCategory category, Set<String> rmTypes, List<AqlObjectPath.PathNode> pathFromRoot, boolean multipleValued, Set<String> dvOrderedTypes) {
    }

    private static enum QueryClause {
        SELECT,
        WHERE,
        ORDER_BY;

    }

    public static enum JoinMode {
        ROOT,
        DATA,
        INTERNAL_SINGLE_CHILD,
        INTERNAL_FORK;

    }
}

