/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.re2j.Pattern;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.api.exception.BadGatewayException;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.service.AqlQueryRequest;
import org.ehrbase.api.service.AqlQueryService;
import org.ehrbase.openehr.aqlengine.AqlParameterReplacement;
import org.ehrbase.openehr.aqlengine.AqlQueryUtils;
import org.ehrbase.openehr.aqlengine.asl.AqlSqlLayer;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.featurecheck.AqlQueryFeatureCheck;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.select.SelectWrapper;
import org.ehrbase.openehr.aqlengine.repository.AqlQueryRepository;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.sdk.aql.render.AqlRenderer;
import org.ehrbase.openehr.sdk.aql.util.AqlUtil;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryResultDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.query.ResultHolder;
import org.ehrbase.openehr.sdk.validation.terminology.ExternalTerminologyValidation;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class AqlQueryServiceImp
implements AqlQueryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AqlQueryRepository aqlQueryRepository;
    private final ExternalTerminologyValidation tsAdapter;
    private final AqlSqlLayer aqlSqlLayer;
    private final AqlQueryFeatureCheck aqlQueryFeatureCheck;

    @Autowired
    public AqlQueryServiceImp(AqlQueryRepository aqlQueryRepository, ExternalTerminologyValidation tsAdapter, AqlSqlLayer aqlSqlLayer, AqlQueryFeatureCheck aqlQueryFeatureCheck) {
        this.aqlQueryRepository = aqlQueryRepository;
        this.tsAdapter = tsAdapter;
        this.aqlSqlLayer = aqlSqlLayer;
        this.aqlQueryFeatureCheck = aqlQueryFeatureCheck;
    }

    public QueryResultDto query(AqlQueryRequest aqlQuery) {
        return this.queryAql(aqlQuery);
    }

    private QueryResultDto queryAql(AqlQueryRequest aqlQueryRequest) {
        try {
            AqlQuery aqlQuery = AqlQueryParser.parse((String)aqlQueryRequest.queryString());
            aqlQuery.setLimit(Optional.ofNullable(aqlQuery.getLimit()).orElse(aqlQueryRequest.fetch()));
            aqlQuery.setOffset(Optional.ofNullable(aqlQuery.getOffset()).orElse(aqlQueryRequest.offset()));
            if (aqlQuery.getOffset() != null && aqlQuery.getLimit() == null) {
                throw new InvalidApiParameterException("Invalid AQL query: provided offset %s without a limit".formatted(aqlQuery.getOffset()));
            }
            AqlParameterReplacement.replaceParameters(aqlQuery, aqlQueryRequest.parameters());
            AqlQueryServiceImp.replaceEhrPaths(aqlQuery);
            this.aqlQueryFeatureCheck.ensureQuerySupported(aqlQuery);
            try {
                AqlQueryWrapper queryWrapper = AqlQueryWrapper.create(aqlQuery);
                AslRootQuery aslQuery = this.aqlSqlLayer.buildAslRootQuery(queryWrapper);
                List<SelectWrapper> nonPrimitiveSelects = queryWrapper.nonPrimitiveSelects().toList();
                List<List<Object>> result = this.aqlQueryRepository.executeQuery(aslQuery, nonPrimitiveSelects);
                if (nonPrimitiveSelects.isEmpty()) {
                    result = LongStream.range(0L, (Long)result.getFirst().getFirst()).mapToObj(i -> new ArrayList()).toList();
                }
                List<SelectWrapper> selects = queryWrapper.selects();
                for (int i2 = 0; i2 < selects.size(); ++i2) {
                    SelectWrapper sd = selects.get(i2);
                    if (sd.type() != SelectWrapper.SelectType.PRIMITIVE) continue;
                    Constable value = sd.getPrimitive().getValue();
                    for (List<Object> row : result) {
                        row.add(i2, value);
                    }
                }
                if (this.logger.isTraceEnabled()) {
                    try {
                        this.logger.trace(new ObjectMapper().writeValueAsString((Object)aqlQuery));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                String understoodByAqlParser = AqlRenderer.render((AqlQuery)aqlQuery);
                return this.formatResult(queryWrapper, result, understoodByAqlParser);
            }
            catch (IllegalArgumentException e) {
                throw new InternalServerException(e.getMessage(), (Throwable)e);
            }
        }
        catch (RestClientException e) {
            throw new BadGatewayException("Bad gateway: %s".formatted(Optional.of(e).map(Throwable::getCause).orElse(e).getMessage()), (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Data Access Error: %s".formatted(Optional.of(e).map(Throwable::getCause).orElse(e).getMessage()), (Throwable)e);
        }
        catch (AqlParseException e) {
            throw new IllegalAqlException("Could not parse AQL query: %s".formatted(Optional.of(e).map(Throwable::getCause).orElse(e).getMessage()), (Throwable)e);
        }
    }

    private QueryResultDto formatResult(AqlQueryWrapper query, List<List<Object>> resultData, String queryString) {
        List<SelectWrapper> selectFields = query.selects();
        QueryResultDto dto = new QueryResultDto();
        dto.setExecutedAQL(queryString);
        Optional.ofNullable(query.limit()).ifPresent(v -> dto.setLimit(Integer.valueOf(v.intValue())));
        Optional.ofNullable(query.offset()).ifPresent(v -> dto.setOffset(Integer.valueOf(v.intValue())));
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        for (int i = 0; i < selectFields.size(); ++i) {
            SelectWrapper namePath = selectFields.get(i);
            columns.put(Optional.of(namePath).map(SelectWrapper::getSelectAlias).orElse("#" + i), namePath.getSelectPath().orElse(null));
        }
        dto.setVariables(columns);
        List<ResultHolder> resultList = resultData.stream().map(r -> {
            ResultHolder fieldMap = new ResultHolder();
            for (int i = 0; i < r.size(); ++i) {
                Object c = r.get(i);
                fieldMap.putResult(Optional.ofNullable(((SelectWrapper)selectFields.get(i)).getSelectAlias()).orElse("#" + i), c);
            }
            return fieldMap;
        }).toList();
        dto.setResultSet(resultList);
        return dto;
    }

    static void replaceEhrPaths(AqlQuery aqlQuery) {
        AqlQueryServiceImp.replaceEhrPath(aqlQuery, "compositions", "COMPOSITION", "c");
        AqlQueryServiceImp.replaceEhrPath(aqlQuery, "ehr_status", "EHR_STATUS", "s");
    }

    static void replaceEhrPath(AqlQuery aqlQuery, String ehrPath, String type, String aliasPrefix) {
        List<IdentifiedPath> ehrPaths = AqlQueryUtils.allIdentifiedPaths(aqlQuery).filter(ip -> {
            ContainmentClassExpression cce;
            AbstractContainmentExpression patt0$temp = ip.getRoot();
            return patt0$temp instanceof ContainmentClassExpression && (cce = (ContainmentClassExpression)patt0$temp).getType().equals("EHR");
        }).filter(ip -> Optional.of(ip).map(IdentifiedPath::getPath).map(AqlObjectPath::getPathNodes).map(List::getFirst).map(AqlObjectPath.PathNode::getAttribute).filter(ehrPath::equals).isPresent()).toList();
        if (ehrPaths.isEmpty()) {
            return;
        }
        if (ehrPaths.stream().map(IdentifiedPath::getRoot).map(AbstractContainmentExpression::getIdentifier).distinct().count() > 1L) {
            throw new AqlFeatureNotImplementedException("Multiple EHR in FROM are not supported");
        }
        if (ehrPaths.stream().map(IdentifiedPath::getRootPredicate).anyMatch(CollectionUtils::isNotEmpty)) {
            throw new AqlFeatureNotImplementedException("Root predicates for EHR/%s are not supported".formatted(ehrPath));
        }
        if (ehrPaths.stream().map(IdentifiedPath::getPath).map(p -> ((AqlObjectPath.PathNode)p.getPathNodes().getFirst()).getPredicateOrOperands()).distinct().count() > 1L) {
            throw new AqlFeatureNotImplementedException("Specifying different predicates for EHR/%s is not supported".formatted(ehrPath));
        }
        String alias = AqlUtil.streamContainments((Containment)aqlQuery.getFrom()).map(AbstractContainmentExpression::getIdentifier).filter(Objects::nonNull).filter(s -> s.matches(Pattern.quote((String)aliasPrefix) + "\\d*")).map(s -> aliasPrefix.equals(s) ? 0L : Long.parseLong(s.substring(1))).max(Comparator.naturalOrder()).map(i -> aliasPrefix + (i + 1L)).orElse(aliasPrefix);
        ContainmentClassExpression ehrContainment = (ContainmentClassExpression)ehrPaths.getFirst().getRoot();
        ContainmentClassExpression ehrStatusContainment = new ContainmentClassExpression();
        ehrStatusContainment.setType(type);
        ehrStatusContainment.setIdentifier(alias);
        ehrPaths.stream().findFirst().map(IdentifiedPath::getPath).map(p -> ((AqlObjectPath.PathNode)p.getPathNodes().getFirst()).getPredicateOrOperands()).ifPresent(arg_0 -> ((ContainmentClassExpression)ehrStatusContainment).setPredicates(arg_0));
        if (ehrContainment.getContains() == null) {
            ehrContainment.setContains((Containment)ehrStatusContainment);
        } else {
            ContainmentSetOperator cse;
            Containment containment = ehrContainment.getContains();
            if (containment instanceof ContainmentSetOperator && (cse = (ContainmentSetOperator)containment).getSymbol() == ContainmentSetOperatorSymbol.AND) {
                cse.setValues(Stream.concat(Stream.of(ehrStatusContainment), cse.getValues().stream()).toList());
            } else {
                ContainmentSetOperator and = new ContainmentSetOperator();
                and.setSymbol(ContainmentSetOperatorSymbol.AND);
                and.setValues(List.of(ehrStatusContainment, ehrContainment.getContains()));
                ehrContainment.setContains((Containment)and);
            }
        }
        ehrPaths.forEach(ip -> {
            ip.setRoot((AbstractContainmentExpression)ehrStatusContainment);
            List pathNodes = ip.getPath().getPathNodes();
            ip.setPath(pathNodes.size() == 1 ? null : new AqlObjectPath(pathNodes.subList(1, pathNodes.size())));
        });
    }
}

