/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.util.AdditionalSQLFunctions;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslAndQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslDescendantCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslDvOrderedValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslEntityIdxOffsetCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFalseQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotNullQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslOrQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslProvidesJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslTrueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslAuditDetailsJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslDelegatingJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.sql.AqlSqlQueryBuilder;
import org.ehrbase.openehr.aqlengine.sql.FieldUtils;
import org.ehrbase.openehr.dbformat.RmAttributeAlias;
import org.ehrbase.openehr.dbformat.RmTypeAlias;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.DSL;

final class ConditionUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ConditionUtils() {
    }

    public static Condition buildJoinCondition(AslJoin aslJoin, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        Table<?> sqlLeft = aslQueryToTable.getDataTable(aslJoin.getLeft());
        Table<?> sqlRight = aslQueryToTable.getDataTable(aslJoin.getRight());
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        block5: for (AslJoinCondition jc : aslJoin.getOn()) {
            AslJoinCondition aslJoinCondition;
            Objects.requireNonNull(jc);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslDelegatingJoinCondition.class, AslPathFilterJoinCondition.class, AslAuditDetailsJoinCondition.class}, (Object)aslJoinCondition, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    AslDelegatingJoinCondition desc = (AslDelegatingJoinCondition)aslJoinCondition;
                    ConditionUtils.addDelegatingJoinConditions(desc, conditions, sqlLeft, sqlRight);
                    continue block5;
                }
                case 1: {
                    AslPathFilterJoinCondition filterCondition = (AslPathFilterJoinCondition)aslJoinCondition;
                    conditions.add(ConditionUtils.buildCondition(filterCondition.getCondition(), aslQueryToTable, true));
                    continue block5;
                }
                case 2: 
            }
            AslAuditDetailsJoinCondition ac = (AslAuditDetailsJoinCondition)aslJoinCondition;
            conditions.add(FieldUtils.field(sqlLeft, aslJoin.getLeft(), ac.getLeftOwner(), AslStructureColumn.AUDIT_ID.getFieldName(), UUID.class, true).eq(FieldUtils.field(sqlRight, aslJoin.getRight(), ac.getRightOwner(), Tables.AUDIT_DETAILS.ID.getName(), UUID.class, true)));
        }
        return conditions.stream().reduce(DSL.noCondition(), DSL::and);
    }

    private static void addDelegatingJoinConditions(AslDelegatingJoinCondition joinCondition, List<Condition> conditions, Table<?> sqlLeft, Table<?> sqlRight) {
        Stream<Condition> stream;
        AslProvidesJoinCondition aslProvidesJoinCondition = joinCondition.getDelegate();
        Objects.requireNonNull(aslProvidesJoinCondition);
        AslProvidesJoinCondition aslProvidesJoinCondition2 = aslProvidesJoinCondition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslEntityIdxOffsetCondition.class, AslDescendantCondition.class}, (Object)aslProvidesJoinCondition2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AslEntityIdxOffsetCondition c = (AslEntityIdxOffsetCondition)aslProvidesJoinCondition2;
                stream = ConditionUtils.entityIdxOffsetConditions(c, sqlLeft, sqlRight, true);
                break;
            }
            case 1: {
                AslDescendantCondition c = (AslDescendantCondition)aslProvidesJoinCondition2;
                stream = ConditionUtils.descendantConditions(c, sqlLeft, sqlRight, true);
            }
        }
        stream.forEach(conditions::add);
    }

    private static Stream<Condition> entityIdxOffsetConditions(AslEntityIdxOffsetCondition ic, Table<?> sqlLeft, Table<?> sqlRight, boolean isJoinCondition) {
        return Stream.of(FieldUtils.field(sqlLeft, ic.getLeftProvider(), ic.getLeftOwner(), AslStructureColumn.ENTITY_IDX_LEN.getFieldName(), Integer.class, true).add((Number)ic.getOffset()).eq(FieldUtils.field(sqlRight, ic.getRightProvider(), ic.getRightOwner(), AslStructureColumn.ENTITY_IDX_LEN.getFieldName(), Integer.class, isJoinCondition)));
    }

    private static Stream<Condition> descendantConditions(AslDescendantCondition dc, Table<?> sqlLeft, Table<?> sqlRight, boolean isJoinCondition) {
        AslStructureQuery.AslSourceRelation parentRelation = dc.getParentRelation();
        if (!EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS, AslStructureQuery.AslSourceRelation.EHR).contains((Object)parentRelation)) {
            throw new IllegalArgumentException("unexpected parent relation type %s".formatted(new Object[]{parentRelation}));
        }
        if (!EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS).contains((Object)dc.getDescendantRelation())) {
            throw new IllegalArgumentException("unexpected descendant relation type %s".formatted(new Object[]{dc.getDescendantRelation()}));
        }
        return switch (parentRelation) {
            default -> throw new MatchException(null, null);
            case AslStructureQuery.AslSourceRelation.EHR -> Stream.of(FieldUtils.field(sqlLeft, dc.getLeftProvider(), dc.getLeftOwner(), "id", UUID.class, true).eq(FieldUtils.field(sqlRight, dc.getRightProvider(), dc.getRightOwner(), AslStructureColumn.EHR_ID.getFieldName(), UUID.class, isJoinCondition)));
            case AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS -> {
                AslStructureColumn pKeyField = parentRelation == AslStructureQuery.AslSourceRelation.COMPOSITION ? AslStructureColumn.VO_ID : AslStructureColumn.EHR_ID;
                yield Stream.of(FieldUtils.field(sqlLeft, dc.getLeftProvider(), dc.getLeftOwner(), pKeyField.getFieldName(), UUID.class, true).eq(FieldUtils.field(sqlRight, dc.getRightProvider(), dc.getRightOwner(), pKeyField.getFieldName(), UUID.class, isJoinCondition)), FieldUtils.field(sqlLeft, dc.getLeftProvider(), dc.getLeftOwner(), AslStructureColumn.ENTITY_IDX.getFieldName(), String.class, true).lt(FieldUtils.field(sqlRight, dc.getRightProvider(), dc.getRightOwner(), AslStructureColumn.ENTITY_IDX.getFieldName(), String.class, isJoinCondition)), FieldUtils.field(sqlLeft, dc.getLeftProvider(), dc.getLeftOwner(), AslStructureColumn.ENTITY_IDX_CAP.getFieldName(), String.class, true).gt(FieldUtils.field(sqlRight, dc.getRightProvider(), dc.getRightOwner(), AslStructureColumn.ENTITY_IDX.getFieldName(), String.class, isJoinCondition)));
            }
            case AslStructureQuery.AslSourceRelation.FOLDER -> throw new NotImplementedException("Joining FOLDER is not yet supported");
            case AslStructureQuery.AslSourceRelation.AUDIT_DETAILS -> throw new IllegalArgumentException("Descendant condition not applicable to AUDIT_DETAILS");
        };
    }

    public static Condition buildCondition(AslQueryCondition c, AqlSqlQueryBuilder.AslQueryTables tables, boolean useAliases) {
        AslQueryCondition aslQueryCondition = c;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslAndQueryCondition.class, AslOrQueryCondition.class, AslNotQueryCondition.class, AslFalseQueryCondition.class, AslTrueQueryCondition.class, AslNotNullQueryCondition.class, AslFieldValueQueryCondition.class, AslEntityIdxOffsetCondition.class, AslDescendantCondition.class}, (Object)aslQueryCondition, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> DSL.noCondition();
            case 0 -> {
                AslAndQueryCondition and = (AslAndQueryCondition)aslQueryCondition;
                yield DSL.and(and.getOperands().stream().map(o -> ConditionUtils.buildCondition(o, tables, useAliases)).toList());
            }
            case 1 -> {
                AslOrQueryCondition or = (AslOrQueryCondition)aslQueryCondition;
                yield DSL.or(or.getOperands().stream().map(o -> ConditionUtils.buildCondition(o, tables, useAliases)).toList());
            }
            case 2 -> {
                AslNotQueryCondition not = (AslNotQueryCondition)aslQueryCondition;
                yield DSL.not((Condition)ConditionUtils.buildCondition(not.getCondition(), tables, useAliases));
            }
            case 3 -> {
                AslFalseQueryCondition __ = (AslFalseQueryCondition)aslQueryCondition;
                yield DSL.falseCondition();
            }
            case 4 -> {
                AslTrueQueryCondition __ = (AslTrueQueryCondition)aslQueryCondition;
                yield DSL.trueCondition();
            }
            case 5 -> {
                AslNotNullQueryCondition nn = (AslNotNullQueryCondition)aslQueryCondition;
                yield ConditionUtils.notNullCondition(tables, useAliases, nn);
            }
            case 6 -> {
                AslFieldValueQueryCondition fv = (AslFieldValueQueryCondition)aslQueryCondition;
                yield ConditionUtils.buildFieldValueCondition(tables, useAliases, fv);
            }
            case 7 -> {
                AslEntityIdxOffsetCondition ic = (AslEntityIdxOffsetCondition)aslQueryCondition;
                yield DSL.and(ConditionUtils.entityIdxOffsetConditions(ic, tables.getDataTable(ic.getLeftProvider()), tables.getDataTable(ic.getRightProvider()), false).toList());
            }
            case 8 -> {
                AslDescendantCondition dc = (AslDescendantCondition)aslQueryCondition;
                yield DSL.and(ConditionUtils.descendantConditions(dc, tables.getDataTable(dc.getLeftProvider()), dc.getParentRelation() == AslStructureQuery.AslSourceRelation.EHR ? tables.getVersionTable(dc.getRightProvider()) : tables.getDataTable(dc.getRightProvider()), false).toList());
            }
        };
    }

    @Nonnull
    private static Condition notNullCondition(AqlSqlQueryBuilder.AslQueryTables tables, boolean useAliases, AslNotNullQueryCondition nn) {
        AslField field = nn.getField();
        if (field.getExtractedColumn() != null) {
            return DSL.trueCondition();
        }
        if (field instanceof AslColumnField) {
            AslColumnField f = (AslColumnField)field;
            return (f.isVersionTableField() ? tables.getVersionTable(field.getProvider()) : tables.getDataTable(field.getProvider())).field(f.getName(useAliases)).isNotNull();
        }
        throw new IllegalArgumentException("Unsupported field type: %s".formatted(field.getClass().getSimpleName()));
    }

    private static Condition buildFieldValueCondition(AqlSqlQueryBuilder.AslQueryTables tables, boolean useAliases, AslFieldValueQueryCondition fv) {
        AslField field = fv.getField();
        AslQuery internalProvider = field.getInternalProvider();
        if (fv instanceof AslDvOrderedValueQueryCondition) {
            AslDvOrderedValueQueryCondition dvc = (AslDvOrderedValueQueryCondition)fv;
            Field<JSONB> sqlDvOrderedField = FieldUtils.field(tables.getDataTable(internalProvider), (AslColumnField)field, JSONB.class, useAliases);
            Field sqlMagnitudeField = AdditionalSQLFunctions.jsonb_dv_ordered_magnitude(sqlDvOrderedField);
            Field sqlTypeField = DSL.jsonbGetAttributeAsText(sqlDvOrderedField, (String)RmAttributeAlias.getAlias((String)"_type"));
            List<String> types = dvc.getTypesToCompare().stream().map(RmTypeAlias::getAlias).toList();
            return ConditionUtils.applyOperator(AslQueryCondition.AslConditionOperator.IN, sqlTypeField, types).and(ConditionUtils.applyOperator(dvc.getOperator(), sqlMagnitudeField, dvc.getValues()));
        }
        AslField aslField = field;
        Objects.requireNonNull(aslField);
        AslField aslField2 = aslField;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslComplexExtractedColumnField.class, AslColumnField.class, AslConstantField.class, AslAggregatingField.class}, (Object)aslField2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslComplexExtractedColumnField ecf = (AslComplexExtractedColumnField)aslField2;
                yield ConditionUtils.complexExtractedColumnCondition(useAliases, fv, ecf, tables.getDataTable(internalProvider), tables.getVersionTable(internalProvider));
            }
            case 1 -> {
                AslColumnField f = (AslColumnField)aslField2;
                yield ConditionUtils.applyOperator(fv.getOperator(), FieldUtils.field(f.isVersionTableField() ? tables.getVersionTable(internalProvider) : tables.getDataTable(internalProvider), f, useAliases), fv.getValues());
            }
            case 2 -> {
                AslConstantField f = (AslConstantField)aslField2;
                yield ConditionUtils.applyOperator(fv.getOperator(), (Field)DSL.inline(f.getValue(), f.getType()), fv.getValues());
            }
            case 3 -> {
                AslAggregatingField __ = (AslAggregatingField)aslField2;
                throw new IllegalArgumentException("AslAggregatingField cannot be used in WHERE");
            }
        };
    }

    @Nonnull
    private static Condition complexExtractedColumnCondition(boolean useAliases, AslFieldValueQueryCondition<?> fv, AslComplexExtractedColumnField ecf, Table<?> dataTable, Table<?> versionTable) {
        return switch (ecf.getExtractedColumn()) {
            default -> throw new MatchException(null, null);
            case AslExtractedColumn.VO_ID -> {
                AslQueryCondition.AslConditionOperator op = fv.getOperator() == AslQueryCondition.AslConditionOperator.IN ? AslQueryCondition.AslConditionOperator.EQ : fv.getOperator();
                yield fv.getValues().stream().map(String.class::cast).map(id -> ConditionUtils.voIdCondition(versionTable, useAliases, id, op, ecf)).reduce(DSL.noCondition(), DSL::or);
            }
            case AslExtractedColumn.ARCHETYPE_NODE_ID -> {
                AslQueryCondition.AslConditionOperator op = fv.getOperator() == AslQueryCondition.AslConditionOperator.IN ? AslQueryCondition.AslConditionOperator.EQ : fv.getOperator();
                yield fv.getValues().stream().map(AslRmTypeAndConcept.class::cast).map(p -> ConditionUtils.archetypeNodeIdCondition(dataTable, useAliases, ecf, p, op)).reduce(DSL.noCondition(), DSL::or);
            }
            case AslExtractedColumn.TEMPLATE_ID, AslExtractedColumn.NAME_VALUE, AslExtractedColumn.EHR_ID, AslExtractedColumn.OV_CONTRIBUTION_ID, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.AD_SYSTEM_ID, AslExtractedColumn.AD_DESCRIPTION_DV, AslExtractedColumn.AD_DESCRIPTION_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_DV, AslExtractedColumn.AD_CHANGE_TYPE_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING, AslExtractedColumn.AD_CHANGE_TYPE_PREFERRED_TERM, AslExtractedColumn.AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE, AslExtractedColumn.EHR_TIME_CREATED_DV, AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_SYSTEM_ID, AslExtractedColumn.EHR_SYSTEM_ID_DV -> throw new IllegalArgumentException("Extracted column %s is not complex".formatted(new Object[]{ecf.getExtractedColumn()}));
        };
    }

    private static Condition archetypeNodeIdCondition(Table<?> src, boolean aliasedNames, AslComplexExtractedColumnField ecf, AslRmTypeAndConcept rmTypeAndConcept, AslQueryCondition.AslConditionOperator op) {
        return Stream.of(Pair.of((Object)Tables.COMP_DATA.RM_ENTITY, (Object)rmTypeAndConcept.aliasedRmType()), Pair.of((Object)Tables.COMP_DATA.ENTITY_CONCEPT, (Object)rmTypeAndConcept.concept())).filter(p -> p.getValue() != null).map(p1 -> ConditionUtils.applyOperator(op, FieldUtils.field(src, ecf, ((TableField)p1.getKey()).getName(), aliasedNames), List.of((String)p1.getValue()))).reduce(DSL.noCondition(), op == AslQueryCondition.AslConditionOperator.NEQ ? DSL::or : DSL::and);
    }

    @Nonnull
    private static Condition voIdCondition(Table<?> versionTable, boolean aliasedNames, String id, AslQueryCondition.AslConditionOperator op, AslComplexExtractedColumnField field) {
        String[] split = id.split("::");
        Field uuidField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.VO_ID.getName(), aliasedNames);
        Field<?> versionField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.SYS_VERSION.getName(), aliasedNames);
        Field uuid = DSL.inline((String)split[0]).cast(UUID.class);
        Optional<Field> version = Optional.of(split).filter(s -> ((String[])s).length > 2).map(s -> s[2]).map(Integer::parseInt).map(DSL::inline);
        Field left = version.isPresent() ? DSL.field((SelectField)DSL.row(uuidField, versionField)) : uuidField;
        Field right = version.isPresent() ? DSL.field((SelectField)DSL.row((SelectField)uuid, (SelectField)((SelectField)version.get()))) : uuid;
        return switch (op) {
            default -> throw new MatchException(null, null);
            case AslQueryCondition.AslConditionOperator.IN, AslQueryCondition.AslConditionOperator.EQ -> left.eq(right);
            case AslQueryCondition.AslConditionOperator.NEQ -> left.ne(right);
            case AslQueryCondition.AslConditionOperator.LT -> left.lt(right);
            case AslQueryCondition.AslConditionOperator.GT -> left.gt(right);
            case AslQueryCondition.AslConditionOperator.GT_EQ -> left.ge(right);
            case AslQueryCondition.AslConditionOperator.LT_EQ -> left.le(right);
            case AslQueryCondition.AslConditionOperator.IS_NULL -> uuidField.isNull();
            case AslQueryCondition.AslConditionOperator.IS_NOT_NULL -> uuidField.isNotNull();
            case AslQueryCondition.AslConditionOperator.LIKE -> throw new IllegalArgumentException();
        };
    }

    private static Condition applyOperator(AslQueryCondition.AslConditionOperator operator, Field field, Collection<?> values) {
        boolean uuidField;
        Class sqlFieldType = field.getType();
        boolean jsonbField = JSONB.class.isAssignableFrom(sqlFieldType);
        boolean bl = uuidField = !jsonbField && UUID.class.isAssignableFrom(sqlFieldType);
        if (operator == AslQueryCondition.AslConditionOperator.LIKE) {
            String likePattern = (String)values.iterator().next();
            if (jsonbField) {
                likePattern = ConditionUtils.escapeAsJsonString(likePattern);
            }
            return field.cast(String.class).like(likePattern);
        }
        if (operator == AslQueryCondition.AslConditionOperator.IS_NULL) {
            return field.isNull();
        }
        if (operator == AslQueryCondition.AslConditionOperator.IS_NOT_NULL) {
            return field.isNotNull();
        }
        boolean orderOperator = EnumSet.of(AslQueryCondition.AslConditionOperator.GT_EQ, AslQueryCondition.AslConditionOperator.GT, AslQueryCondition.AslConditionOperator.LT_EQ, AslQueryCondition.AslConditionOperator.LT).contains((Object)operator);
        List<Object> filteredValues = values.stream().map(v -> {
            Object value = null;
            if (uuidField && v instanceof String) {
                String s = (String)v;
                try {
                    value = UUID.fromString(s);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (jsonbField || sqlFieldType.isInstance(v) || orderOperator) {
                value = v;
            }
            return value;
        }).filter(Objects::nonNull).toList();
        return switch (filteredValues.size()) {
            case 0 -> {
                switch (operator) {
                    case IN: 
                    case EQ: {
                        yield DSL.falseCondition();
                    }
                    case NEQ: {
                        yield DSL.trueCondition();
                    }
                    case LT: 
                    case GT: 
                    case GT_EQ: 
                    case LT_EQ: {
                        throw new IllegalArgumentException("%s-Condition needs one value, not 0".formatted(new Object[]{operator}));
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operator));
            }
            case 1 -> {
                Object val = filteredValues.getFirst();
                Field wrappedValue = jsonbField || orderOperator && !sqlFieldType.isInstance(val) ? AdditionalSQLFunctions.to_jsonb((Object)val) : DSL.inline((Object)val);
                Field wrappedField = !jsonbField && orderOperator && !sqlFieldType.isInstance(val) ? AdditionalSQLFunctions.to_jsonb((Field)field) : field;
                switch (operator) {
                    case IN: 
                    case EQ: {
                        yield field.eq(wrappedValue);
                    }
                    case NEQ: {
                        yield field.ne(wrappedValue);
                    }
                    case GT_EQ: {
                        yield wrappedField.ge(wrappedValue);
                    }
                    case GT: {
                        yield wrappedField.gt(wrappedValue);
                    }
                    case LT_EQ: {
                        yield wrappedField.le(wrappedValue);
                    }
                    case LT: {
                        yield wrappedField.lt(wrappedValue);
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operator));
            }
            default -> {
                switch (operator) {
                    case IN: {
                        yield field.in(filteredValues.stream().map(v -> jsonbField ? AdditionalSQLFunctions.to_jsonb((Object)v) : DSL.inline((Object)v)).toList());
                    }
                    case EQ: 
                    case NEQ: 
                    case LT: 
                    case GT: 
                    case GT_EQ: 
                    case LT_EQ: {
                        throw new IllegalArgumentException("%s-Condition needs one value, not %d".formatted(new Object[]{operator, filteredValues.size()}));
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operator));
            }
        };
    }

    static String escapeAsJsonString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)string);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e.getMessage(), (IOException)((Object)e));
        }
    }
}

