/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl.model.field;

import java.util.stream.Stream;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;

public abstract sealed class AslField
permits AslColumnField, AslConstantField, AslSubqueryField, AslVirtualField {
    protected Class<?> type;
    protected FieldSource fieldSource;
    protected AslExtractedColumn extractedColumn;

    protected AslField(Class<?> type, FieldSource fieldSource, AslExtractedColumn extractedColumn) {
        this.type = type;
        this.fieldSource = fieldSource;
        this.extractedColumn = extractedColumn;
    }

    public Class<?> getType() {
        return this.type;
    }

    public AslQuery getOwner() {
        return this.fieldSource.owner();
    }

    public AslQuery getInternalProvider() {
        return this.fieldSource.internalProvider();
    }

    public AslQuery getProvider() {
        return this.fieldSource.provider();
    }

    public abstract AslField withProvider(AslQuery var1);

    public AslField withOwner(AslQuery owner) {
        if (this.fieldSource != null) {
            throw new IllegalArgumentException("fieldSource is already set");
        }
        return this.copyWithOwner(owner);
    }

    public AslExtractedColumn getExtractedColumn() {
        return this.extractedColumn;
    }

    protected String aliasedName(String name) {
        return this.fieldSource.owner().getAlias() + "_" + name;
    }

    public abstract AslField copyWithOwner(AslQuery var1);

    public Stream<AslField> fieldsForAggregation(AslRootQuery rootQuery) {
        if (this.getProvider() == rootQuery) {
            return Stream.of(this);
        }
        return Stream.of(this.withProvider(rootQuery));
    }

    public record FieldSource(AslQuery owner, AslQuery internalProvider, AslQuery provider) {
        public static FieldSource withOwner(AslQuery owner) {
            return new FieldSource(owner, owner, owner);
        }

        public FieldSource withProvider(AslQuery newProvider) {
            return new FieldSource(this.owner, this.provider, newProvider);
        }
    }
}

