/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.featurecheck;

import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.aqlengine.AqlConfigurationProperties;
import org.ehrbase.openehr.aqlengine.featurecheck.FeatureCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.FromCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.OrderByCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.SelectCheck;
import org.ehrbase.openehr.aqlengine.featurecheck.WhereCheck;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.springframework.stereotype.Component;

@Component
public final class AqlQueryFeatureCheck {
    private final FeatureCheck[] featureChecks;

    public AqlQueryFeatureCheck(SystemService systemService, AqlConfigurationProperties aqlConfigurationProperties) {
        this.featureChecks = new FeatureCheck[]{new FromCheck(systemService, aqlConfigurationProperties), new SelectCheck(systemService), new WhereCheck(systemService), new OrderByCheck(systemService)};
    }

    public void ensureQuerySupported(AqlQuery aqlQuery) {
        for (FeatureCheck featureCheck : this.featureChecks) {
            featureCheck.ensureSupported(aqlQuery);
        }
    }
}

