/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.re2j.Pattern;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.api.exception.BadGatewayException;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.service.AqlQueryService;
import org.ehrbase.openehr.aqlengine.AqlParameterReplacement;
import org.ehrbase.openehr.aqlengine.AqlQueryUtils;
import org.ehrbase.openehr.aqlengine.asl.AqlSqlLayer;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.featurecheck.AqlQueryFeatureCheck;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.select.SelectWrapper;
import org.ehrbase.openehr.aqlengine.repository.AqlQueryRepository;
import org.ehrbase.openehr.aqlengine.repository.PreparedQuery;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.sdk.aql.render.AqlRenderer;
import org.ehrbase.openehr.sdk.aql.util.AqlUtil;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryResultDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.query.ResultHolder;
import org.ehrbase.openehr.sdk.validation.terminology.ExternalTerminologyValidation;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class AqlQueryServiceImp
implements AqlQueryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AqlQueryRepository aqlQueryRepository;
    private final ExternalTerminologyValidation tsAdapter;
    private final AqlSqlLayer aqlSqlLayer;
    private final AqlQueryFeatureCheck aqlQueryFeatureCheck;
    private final ObjectMapper objectMapper;
    private final AqlQueryContext aqlQueryContext;
    @Value(value="${ehrbase.rest.aql.default-limit:}")
    private Long defaultLimit;
    @Value(value="${ehrbase.rest.aql.max-limit:}")
    private Long maxLimit;
    @Value(value="${ehrbase.rest.aql.max-fetch:}")
    private Long maxFetch;
    @Value(value="${ehrbase.rest.aql.fetch-precedence:REJECT}")
    private FetchPrecedence fetchPrecedence = FetchPrecedence.REJECT;

    private static Long applyFetchPrecedence(FetchPrecedence fetchPrecedence, Long queryLimit, Long queryOffset, Long fetchParam, Long offsetParam) {
        if (fetchParam == null) {
            if (offsetParam != null) {
                throw new UnprocessableEntityException("Query parameter for offset provided, but no fetch parameter");
            }
            return queryLimit;
        }
        if (queryLimit == null) {
            assert (queryOffset == null);
            return fetchParam;
        }
        switch (fetchPrecedence.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                throw new UnprocessableEntityException("Query contains a LIMIT clause, fetch and offset parameters must not be used (with fetch precedence %s)".formatted(new Object[]{fetchPrecedence}));
            }
            case 1: 
        }
        if (queryOffset != null) {
            throw new UnprocessableEntityException("Query contains a OFFSET clause, fetch parameter must not be used (with fetch precedence %s)".formatted(new Object[]{fetchPrecedence}));
        }
        return Math.min(queryLimit, fetchParam);
    }

    @Autowired
    public AqlQueryServiceImp(AqlQueryRepository aqlQueryRepository, ExternalTerminologyValidation tsAdapter, AqlSqlLayer aqlSqlLayer, AqlQueryFeatureCheck aqlQueryFeatureCheck, ObjectMapper objectMapper, AqlQueryContext aqlQueryContext) {
        this.aqlQueryRepository = aqlQueryRepository;
        this.tsAdapter = tsAdapter;
        this.aqlSqlLayer = aqlSqlLayer;
        this.aqlQueryFeatureCheck = aqlQueryFeatureCheck;
        this.objectMapper = objectMapper;
        this.aqlQueryContext = aqlQueryContext;
    }

    public QueryResultDto query(AqlQueryRequest aqlQuery) {
        return this.queryAql(aqlQuery);
    }

    private QueryResultDto queryAql(AqlQueryRequest aqlQueryRequest) {
        if (this.defaultLimit != null) {
            this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.DEFAULT_LIMIT, (Object)this.defaultLimit);
        }
        if (this.maxLimit != null) {
            this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.MAX_LIMIT, (Object)this.maxLimit);
        }
        if (this.maxFetch != null) {
            this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.MAX_FETCH, (Object)this.maxFetch);
        }
        try {
            AqlQuery aqlQuery = AqlQueryServiceImp.buildAqlQuery(aqlQueryRequest, this.fetchPrecedence, this.defaultLimit, this.maxLimit, this.maxFetch);
            this.aqlQueryFeatureCheck.ensureQuerySupported(aqlQuery);
            try {
                List<List<Object>> resultData;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(this.objectMapper.writeValueAsString((Object)aqlQuery));
                }
                AqlQueryWrapper queryWrapper = AqlQueryWrapper.create(aqlQuery);
                AslRootQuery aslQuery = this.aqlSqlLayer.buildAslRootQuery(queryWrapper);
                List<SelectWrapper> nonPrimitiveSelects = queryWrapper.nonPrimitiveSelects().toList();
                PreparedQuery preparedQuery = this.aqlQueryRepository.prepareQuery(aslQuery, nonPrimitiveSelects);
                if (this.aqlQueryContext.showExecutedSql()) {
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.EXECUTED_SQL, (Object)AqlQueryRepository.getQuerySql(preparedQuery));
                }
                if (this.aqlQueryContext.showQueryPlan()) {
                    boolean analyze = !this.aqlQueryContext.isDryRun();
                    String explainedQuery = this.aqlQueryRepository.explainQuery(analyze, preparedQuery);
                    TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(this){};
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.QUERY_PLAN, this.objectMapper.readValue(explainedQuery, (TypeReference)typeRef));
                }
                if (this.aqlQueryContext.showExecutedAql()) {
                    this.aqlQueryContext.setExecutedAql(AqlRenderer.render((AqlQuery)aqlQuery));
                }
                Optional.of(queryWrapper).map(AqlQueryWrapper::limit).map(Long::intValue).ifPresent(limit -> {
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.FETCH, limit);
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.OFFSET, (Object)Optional.of(queryWrapper).map(AqlQueryWrapper::offset).map(Long::intValue).orElse(0));
                });
                if (this.aqlQueryContext.isDryRun()) {
                    resultData = List.of();
                } else {
                    resultData = this.executeQuery(preparedQuery, queryWrapper, nonPrimitiveSelects);
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.RESULT_SIZE, (Object)resultData.size());
                }
                return this.formatResult(queryWrapper.selects(), resultData);
            }
            catch (JsonProcessingException | IllegalArgumentException e) {
                throw new InternalServerException(e.getMessage(), e);
            }
        }
        catch (RestClientException e) {
            throw new BadGatewayException(AqlQueryServiceImp.errorMessage("Bad gateway", (Exception)((Object)e)), (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new InternalServerException(AqlQueryServiceImp.errorMessage("Data Access Error", (Exception)((Object)e)), (Throwable)e);
        }
        catch (AqlParseException e) {
            throw new IllegalAqlException(AqlQueryServiceImp.errorMessage("Could not parse AQL query", (Exception)((Object)e)), (Throwable)e);
        }
    }

    public static AqlQuery buildAqlQuery(AqlQueryRequest aqlQueryRequest, FetchPrecedence fetchPrecedence, Long defaultLimit, Long maxLimit, Long maxFetch) {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)aqlQueryRequest.queryString());
        Optional<AqlQueryRequest> qr = Optional.of(aqlQueryRequest);
        Long fetchParam = aqlQueryRequest.fetch();
        Long offsetParam = aqlQueryRequest.offset();
        Long queryLimit = aqlQuery.getLimit();
        Long queryOffset = aqlQuery.getOffset();
        if (queryLimit != null && maxLimit != null && queryLimit > maxLimit) {
            throw new UnprocessableEntityException("Query LIMIT %d exceeds maximum limit %d".formatted(queryLimit, maxLimit));
        }
        if (fetchParam != null && maxFetch != null && fetchParam > maxFetch) {
            throw new UnprocessableEntityException("Fetch parameter %d exceeds maximum fetch %d".formatted(fetchParam, maxFetch));
        }
        Long limit = AqlQueryServiceImp.applyFetchPrecedence(fetchPrecedence, queryLimit, queryOffset, fetchParam, offsetParam);
        aqlQuery.setLimit((Long)ObjectUtils.firstNonNull((Object[])new Long[]{limit, defaultLimit}));
        aqlQuery.setOffset((Long)ObjectUtils.firstNonNull((Object[])new Long[]{offsetParam, queryOffset}));
        AqlParameterReplacement.replaceParameters(aqlQuery, aqlQueryRequest.parameters());
        AqlQueryServiceImp.replaceEhrPaths(aqlQuery);
        return aqlQuery;
    }

    private List<List<Object>> executeQuery(PreparedQuery preparedQuery, AqlQueryWrapper queryWrapper, List<SelectWrapper> nonPrimitiveSelects) {
        List<List<Object>> resultData = this.aqlQueryRepository.executeQuery(preparedQuery);
        List<SelectWrapper> selects = queryWrapper.selects();
        if (nonPrimitiveSelects.isEmpty()) {
            resultData = LongStream.range(0L, (Long)resultData.getFirst().getFirst()).mapToObj(i -> new ArrayList(selects.size())).toList();
        }
        int s = selects.size();
        for (int i2 = 0; i2 < s; ++i2) {
            SelectWrapper sd = selects.get(i2);
            if (sd.type() != SelectWrapper.SelectType.PRIMITIVE) continue;
            Constable value = sd.getPrimitive().getValue();
            for (List<Object> row : resultData) {
                row.add(i2, value);
            }
        }
        return resultData;
    }

    private QueryResultDto formatResult(List<SelectWrapper> selectFields, List<List<Object>> resultData) {
        String[] columnNames = new String[selectFields.size()];
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        int s = selectFields.size();
        for (int i = 0; i < s; ++i) {
            SelectWrapper namePath = selectFields.get(i);
            columnNames[i] = Optional.of(namePath).map(SelectWrapper::getSelectAlias).orElse("#" + i);
            columns.put(columnNames[i], namePath.getSelectPath().orElse(null));
        }
        QueryResultDto dto = new QueryResultDto();
        dto.setVariables(columns);
        dto.setResultSet(resultData.stream().map(r -> {
            ResultHolder fieldMap = new ResultHolder();
            int s = r.size();
            for (int i = 0; i < s; ++i) {
                fieldMap.putResult(columnNames[i], r.get(i));
            }
            return fieldMap;
        }).toList());
        return dto;
    }

    static void replaceEhrPaths(AqlQuery aqlQuery) {
        AqlQueryServiceImp.replaceEhrPath(aqlQuery, "ehr_status", "EHR_STATUS", "s");
    }

    static void replaceEhrPath(AqlQuery aqlQuery, String ehrPath, String type, String aliasPrefix) {
        List<IdentifiedPath> ehrPaths = AqlQueryUtils.allIdentifiedPaths(aqlQuery).filter(ip -> {
            ContainmentClassExpression cce;
            AbstractContainmentExpression patt0$temp = ip.getRoot();
            return patt0$temp instanceof ContainmentClassExpression && (cce = (ContainmentClassExpression)patt0$temp).getType().equals("EHR");
        }).filter(ip -> Optional.of(ip).map(IdentifiedPath::getPath).map(AqlObjectPath::getPathNodes).map(List::getFirst).map(AqlObjectPath.PathNode::getAttribute).filter(ehrPath::equals).isPresent()).toList();
        if (ehrPaths.isEmpty()) {
            return;
        }
        if (ehrPaths.stream().map(IdentifiedPath::getRoot).map(AbstractContainmentExpression::getIdentifier).distinct().count() > 1L) {
            throw new AqlFeatureNotImplementedException("Multiple EHR in FROM are not supported");
        }
        if (ehrPaths.stream().map(IdentifiedPath::getRootPredicate).anyMatch(CollectionUtils::isNotEmpty)) {
            throw new AqlFeatureNotImplementedException("Root predicates for EHR/%s are not supported".formatted(ehrPath));
        }
        if (ehrPaths.stream().map(IdentifiedPath::getPath).map(p -> ((AqlObjectPath.PathNode)p.getPathNodes().getFirst()).getPredicateOrOperands()).distinct().count() > 1L) {
            throw new AqlFeatureNotImplementedException("Specifying different predicates for EHR/%s is not supported".formatted(ehrPath));
        }
        String alias = AqlUtil.streamContainments((Containment)aqlQuery.getFrom()).map(AbstractContainmentExpression::getIdentifier).filter(Objects::nonNull).filter(s -> s.matches(Pattern.quote((String)aliasPrefix) + "\\d*")).map(s -> aliasPrefix.equals(s) ? 0L : Long.parseLong(s.substring(1))).max(Comparator.naturalOrder()).map(i -> aliasPrefix + (i + 1L)).orElse(aliasPrefix);
        ContainmentClassExpression ehrContainment = (ContainmentClassExpression)ehrPaths.getFirst().getRoot();
        ContainmentClassExpression ehrStatusContainment = new ContainmentClassExpression();
        ehrStatusContainment.setType(type);
        ehrStatusContainment.setIdentifier(alias);
        ehrPaths.stream().findFirst().map(IdentifiedPath::getPath).map(p -> ((AqlObjectPath.PathNode)p.getPathNodes().getFirst()).getPredicateOrOperands()).ifPresent(arg_0 -> ((ContainmentClassExpression)ehrStatusContainment).setPredicates(arg_0));
        if (ehrContainment.getContains() == null) {
            ehrContainment.setContains((Containment)ehrStatusContainment);
        } else {
            ContainmentSetOperator cse;
            Containment containment = ehrContainment.getContains();
            if (containment instanceof ContainmentSetOperator && (cse = (ContainmentSetOperator)containment).getSymbol() == ContainmentSetOperatorSymbol.AND) {
                cse.setValues(Stream.concat(Stream.of(ehrStatusContainment), cse.getValues().stream()).toList());
            } else {
                ContainmentSetOperator and = new ContainmentSetOperator();
                and.setSymbol(ContainmentSetOperatorSymbol.AND);
                and.setValues(List.of(ehrStatusContainment, ehrContainment.getContains()));
                ehrContainment.setContains((Containment)and);
            }
        }
        ehrPaths.forEach(ip -> {
            ip.setRoot((AbstractContainmentExpression)ehrStatusContainment);
            List pathNodes = ip.getPath().getPathNodes();
            ip.setPath(pathNodes.size() == 1 ? null : new AqlObjectPath(pathNodes.subList(1, pathNodes.size())));
        });
    }

    private static String errorMessage(String prefix, Exception e) {
        return prefix + ": " + Optional.of(e).map(Throwable::getCause).orElse(e).getMessage();
    }

    public static enum FetchPrecedence {
        REJECT,
        MIN_FETCH;

    }
}

