/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.pathanalysis;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehrbase.openehr.aqlengine.AqlQueryUtils;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathInfo;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentVersionExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.util.TreeNode;

public final class PathCohesionAnalysis {
    private PathCohesionAnalysis() {
    }

    public static Map<AbstractContainmentExpression, PathCohesionTreeNode> analyzePathCohesion(AqlQuery query) {
        Map<AbstractContainmentExpression, List<IdentifiedPath>> roots = AqlQueryUtils.allIdentifiedPaths(query).distinct().collect(Collectors.groupingBy(IdentifiedPath::getRoot));
        return roots.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            AqlObjectPath.PathNode rootNode = PathCohesionAnalysis.createRootNode(e);
            PathCohesionTreeNode joinTree = PathCohesionTreeNode.root(rootNode, (List)e.getValue());
            PathCohesionAnalysis.fillJoinTree(joinTree, 0);
            return joinTree;
        }));
    }

    private static AqlObjectPath.PathNode createRootNode(Map.Entry<AbstractContainmentExpression, List<IdentifiedPath>> e) {
        List<Object> rootPredicates;
        String rootType;
        AbstractContainmentExpression root = e.getKey();
        if (root instanceof ContainmentVersionExpression) {
            ContainmentVersionExpression cv = (ContainmentVersionExpression)root;
            rootType = "VERSION";
            rootPredicates = new ArrayList<AndOperatorPredicate>();
        } else if (root instanceof ContainmentClassExpression) {
            ContainmentClassExpression cc = (ContainmentClassExpression)root;
            rootType = cc.getType();
            rootPredicates = Optional.of(cc).map(ContainmentClassExpression::getPredicates).orElseGet(ArrayList::new);
        } else {
            throw new IllegalArgumentException("Unsupported type: %s".formatted(root));
        }
        AttributeType attributeType = AttributeType.getAttributeType(rootPredicates);
        attributeType.cleanupPredicates(rootPredicates);
        return new AqlObjectPath.PathNode(rootType, rootPredicates);
    }

    private static void fillJoinTree(PathCohesionTreeNode node, int level) {
        Map<String, List<IdentifiedPath>> baseAttributes = node.getPaths().stream().filter(o -> PathInfo.pathNodes(o.getPath()).size() > level).collect(Collectors.groupingBy(p -> ((AqlObjectPath.PathNode)p.getPath().getPathNodes().get(level)).getAttribute()));
        baseAttributes.forEach((k, v) -> {
            AttributeType attributeType = v.stream().map(IdentifiedPath::getPath).map(AqlObjectPath::getPathNodes).map(n -> (AqlObjectPath.PathNode)n.get(level)).map(AqlObjectPath.PathNode::getPredicateOrOperands).map(AttributeType::getAttributeType).reduce(AttributeType::merge).get();
            if (attributeType == AttributeType.BASE) {
                node.addChild(new AqlObjectPath.PathNode(k), (List<IdentifiedPath>)v);
            } else {
                Map<List, List<IdentifiedPath>> byAttType = v.stream().collect(Collectors.groupingBy(p -> attributeType.cleanupPredicates(((AqlObjectPath.PathNode)p.getPath().getPathNodes().get(level)).getPredicateOrOperands())));
                byAttType.forEach((cleanPredicates, paths) -> node.addChild(new AqlObjectPath.PathNode(k, cleanPredicates), (List<IdentifiedPath>)paths));
            }
        });
        node.getChildren().forEach(c -> PathCohesionAnalysis.fillJoinTree(c, level + 1));
    }

    static enum AttributeType {
        BASE,
        ARCHETYPE,
        NODE,
        NAME;


        public List<AndOperatorPredicate> cleanupPredicates(List<AndOperatorPredicate> predicateOrOperands) {
            return predicateOrOperands.stream().map(and -> {
                Optional<ComparisonOperatorPredicate> archetypeNodeId = AttributeType.getOperand(and, AqlObjectPathUtil.ARCHETYPE_NODE_ID).filter(this::prefilter).findFirst();
                Optional<Object> nameValue = AttributeType.getOperand(and, AqlObjectPathUtil.NAME_VALUE).filter(this::prefilter).findFirst();
                if (this == NODE) {
                    boolean isNodeId = archetypeNodeId.map(ComparisonOperatorPredicate::getValue).map(Primitive.class::cast).map(Primitive::getValue).map(String.class::cast).filter(v -> !v.startsWith("openEHR-")).isPresent();
                    if (isNodeId) {
                        nameValue = Optional.empty();
                    }
                }
                if (archetypeNodeId.isEmpty() && nameValue.isEmpty()) {
                    return null;
                }
                return new AndOperatorPredicate(Stream.of(archetypeNodeId, nameValue).flatMap(Optional::stream).collect(Collectors.toList()));
            }).filter(Objects::nonNull).sorted(Comparator.comparing(and -> AttributeType.getStringValue(and, AqlObjectPathUtil.ARCHETYPE_NODE_ID)).thenComparing(and -> AttributeType.getStringValue(and, AqlObjectPathUtil.NAME_VALUE))).toList();
        }

        private static String getStringValue(AndOperatorPredicate and, AqlObjectPath archetypeNodeId) {
            return AttributeType.getOperand(and, archetypeNodeId).findFirst().map(p -> (String)((Object)((Primitive)p.getValue()).getValue())).orElse(null);
        }

        private static Stream<ComparisonOperatorPredicate> getOperand(AndOperatorPredicate and, AqlObjectPath path) {
            return and.getOperands().stream().filter(op -> path.equals((Object)op.getPath()));
        }

        private boolean prefilter(ComparisonOperatorPredicate op) {
            if (this == BASE) {
                return false;
            }
            ComparisonOperatorPredicate.PredicateComparisonOperator operator = op.getOperator();
            if (operator != ComparisonOperatorPredicate.PredicateComparisonOperator.EQ) {
                return false;
            }
            AqlObjectPath path = op.getPath();
            if (AqlObjectPathUtil.NAME_VALUE.equals((Object)path)) {
                return this != ARCHETYPE;
            }
            if (AqlObjectPathUtil.ARCHETYPE_NODE_ID.equals((Object)path)) {
                return this != NAME;
            }
            return false;
        }

        public AttributeType merge(AttributeType type) {
            if (this == type) {
                return this;
            }
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this;
                case 1 -> {
                    if (type == NODE) {
                        yield this;
                    }
                    yield BASE;
                }
                case 2 -> {
                    if (type == NAME) {
                        yield BASE;
                    }
                    yield type;
                }
                case 3 -> BASE;
            };
        }

        public AttributeType mergeAndPredicates(AttributeType type) {
            if (this == BASE || type == BASE) {
                throw new IllegalArgumentException("BASE cannot be merged");
            }
            if (this == type) {
                return this;
            }
            return NODE;
        }

        public static AttributeType getAttributeType(List<AndOperatorPredicate> predicateOrOperands) {
            return predicateOrOperands.stream().map(AttributeType::getAttributeType).reduce(AttributeType::merge).orElse(BASE);
        }

        public static AttributeType getAttributeType(AndOperatorPredicate and) {
            return and.getOperands().stream().map(AttributeType::getAttributeType).filter(Objects::nonNull).reduce(AttributeType::mergeAndPredicates).orElse(BASE);
        }

        private static AttributeType getAttributeType(ComparisonOperatorPredicate op) {
            ComparisonOperatorPredicate.PredicateComparisonOperator operator = op.getOperator();
            if (operator != ComparisonOperatorPredicate.PredicateComparisonOperator.EQ) {
                return null;
            }
            AqlObjectPath path = op.getPath();
            if (AqlObjectPathUtil.NAME_VALUE.equals((Object)path)) {
                return NAME;
            }
            if (AqlObjectPathUtil.ARCHETYPE_NODE_ID.equals((Object)path)) {
                Primitive p;
                Constable constable;
                PathPredicateOperand value = op.getValue();
                if (value instanceof Primitive && (constable = (p = (Primitive)value).getValue()) instanceof String) {
                    String v = (String)((Object)constable);
                    if (v.startsWith("openEHR-")) {
                        return ARCHETYPE;
                    }
                    return NODE;
                }
                return null;
            }
            return null;
        }
    }

    public static class PathCohesionTreeNode
    extends TreeNode<PathCohesionTreeNode> {
        private AqlObjectPath.PathNode attribute;
        private final List<IdentifiedPath> paths;
        private final List<IdentifiedPath> pathsEndingAtNode;
        private final boolean root;

        private PathCohesionTreeNode(AqlObjectPath.PathNode attribute, List<IdentifiedPath> paths, boolean root) {
            this.attribute = attribute;
            this.paths = paths;
            this.pathsEndingAtNode = new ArrayList<IdentifiedPath>(paths);
            this.root = root;
        }

        PathCohesionTreeNode addChild(AqlObjectPath.PathNode attribute, List<IdentifiedPath> paths) {
            this.pathsEndingAtNode.removeAll(paths);
            return this.addChild(new PathCohesionTreeNode(attribute, paths, false));
        }

        public static PathCohesionTreeNode root(AqlObjectPath.PathNode attribute, List<IdentifiedPath> paths) {
            return new PathCohesionTreeNode(attribute, paths, true);
        }

        public AqlObjectPath.PathNode getAttribute() {
            return this.attribute;
        }

        public void setAttribute(AqlObjectPath.PathNode attribute) {
            this.attribute = attribute;
        }

        public List<IdentifiedPath> getPaths() {
            return this.paths;
        }

        public List<IdentifiedPath> getPathsEndingAtNode() {
            return Collections.unmodifiableList(this.pathsEndingAtNode);
        }

        public boolean isRoot() {
            return this.root;
        }
    }
}

