/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import java.lang.runtime.SwitchBootstraps;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.util.AdditionalSQLFunctions;
import org.ehrbase.openehr.aqlengine.ChangeTypeUtils;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslDvOrderedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslFolderItemIdVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslOrderByField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRmObjectDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.sql.AqlSqlQueryBuilder;
import org.ehrbase.openehr.aqlengine.sql.ConditionUtils;
import org.ehrbase.openehr.aqlengine.sql.FieldUtils;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.jooq.CaseWhenStep;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.LikeEscapeStep;
import org.jooq.Param;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EncapsulatingQueryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EncapsulatingQueryUtils.class);

    private EncapsulatingQueryUtils() {
    }

    private static SelectField<?> sqlAggregatingField(AslAggregatingField af, Table<?> src, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        if ((src == null || af.getBaseField() == null) && af.getFunction() != AggregateFunction.AggregateFunctionName.COUNT) {
            throw new IllegalArgumentException("only count does not require a source table");
        }
        boolean isExtractedColumn = Optional.of(af).map(AslAggregatingField::getBaseField).map(AslField::getExtractedColumn).filter(ec -> !EnumSet.of(AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.EHR_TIME_CREATED_DV, AslExtractedColumn.EHR_TIME_CREATED).contains(ec)).isPresent();
        if (isExtractedColumn && af.getFunction() != AggregateFunction.AggregateFunctionName.COUNT) {
            throw new IllegalArgumentException("Aggregate function %s is not allowed for extracted columns".formatted(af.getFunction()));
        }
        Function<Field<?>, SelectField<?>> aggregateFunction = EncapsulatingQueryUtils.toAggregatedFieldFunction(af);
        Field<?> field = EncapsulatingQueryUtils.fieldToAggregate(src, af, aslQueryToTable);
        return aggregateFunction.apply(field);
    }

    @Nullable
    private static Field<?> fieldToAggregate(Table<?> src, AslAggregatingField af, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        AslField aslField = af.getBaseField();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslColumnField.class, AslComplexExtractedColumnField.class, AslConstantField.class, AslSubqueryField.class, AslAggregatingField.class, AslFolderItemIdVirtualField.class}, (Object)aslField, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> null;
            case 0 -> {
                AslColumnField f = (AslColumnField)aslField;
                yield FieldUtils.field(Objects.requireNonNull(src), f, true);
            }
            case 1 -> {
                AslComplexExtractedColumnField ecf = (AslComplexExtractedColumnField)aslField;
                Objects.requireNonNull(src);
                switch (ecf.getExtractedColumn()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case VO_ID: {
                        yield FieldUtils.field(src, ecf, Tables.COMP_DATA.VO_ID.getName(), true);
                    }
                    case ARCHETYPE_NODE_ID: {
                        yield DSL.field((SelectField)DSL.row(FieldUtils.field(src, ecf, Tables.COMP_DATA.RM_ENTITY.getName(), true), FieldUtils.field(src, ecf, Tables.COMP_DATA.ENTITY_CONCEPT.getName(), true)));
                    }
                    case NAME_VALUE: 
                    case EHR_ID: 
                    case TEMPLATE_ID: 
                    case ROOT_CONCEPT: 
                    case OV_CONTRIBUTION_ID: 
                    case OV_TIME_COMMITTED_DV: 
                    case OV_TIME_COMMITTED: 
                    case AD_SYSTEM_ID: 
                    case AD_DESCRIPTION_DV: 
                    case AD_DESCRIPTION_VALUE: 
                    case AD_CHANGE_TYPE_DV: 
                    case AD_CHANGE_TYPE_VALUE: 
                    case AD_CHANGE_TYPE_CODE_STRING: 
                    case AD_CHANGE_TYPE_PREFERRED_TERM: 
                    case AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE: 
                    case EHR_TIME_CREATED_DV: 
                    case EHR_TIME_CREATED: 
                    case EHR_SYSTEM_ID: 
                    case EHR_SYSTEM_ID_DV: 
                }
                throw new IllegalArgumentException("%s is not a complex extracted column".formatted(new Object[]{ecf.getExtractedColumn()}));
            }
            case 2 -> {
                AslConstantField cf = (AslConstantField)aslField;
                yield DSL.inline(cf.getValue(), cf.getType());
            }
            case 3 -> {
                AslSubqueryField sqfd = (AslSubqueryField)aslField;
                yield EncapsulatingQueryUtils.subqueryField(sqfd, aslQueryToTable);
            }
            case 4 -> {
                AslAggregatingField __ = (AslAggregatingField)aslField;
                throw new IllegalArgumentException("Cannot aggregate on AslAggregatingField");
            }
            case 5 -> {
                AslFolderItemIdVirtualField __ = (AslFolderItemIdVirtualField)aslField;
                throw new IllegalArgumentException("Cannot aggregate on AslFolderItemIdValuesColumnField");
            }
        };
    }

    @Nonnull
    private static Function<Field<?>, SelectField<?>> toAggregatedFieldFunction(AslAggregatingField af) {
        return switch (af.getFunction()) {
            default -> throw new MatchException(null, null);
            case AggregateFunction.AggregateFunctionName.COUNT -> f -> AdditionalSQLFunctions.count((boolean)af.isDistinct(), (Field)f);
            case AggregateFunction.AggregateFunctionName.MIN -> f -> af.getBaseField() instanceof AslDvOrderedColumnField ? AdditionalSQLFunctions.min_dv_ordered((Field)f) : DSL.min((Field)f);
            case AggregateFunction.AggregateFunctionName.MAX -> f -> af.getBaseField() instanceof AslDvOrderedColumnField ? AdditionalSQLFunctions.max_dv_ordered((Field)f) : DSL.max((Field)f);
            case AggregateFunction.AggregateFunctionName.SUM -> f -> DSL.aggregate((String)"sum", (DataType)SQLDataType.NUMERIC, (Field[])new Field[]{f});
            case AggregateFunction.AggregateFunctionName.AVG -> f -> DSL.aggregate((String)"avg", (DataType)SQLDataType.NUMERIC, (Field[])new Field[]{f});
        };
    }

    static SelectField<?> sqlSelectFieldForExtractedColumn(AslComplexExtractedColumnField ecf, Table<?> src) {
        return switch (ecf.getExtractedColumn()) {
            default -> throw new MatchException(null, null);
            case AslExtractedColumn.VO_ID -> DSL.row(FieldUtils.field(src, ecf, Tables.COMP_DATA.VO_ID.getName(), true), FieldUtils.field(src, ecf, Tables.COMP_VERSION.SYS_VERSION.getName(), true));
            case AslExtractedColumn.ARCHETYPE_NODE_ID -> DSL.row(FieldUtils.field(src, ecf, Tables.COMP_DATA.ENTITY_CONCEPT.getName(), true), FieldUtils.field(src, ecf, Tables.COMP_DATA.RM_ENTITY.getName(), true));
            case AslExtractedColumn.NAME_VALUE, AslExtractedColumn.EHR_ID, AslExtractedColumn.TEMPLATE_ID, AslExtractedColumn.ROOT_CONCEPT, AslExtractedColumn.OV_CONTRIBUTION_ID, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.AD_SYSTEM_ID, AslExtractedColumn.AD_DESCRIPTION_DV, AslExtractedColumn.AD_DESCRIPTION_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_DV, AslExtractedColumn.AD_CHANGE_TYPE_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING, AslExtractedColumn.AD_CHANGE_TYPE_PREFERRED_TERM, AslExtractedColumn.AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE, AslExtractedColumn.EHR_TIME_CREATED_DV, AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_SYSTEM_ID, AslExtractedColumn.EHR_SYSTEM_ID_DV -> throw new IllegalArgumentException("Extracted column %s is not complex".formatted(new Object[]{ecf.getExtractedColumn()}));
        };
    }

    private static Field<?> subqueryField(AslSubqueryField sqf, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        AslQuery baseQuery = sqf.getBaseQuery();
        if (!(baseQuery instanceof AslRmObjectDataQuery)) {
            throw new IllegalArgumentException("Subquery field not supported for type: " + String.valueOf(baseQuery.getClass()));
        }
        AslRmObjectDataQuery aq = (AslRmObjectDataQuery)baseQuery;
        return AqlSqlQueryBuilder.buildDataSubquery(aq, aslQueryToTable, (Condition[])sqf.getFilterConditions().stream().map(c -> ConditionUtils.buildCondition(c, aslQueryToTable, true)).toArray(Condition[]::new)).asField();
    }

    private static Stream<Field<?>> archetypeNodeIdOrderFields(Field conceptField, Field typeField) {
        LikeEscapeStep isArchetype = conceptField.like((Field)DSL.inline((String)".%"));
        LinkedHashMap<Param, Param> rmTypeOrderMap = new LinkedHashMap<Param, Param>();
        Iterator it = Arrays.stream(StructureRmType.values()).sorted(Comparator.comparing(Enum::name)).iterator();
        int pos = 0;
        while (it.hasNext()) {
            rmTypeOrderMap.put(DSL.inline((String)((StructureRmType)it.next()).getAlias()), DSL.inline((int)pos++));
        }
        CaseWhenStep typeOrderField = DSL.case_((Field)typeField).mapValues(rmTypeOrderMap);
        return Stream.of(isArchetype, DSL.case_().when((Condition)isArchetype, (Field)typeOrderField), conceptField);
    }

    private static Field templateIdOrderField(Field templateUidField, TemplateService templateService) {
        Map templates = templateService.findAllTemplateIds();
        if (templates.isEmpty()) {
            LOG.warn("No template ids found: Fallback to ordering by internal UUID");
            return templateUidField;
        }
        LinkedHashMap<Param, Param> templateIdOrderMap = new LinkedHashMap<Param, Param>();
        Iterator it = templates.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue, Collator.getInstance(Locale.ENGLISH))).map(Map.Entry::getKey).iterator();
        int pos = 0;
        while (it.hasNext()) {
            templateIdOrderMap.put(DSL.inline((UUID)((UUID)it.next())), DSL.inline((int)pos++));
        }
        return DSL.case_((Field)templateUidField).mapValues(templateIdOrderMap).else_((Field)DSL.inline(null));
    }

    public static void applyPgLljWorkaround(AslQuery childQuery, AslJoin join, Table<?> relation) {
        boolean workaroundNeeded;
        boolean bl = workaroundNeeded = join.getJoinType() != null && join.getJoinType() != JoinType.JOIN && !(childQuery instanceof AslStructureQuery);
        if (workaroundNeeded) {
            Field[] fields = relation.fieldsRow().fields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                fields[i] = DSL.function((String)"COALESCE", (DataType)field.getDataType(), (Field[])new Field[]{field}).as(field.getName());
            }
        }
    }

    public static SelectField<?> selectField(AslField field, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        Table src = Optional.of(field).map(AslField::getInternalProvider).map(aslQueryToTable::getDataTable).orElse(null);
        AslField aslField = field;
        Objects.requireNonNull(aslField);
        AslField aslField2 = aslField;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslColumnField.class, AslComplexExtractedColumnField.class, AslAggregatingField.class, AslConstantField.class, AslSubqueryField.class, AslFolderItemIdVirtualField.class}, (Object)aslField2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslColumnField f = (AslColumnField)aslField2;
                yield FieldUtils.field(Objects.requireNonNull(src), f, true).as(f.getName(true));
            }
            case 1 -> {
                AslComplexExtractedColumnField ecf = (AslComplexExtractedColumnField)aslField2;
                yield EncapsulatingQueryUtils.sqlSelectFieldForExtractedColumn(ecf, Objects.requireNonNull(src));
            }
            case 2 -> {
                AslAggregatingField af = (AslAggregatingField)aslField2;
                yield EncapsulatingQueryUtils.sqlAggregatingField(af, src, aslQueryToTable);
            }
            case 3 -> {
                AslConstantField cf = (AslConstantField)aslField2;
                yield DSL.inline(cf.getValue(), cf.getType());
            }
            case 4 -> {
                AslSubqueryField sqf = (AslSubqueryField)aslField2;
                yield EncapsulatingQueryUtils.subqueryField(sqf, aslQueryToTable);
            }
            case 5 -> {
                AslFolderItemIdVirtualField fidv = (AslFolderItemIdVirtualField)aslField2;
                throw new IllegalArgumentException("%s is not support as select field".formatted(new Object[]{fidv.getExtractedColumn()}));
            }
        };
    }

    @Nonnull
    public static Stream<Field<?>> groupByFields(AslField gb, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        Table<?> src = aslQueryToTable.getDataTable(gb.getInternalProvider());
        AslField aslField = gb;
        Objects.requireNonNull(aslField);
        AslField aslField2 = aslField;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslColumnField.class, AslComplexExtractedColumnField.class, AslSubqueryField.class, AslConstantField.class, AslAggregatingField.class, AslFolderItemIdVirtualField.class}, (Object)aslField2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslColumnField f = (AslColumnField)aslField2;
                yield Stream.of(FieldUtils.field(src, f, true));
            }
            case 1 -> {
                AslComplexExtractedColumnField ecf = (AslComplexExtractedColumnField)aslField2;
                switch (ecf.getExtractedColumn()) {
                    case VO_ID: {
                        Field<?> voIdField = FieldUtils.field(src, ecf, Tables.COMP_DATA.VO_ID.getName(), true);
                        Field<?> versionField = FieldUtils.field(src, ecf, Tables.COMP_VERSION.SYS_VERSION.getName(), true);
                        yield Stream.of(voIdField, versionField);
                    }
                    case ARCHETYPE_NODE_ID: {
                        Field<?> conceptField = FieldUtils.field(src, ecf, Tables.COMP_DATA.ENTITY_CONCEPT.getName(), true);
                        Field<?> typeField = FieldUtils.field(src, ecf, Tables.COMP_DATA.RM_ENTITY.getName(), true);
                        yield Stream.of(typeField, conceptField);
                    }
                }
                throw new IllegalArgumentException("%s is not a complex extracted column".formatted(new Object[]{ecf.getExtractedColumn()}));
            }
            case 2 -> {
                AslSubqueryField sqf = (AslSubqueryField)aslField2;
                yield Stream.of(EncapsulatingQueryUtils.subqueryField(sqf, aslQueryToTable));
            }
            case 3 -> {
                AslConstantField __ = (AslConstantField)aslField2;
                yield Stream.empty();
            }
            case 4 -> {
                AslAggregatingField __ = (AslAggregatingField)aslField2;
                throw new IllegalArgumentException("Cannot aggregate by AslAggregatingField");
            }
            case 5 -> {
                AslFolderItemIdVirtualField __ = (AslFolderItemIdVirtualField)aslField2;
                throw new IllegalArgumentException("Cannot aggregate by AslFolderItemIdValuesColumnField");
            }
        };
    }

    private static Stream<Field<?>> complexExtractedColumnOrderByFields(AslComplexExtractedColumnField ecf, Table<?> src) {
        return switch (ecf.getExtractedColumn()) {
            case AslExtractedColumn.VO_ID -> Stream.of(FieldUtils.field(src, ecf, Tables.COMP_DATA.VO_ID.getName(), true));
            case AslExtractedColumn.ARCHETYPE_NODE_ID -> {
                Field<?> conceptField = FieldUtils.field(src, ecf, Tables.COMP_DATA.ENTITY_CONCEPT.getName(), true);
                Field<?> typeField = FieldUtils.field(src, ecf, Tables.COMP_DATA.RM_ENTITY.getName(), true);
                yield EncapsulatingQueryUtils.archetypeNodeIdOrderFields(conceptField, typeField);
            }
            default -> throw new IllegalArgumentException("Order by %s is not supported".formatted(new Object[]{ecf.getExtractedColumn()}));
        };
    }

    @Nonnull
    public static Stream<SortField<?>> orderFields(AslOrderByField ob, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable, TemplateService templateService) {
        AslField aslField = ob.field();
        Table<?> src = aslQueryToTable.getDataTable(aslField.getInternalProvider());
        AslField aslField2 = aslField;
        Objects.requireNonNull(aslField2);
        AslField aslField3 = aslField2;
        int n = 0;
        return (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslDvOrderedColumnField.class, AslColumnField.class, AslComplexExtractedColumnField.class, AslConstantField.class, AslSubqueryField.class, AslAggregatingField.class, AslFolderItemIdVirtualField.class}, (Object)aslField3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslDvOrderedColumnField f = (AslDvOrderedColumnField)aslField3;
                yield Stream.of(AdditionalSQLFunctions.jsonb_dv_ordered_magnitude(FieldUtils.field(src, f, true)));
            }
            case 1 -> {
                AslColumnField f = (AslColumnField)aslField3;
                yield EncapsulatingQueryUtils.columnOrderField(f, src, templateService);
            }
            case 2 -> {
                AslComplexExtractedColumnField ecf = (AslComplexExtractedColumnField)aslField3;
                yield EncapsulatingQueryUtils.complexExtractedColumnOrderByFields(ecf, src);
            }
            case 3 -> {
                AslConstantField __ = (AslConstantField)aslField3;
                yield Stream.empty();
            }
            case 4 -> {
                AslSubqueryField sqf = (AslSubqueryField)aslField3;
                yield Stream.of(EncapsulatingQueryUtils.subqueryField(sqf, aslQueryToTable));
            }
            case 5 -> {
                AslAggregatingField __ = (AslAggregatingField)aslField3;
                throw new IllegalArgumentException("ORDER BY AslAggregatingField is not allowed");
            }
            case 6 -> {
                AslFolderItemIdVirtualField __ = (AslFolderItemIdVirtualField)aslField3;
                throw new IllegalArgumentException("ORDER BY AslFolderItemIdValuesColumnField is not allowed");
            }
        }).map(f -> f.sort(ob.direction()));
    }

    @Nonnull
    private static Stream<Field<?>> columnOrderField(AslColumnField f, Table<?> src, TemplateService templateService) {
        Field field = FieldUtils.field(src, f, true);
        AslExtractedColumn aslExtractedColumn = f.getExtractedColumn();
        int n = 0;
        field = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TEMPLATE_ID", "AD_CHANGE_TYPE_VALUE", "AD_CHANGE_TYPE_PREFERRED_TERM", "AD_CHANGE_TYPE_CODE_STRING"}, (AslExtractedColumn)aslExtractedColumn, n)) {
            case 0 -> EncapsulatingQueryUtils.templateIdOrderField(field, templateService);
            case 1, 2 -> DSL.lower((Field)field.cast(String.class));
            case 3 -> DSL.case_(field).mapValues(ChangeTypeUtils.JOOQ_CHANGE_TYPE_TO_CODE);
            case -1 -> field;
            default -> field;
        };
        return Stream.of(field);
    }
}

