/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.openehr.aqlengine.asl.AslFromCreator;
import org.ehrbase.openehr.aqlengine.asl.AslUtils;
import org.ehrbase.openehr.aqlengine.asl.DataNodeInfo;
import org.ehrbase.openehr.aqlengine.asl.OwnerProviderTuple;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotNullQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslPathChildCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslTrueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslAuditDetailsJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslFilteringQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslPathDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRmObjectDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.pathanalysis.ANode;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathCohesionAnalysis;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathInfo;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.select.SelectWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ComparisonOperatorConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ConditionWrapper;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.util.AqlUtil;
import org.jooq.JSONB;
import org.jooq.JoinType;
import org.springframework.util.function.SingletonSupplier;

final class AslPathCreator {
    private final AslUtils.AliasProvider aliasProvider;
    private final KnowledgeCacheService knowledgeCacheService;
    private final String systemId;

    AslPathCreator(AslUtils.AliasProvider aliasProvider, KnowledgeCacheService knowledgeCacheService, String systemId) {
        this.aliasProvider = aliasProvider;
        this.knowledgeCacheService = knowledgeCacheService;
        this.systemId = systemId;
    }

    @Nonnull
    public PathToField addPathQueries(AqlQueryWrapper query, AslFromCreator.ContainsToOwnerProvider containsToStructureSubQuery, AslRootQuery rootQuery) {
        LinkedHashMap<IdentifiedPath, AslField> pathToField = new LinkedHashMap<IdentifiedPath, AslField>();
        this.addEhrFields(query, containsToStructureSubQuery, pathToField);
        ArrayList dataNodeInfos = new ArrayList();
        query.pathInfos().forEach((contains, pathInfo) -> {
            if ("EHR".equals(contains.getRmType())) {
                throw new IllegalArgumentException("Only paths within [EHR_STATUS,COMPOSITION,FOLDER,CLUSTER] are supported");
            }
            OwnerProviderTuple parent = containsToStructureSubQuery.get((ContainsWrapper)contains);
            AslStructureQuery.AslSourceRelation sourceRelation = ((AslStructureQuery)parent.owner()).getType();
            this.joinPathStructureNode(rootQuery, parent, null, sourceRelation, pathInfo.getCohesionTreeRoot(), (PathInfo)pathInfo, parent.provider(), -1).forEach(dataNodeInfos::add);
        });
        this.addQueriesForDataNode(dataNodeInfos.stream(), rootQuery, null, pathToField);
        return pathToField::get;
    }

    private void addEhrFields(AqlQueryWrapper query, AslFromCreator.ContainsToOwnerProvider containsToStructureSubQuery, Map<IdentifiedPath, AslField> pathToField) {
        Stream.of(query.nonPrimitiveSelects().filter(sd -> sd.type() != SelectWrapper.SelectType.AGGREGATE_FUNCTION || sd.getIdentifiedPath().isPresent()).map(s -> Pair.of((Object)s.root(), (Object)s.getIdentifiedPath().orElse(null))), AslUtils.streamConditionDescriptors(query.where()).map(ComparisonOperatorConditionWrapper::leftComparisonOperand).map(s -> Pair.of((Object)s.root(), (Object)s.path())), query.orderBy().stream().map(s -> Pair.of((Object)s.root(), (Object)s.identifiedPath()))).flatMap(s -> s).filter(p -> "EHR".equals(((ContainsWrapper)p.getLeft()).getRmType())).distinct().forEach(p -> {
            ContainsWrapper contains = (ContainsWrapper)p.getLeft();
            AslExtractedColumn ec = AslExtractedColumn.find(contains, ((IdentifiedPath)p.getRight()).getPath()).orElseThrow();
            AslQuery ehrSubquery = containsToStructureSubQuery.get(contains).owner();
            AslField field = ec == AslExtractedColumn.EHR_SYSTEM_ID_DV || ec == AslExtractedColumn.EHR_SYSTEM_ID ? new AslConstantField<String>(String.class, this.systemId, new AslField.FieldSource(ehrSubquery, ehrSubquery, ehrSubquery), ec) : AslPathCreator.findExtractedColumnField(ec, new AslField.FieldSource(ehrSubquery, ehrSubquery, ehrSubquery));
            pathToField.put((IdentifiedPath)p.getRight(), field);
        });
    }

    private void addQueriesForDataNode(Stream<DataNodeInfo> dataNodeInfos, AslRootQuery rootQuery, AslPathDataQuery parentPathDataQuery, Map<IdentifiedPath, AslField> pathToField) {
        dataNodeInfos.forEach(dni -> {
            DataNodeInfo dataNodeInfo = dni;
            Objects.requireNonNull(dataNodeInfo);
            DataNodeInfo selector0$temp = dataNodeInfo;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataNodeInfo.ExtractedColumnDataNodeInfo.class, DataNodeInfo.JsonRmDataNodeInfo.class, DataNodeInfo.StructureRmDataNodeInfo.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataNodeInfo.ExtractedColumnDataNodeInfo ecDni = (DataNodeInfo.ExtractedColumnDataNodeInfo)selector0$temp;
                    this.addExtractedColumns(rootQuery, ecDni, pathToField);
                    break;
                }
                case 1: {
                    DataNodeInfo.JsonRmDataNodeInfo jrdDni = (DataNodeInfo.JsonRmDataNodeInfo)selector0$temp;
                    this.addPathDataQuery(jrdDni, rootQuery, parentPathDataQuery, pathToField);
                    break;
                }
                case 2: {
                    DataNodeInfo.StructureRmDataNodeInfo srdDni = (DataNodeInfo.StructureRmDataNodeInfo)selector0$temp;
                    this.addRmObjectData(srdDni, rootQuery, pathToField);
                }
            }
            dni.node().getPathsEndingAtNode().forEach(ip -> this.addFilterQueryIfRequired((DataNodeInfo)dni, (IdentifiedPath)ip, rootQuery, pathToField));
        });
    }

    private void addPathDataQuery(DataNodeInfo.JsonRmDataNodeInfo dni, AslRootQuery rootQuery, AslPathDataQuery parentPathDataQuery, Map<IdentifiedPath, AslField> pathToField) {
        AslPathDataQuery dataQuery;
        boolean hasPathQueryParent = parentPathDataQuery != null;
        boolean splitMultipleValued = dni.multipleValued() && !hasPathQueryParent;
        AslPathDataQuery base = hasPathQueryParent ? parentPathDataQuery : (AslStructureQuery)dni.parent().owner();
        AslQuery provider = hasPathQueryParent ? parentPathDataQuery : dni.providerSubQuery();
        String alias = this.aliasProvider.uniqueAlias("pd");
        if (splitMultipleValued) {
            AslPathDataQuery arrayQuery = new AslPathDataQuery(alias + "_array", base, provider, dni.pathInJson(), false, dni.dvOrderedTypes(), JSONB.class);
            rootQuery.addChild(arrayQuery, new AslJoin(provider, JoinType.LEFT_OUTER_JOIN, (AslQuery)arrayQuery, new AslJoinCondition[0]));
            dataQuery = new AslPathDataQuery(alias, arrayQuery, arrayQuery, List.of(), true, dni.dvOrderedTypes(), dni.type());
            rootQuery.addChild(dataQuery, new AslJoin((AslQuery)arrayQuery, JoinType.LEFT_OUTER_JOIN, (AslQuery)dataQuery, new AslJoinCondition[0]));
        } else {
            dataQuery = new AslPathDataQuery(alias, base, provider, dni.pathInJson(), dni.multipleValued(), dni.dvOrderedTypes(), dni.type());
            rootQuery.addChild(dataQuery, new AslJoin(provider, JoinType.LEFT_OUTER_JOIN, (AslQuery)dataQuery, new AslJoinCondition[0]));
        }
        dni.node().getPathsEndingAtNode().forEach(path -> pathToField.put((IdentifiedPath)path, dataQuery.getSelect().getFirst()));
        this.addQueriesForDataNode(dni.dependentPathDataNodes(), rootQuery, dataQuery, pathToField);
    }

    private void addFilterQueryIfRequired(DataNodeInfo dni, IdentifiedPath identifiedPath, AslRootQuery rootQuery, Map<IdentifiedPath, AslField> pathToField) {
        List<AslJoinCondition> filterConditions = Stream.concat(rootQuery.getChildren().stream().filter(jp -> jp.getLeft() == dni.providerSubQuery()).map(Pair::getRight).filter(Objects::nonNull).map(AslJoin::getLeft), Stream.of(dni.providerSubQuery())).map(AslQuery::joinConditionsForFiltering).map(m -> m.getOrDefault(identifiedPath, Collections.emptyList())).flatMap(Collection::stream).filter(jc -> !(jc.getCondition() instanceof AslTrueQueryCondition)).map(jc -> jc.withLeftProvider(rootQuery)).map(AslJoinCondition.class::cast).toList();
        if (!filterConditions.isEmpty()) {
            AslField sourceField = pathToField.get(identifiedPath);
            if (sourceField instanceof AslSubqueryField) {
                AslSubqueryField sf = (AslSubqueryField)sourceField;
                AslSubqueryField filtered = sf.withFilterConditions(filterConditions);
                pathToField.replace(identifiedPath, filtered);
            } else {
                AslFilteringQuery filteringQuery = new AslFilteringQuery(this.aliasProvider.uniqueAlias(sourceField.getOwner().getAlias() + "_f"), sourceField);
                rootQuery.addChild(filteringQuery, new AslJoin(sourceField.getInternalProvider(), JoinType.LEFT_OUTER_JOIN, (AslQuery)filteringQuery, filterConditions));
                pathToField.replace(identifiedPath, filteringQuery.getSelect().getFirst());
            }
        }
    }

    private void addRmObjectData(DataNodeInfo.StructureRmDataNodeInfo dni, AslRootQuery rootQuery, Map<IdentifiedPath, AslField> pathToField) {
        AslStructureQuery base = (AslStructureQuery)dni.parent().owner();
        AslQuery provider = dni.providerSubQuery();
        AslRmObjectDataQuery dataQuery = new AslRmObjectDataQuery(this.aliasProvider.uniqueAlias("pd"), base, provider);
        AslSubqueryField field = AslSubqueryField.createAslSubqueryField(JSONB.class, dataQuery);
        dni.node().getPathsEndingAtNode().forEach(path -> pathToField.put((IdentifiedPath)path, field));
    }

    private void addExtractedColumns(AslRootQuery root, DataNodeInfo.ExtractedColumnDataNodeInfo dni, Map<IdentifiedPath, AslField> pathToField) {
        AslField.FieldSource fieldSource = new AslField.FieldSource(dni.parent().owner(), dni.providerSubQuery(), root);
        AslField field = this.createExtractedColumnField(dni.extractedColumn(), fieldSource);
        dni.node().getPathsEndingAtNode().forEach(path -> pathToField.put((IdentifiedPath)path, field));
    }

    private AslField createExtractedColumnField(AslExtractedColumn ec, AslField.FieldSource fieldSource) {
        return switch (ec) {
            default -> throw new MatchException(null, null);
            case AslExtractedColumn.NAME_VALUE, AslExtractedColumn.TEMPLATE_ID, AslExtractedColumn.EHR_ID, AslExtractedColumn.ROOT_CONCEPT, AslExtractedColumn.OV_CONTRIBUTION_ID, AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.AD_CHANGE_TYPE_PREFERRED_TERM, AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING, AslExtractedColumn.AD_CHANGE_TYPE_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_DV, AslExtractedColumn.AD_DESCRIPTION_VALUE, AslExtractedColumn.AD_DESCRIPTION_DV, AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_TIME_CREATED_DV -> AslPathCreator.findExtractedColumnField(ec, fieldSource);
            case AslExtractedColumn.AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE -> new AslConstantField<String>(String.class, "openehr", fieldSource, ec);
            case AslExtractedColumn.AD_SYSTEM_ID, AslExtractedColumn.EHR_SYSTEM_ID, AslExtractedColumn.EHR_SYSTEM_ID_DV -> new AslConstantField<String>(String.class, this.systemId, fieldSource, ec);
            case AslExtractedColumn.VO_ID, AslExtractedColumn.ARCHETYPE_NODE_ID -> new AslComplexExtractedColumnField(ec, fieldSource);
        };
    }

    @Nonnull
    private static AslColumnField findExtractedColumnField(AslExtractedColumn ec, AslField.FieldSource fieldSource) {
        AslColumnField field = AslUtils.findFieldForOwner(ec.getColumns().getFirst(), fieldSource.internalProvider().getSelect(), fieldSource.owner()).withProvider(fieldSource.provider());
        if (field.getExtractedColumn() == null) {
            field = new AslColumnField(field.getType(), field.getColumnName(), new AslField.FieldSource(field.getOwner(), field.getInternalProvider(), field.getProvider()), field.isVersionTableField(), ec);
        }
        return field;
    }

    private Stream<DataNodeInfo> joinPathStructureNode(AslEncapsulatingQuery query, OwnerProviderTuple parent, PathInfo.JoinMode parentJoinMode, AslStructureQuery.AslSourceRelation sourceRelation, PathCohesionAnalysis.PathCohesionTreeNode currentNode, PathInfo pathInfo, AslQuery rootProviderQuery, int structureLevel) {
        AslStructureQuery sq;
        AslEncapsulatingQuery currentQuery;
        OwnerProviderTuple subQuery;
        PathInfo.JoinMode joinMode = pathInfo.joinMode(currentNode);
        if (joinMode == PathInfo.JoinMode.ROOT) {
            subQuery = parent;
            currentQuery = query;
        } else {
            sq = this.pathStructureSubQuery(currentNode.getAttribute().getAttribute(), currentNode.getAttribute().getPredicateOrOperands(), sourceRelation, pathInfo.getTargetTypes(currentNode));
            subQuery = new OwnerProviderTuple(sq, sq);
            if (parentJoinMode == PathInfo.JoinMode.INTERNAL_SINGLE_CHILD) {
                currentQuery = AslPathCreator.addInternalPathNode(query, parent, sourceRelation, sq, currentNode);
            } else {
                currentQuery = this.addEncapsulatingQueryWithPathNode(query, parent, parentJoinMode, sourceRelation, sq, currentNode);
                if (parentJoinMode == PathInfo.JoinMode.ROOT) {
                    rootProviderQuery = currentQuery;
                }
            }
        }
        AslQuery aslQuery = subQuery.owner();
        if (aslQuery instanceof AslStructureQuery) {
            sq = (AslStructureQuery)aslQuery;
            this.addFiltersToPathNodeSubquery(currentNode, structureLevel, sq);
        }
        AslQuery finalRootProviderSubQuery = rootProviderQuery;
        Stream<DataNodeInfo> dataNodeInfoStream = currentNode.getChildren().stream().flatMap(child -> this.handlePathStructureNodeChild(sourceRelation, pathInfo, structureLevel, (PathCohesionAnalysis.PathCohesionTreeNode)child, subQuery, currentQuery, finalRootProviderSubQuery, joinMode));
        if (!(joinMode != PathInfo.JoinMode.ROOT && joinMode != PathInfo.JoinMode.DATA || currentNode.getPathsEndingAtNode().isEmpty())) {
            return Stream.of(dataNodeInfoStream, Stream.of(new DataNodeInfo.StructureRmDataNodeInfo(currentNode, subQuery, currentQuery, rootProviderQuery))).flatMap(s -> s);
        }
        return dataNodeInfoStream;
    }

    private Stream<DataNodeInfo> handlePathStructureNodeChild(AslStructureQuery.AslSourceRelation sourceRelation, PathInfo pathInfo, int structureLevel, PathCohesionAnalysis.PathCohesionTreeNode child, OwnerProviderTuple subQuery, AslEncapsulatingQuery currentQuery, AslQuery rootProvider, PathInfo.JoinMode joinMode) {
        AslStructureQuery sq;
        AslQuery aslQuery = subQuery.owner();
        if (aslQuery instanceof AslStructureQuery && (sq = (AslStructureQuery)aslQuery).isRepresentsOriginalVersionExpression() && pathInfo.getTargetTypes(child).stream().anyMatch("AUDIT_DETAILS"::equals)) {
            return this.joinAuditDetailsPaths(currentQuery, subQuery, child, rootProvider);
        }
        ANode.NodeCategory nodeCategory = pathInfo.getNodeCategory(child);
        return switch (nodeCategory) {
            default -> throw new MatchException(null, null);
            case ANode.NodeCategory.STRUCTURE -> this.joinPathStructureNode(currentQuery, subQuery, joinMode, sourceRelation, child, pathInfo, rootProvider, structureLevel + 1);
            case ANode.NodeCategory.STRUCTURE_INTERMEDIATE, ANode.NodeCategory.FOUNDATION_EXTENDED -> throw new IllegalArgumentException();
            case ANode.NodeCategory.RM_TYPE -> AslPathCreator.joinRmTypeNode(child, currentQuery, subQuery, rootProvider, pathInfo, 1);
            case ANode.NodeCategory.FOUNDATION -> AslPathCreator.joinFoundationNode(child, currentQuery, subQuery, rootProvider, pathInfo, 1);
        };
    }

    @Nonnull
    private AslEncapsulatingQuery addEncapsulatingQueryWithPathNode(AslEncapsulatingQuery query, OwnerProviderTuple parent, PathInfo.JoinMode parentJoinMode, AslStructureQuery.AslSourceRelation sourceRelation, AslStructureQuery sq, PathCohesionAnalysis.PathCohesionTreeNode currentNode) {
        AslEncapsulatingQuery currentQuery = new AslEncapsulatingQuery(this.aliasProvider.uniqueAlias("p_eq"));
        currentQuery.addChild(sq, null);
        AslQuery parentProvider = parentJoinMode == PathInfo.JoinMode.ROOT ? parent.provider() : parent.owner();
        AslJoinCondition[] joinConditions = (AslJoinCondition[])Stream.concat(Stream.of(new AslPathChildCondition(sourceRelation, parentProvider, parent.owner(), sourceRelation, currentQuery, sq).provideJoinCondition()), AslPathCreator.parentFiltersAsJoinCondition(parent, currentNode).stream()).toArray(AslJoinCondition[]::new);
        query.addChild(currentQuery, new AslJoin(parent.provider(), JoinType.LEFT_OUTER_JOIN, (AslQuery)currentQuery, joinConditions));
        if (parentJoinMode == PathInfo.JoinMode.INTERNAL_FORK) {
            query.addConditionOr(new AslNotNullQueryCondition(AslUtils.findFieldForOwner(AslStructureColumn.VO_ID, currentQuery.getSelect(), (AslQuery)sq)));
        }
        return currentQuery;
    }

    @Nonnull
    private static AslEncapsulatingQuery addInternalPathNode(AslEncapsulatingQuery query, OwnerProviderTuple parent, AslStructureQuery.AslSourceRelation sourceRelation, AslStructureQuery nodeSubquery, PathCohesionAnalysis.PathCohesionTreeNode currentNode) {
        ArrayList<AslJoinCondition> childNodeJoinConditions = new ArrayList<AslJoinCondition>();
        AslPathCreator.parentFiltersAsJoinCondition(parent, currentNode).ifPresent(childNodeJoinConditions::add);
        childNodeJoinConditions.add(new AslPathChildCondition(sourceRelation, parent.provider(), parent.owner(), sourceRelation, nodeSubquery, nodeSubquery).provideJoinCondition());
        query.addChild(nodeSubquery, new AslJoin(parent.provider(), JoinType.JOIN, (AslQuery)nodeSubquery, childNodeJoinConditions));
        return query;
    }

    private void addFiltersToPathNodeSubquery(PathCohesionAnalysis.PathCohesionTreeNode currentNode, int structureLevel, AslStructureQuery sq) {
        List condition1 = currentNode.getAttribute().getPredicateOrOperands();
        long attributePredicateCount = AqlUtil.streamPredicates((List)condition1).count();
        List<Pair> allPathPredicates = currentNode.getPaths().stream().map(ip -> Pair.of((Object)ip, (Object)(structureLevel < 0 ? ListUtils.emptyIfNull((List)ip.getRootPredicate()) : ((AqlObjectPath.PathNode)ip.getPath().getPathNodes().get(structureLevel)).getPredicateOrOperands()))).toList();
        if (allPathPredicates.stream().map(Pair::getRight).map(AqlUtil::streamPredicates).map(Stream::count).anyMatch(c -> attributePredicateCount != c)) {
            allPathPredicates.forEach(p -> sq.addJoinConditionForFiltering((IdentifiedPath)p.getKey(), AslUtils.predicates((List)p.getRight(), cp -> AslUtils.structurePredicateCondition(cp, sq, arg_0 -> ((KnowledgeCacheService)this.knowledgeCacheService).findUuidByTemplateId(arg_0))).orElse(new AslTrueQueryCondition())));
        }
    }

    private static Optional<AslPathFilterJoinCondition> parentFiltersAsJoinCondition(OwnerProviderTuple parent, PathCohesionAnalysis.PathCohesionTreeNode currentNode) {
        Map<IdentifiedPath, List<AslPathFilterJoinCondition>> filterConditions = parent.owner().joinConditionsForFiltering();
        if (filterConditions.isEmpty()) {
            return Optional.empty();
        }
        return AslUtils.reduceConditions(ConditionWrapper.LogicalConditionOperator.OR, filterConditions.entrySet().stream().filter(e -> currentNode.getPaths().contains(e.getKey())).map(Map.Entry::getValue).map(Collection::stream).map(jc -> jc.map(AslPathFilterJoinCondition::getCondition)).map(AslUtils::and).filter(Objects::nonNull)).filter(condition -> !(condition instanceof AslTrueQueryCondition)).map(condition -> new AslPathFilterJoinCondition(parent.owner(), (AslQueryCondition)condition));
    }

    private Stream<DataNodeInfo> joinAuditDetailsPaths(AslEncapsulatingQuery currentQuery, OwnerProviderTuple parent, PathCohesionAnalysis.PathCohesionTreeNode currentNode, AslQuery rootProviderSubQuery) {
        SingletonSupplier auditDetailsParent = SingletonSupplier.of(() -> this.addAuditDetailsSubQuery(currentQuery, parent));
        Map<IdentifiedPath, PathCohesionAnalysis.PathCohesionTreeNode> pathToNode = AslPathCreator.streamCohesionTreeNodes(currentNode).flatMap(n -> n.getPathsEndingAtNode().stream().map(p -> Pair.of((Object)p, (Object)n))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        return currentNode.getPaths().stream().map(ip -> Pair.of((Object)ip, (Object)((Object)AslExtractedColumn.find("ORIGINAL_VERSION", ip.getPath()).or(() -> AslExtractedColumn.find("AUDIT_DETAILS", ip.getPath(), 1)).orElseThrow()))).map(arg_0 -> AslPathCreator.lambda$joinAuditDetailsPaths$33(pathToNode, (Supplier)auditDetailsParent, parent, rootProviderSubQuery, arg_0));
    }

    private OwnerProviderTuple addAuditDetailsSubQuery(AslEncapsulatingQuery currentQuery, OwnerProviderTuple parent) {
        List<AslField> fields = Stream.of(Tables.AUDIT_DETAILS.ID, Tables.AUDIT_DETAILS.DESCRIPTION, Tables.AUDIT_DETAILS.CHANGE_TYPE).map(f -> new AslColumnField(f.getType(), f.getName(), null, false, null)).toList();
        AslStructureQuery auditDetailsQuery = new AslStructureQuery(this.aliasProvider.uniqueAlias("p_ca"), AslStructureQuery.AslSourceRelation.AUDIT_DETAILS, fields, Set.of("AUDIT_DETAILS"), Set.of("AUDIT_DETAILS"), null, false);
        currentQuery.addChild(auditDetailsQuery, new AslJoin(parent.provider(), JoinType.JOIN, (AslQuery)auditDetailsQuery, new AslAuditDetailsJoinCondition(parent.owner(), auditDetailsQuery)));
        return new OwnerProviderTuple(auditDetailsQuery, auditDetailsQuery);
    }

    private static Stream<PathCohesionAnalysis.PathCohesionTreeNode> streamCohesionTreeNodes(PathCohesionAnalysis.PathCohesionTreeNode node) {
        return Stream.of(Stream.of(node), node.getChildren().stream().flatMap(AslPathCreator::streamCohesionTreeNodes)).flatMap(Function.identity());
    }

    private static Stream<DataNodeInfo> streamJsonRmDataNodes(PathCohesionAnalysis.PathCohesionTreeNode currentNode, OwnerProviderTuple subQuery, AslEncapsulatingQuery query, AslQuery rootProviderSubQuery, PathInfo pathInfo, Stream<DataNodeInfo> dependentNodes, int levelInJson) {
        boolean pathsEndingAtNode;
        boolean multipleValued = pathInfo.isMultipleValued(currentNode);
        boolean bl = pathsEndingAtNode = !currentNode.getPathsEndingAtNode().isEmpty();
        if (!pathsEndingAtNode && !multipleValued) {
            return Stream.empty();
        }
        List<AqlObjectPath.PathNode> pathToNode = pathInfo.getPathToNode(currentNode);
        Class fieldType = Set.of("STRING").equals(pathInfo.getTargetTypes(currentNode)) ? String.class : JSONB.class;
        return Stream.of(new DataNodeInfo.JsonRmDataNodeInfo(currentNode, subQuery, query, rootProviderSubQuery, pathToNode.subList(pathToNode.size() - levelInJson, pathToNode.size()), pathInfo.isMultipleValued(currentNode), dependentNodes, pathInfo.getDvOrderedTypes(currentNode), fieldType));
    }

    private static Stream<DataNodeInfo> joinRmTypeNode(PathCohesionAnalysis.PathCohesionTreeNode currentNode, AslEncapsulatingQuery query, OwnerProviderTuple parentStructureQuery, AslQuery rootProviderQuery, PathInfo pathInfo, int levelInJson) {
        boolean multipleValued = pathInfo.isMultipleValued(currentNode);
        int nextLevelInJson = multipleValued ? 1 : levelInJson + 1;
        OwnerProviderTuple parent = multipleValued ? null : parentStructureQuery;
        Stream childNodes = currentNode.getChildren().stream().flatMap(child -> {
            ANode.NodeCategory nodeCategory = pathInfo.getNodeCategory((PathCohesionAnalysis.PathCohesionTreeNode)child);
            return switch (nodeCategory) {
                default -> throw new MatchException(null, null);
                case ANode.NodeCategory.STRUCTURE, ANode.NodeCategory.STRUCTURE_INTERMEDIATE -> throw new IllegalArgumentException();
                case ANode.NodeCategory.FOUNDATION_EXTENDED, ANode.NodeCategory.RM_TYPE -> AslPathCreator.joinRmTypeNode(child, query, parent, rootProviderQuery, pathInfo, nextLevelInJson);
                case ANode.NodeCategory.FOUNDATION -> AslPathCreator.joinFoundationNode(child, query, parent, rootProviderQuery, pathInfo, nextLevelInJson);
            };
        });
        return Stream.of(AslPathCreator.streamJsonRmDataNodes(currentNode, parentStructureQuery, query, rootProviderQuery, pathInfo, multipleValued ? childNodes : Stream.empty(), levelInJson), multipleValued ? Stream.empty() : childNodes).flatMap(s -> s);
    }

    private static Stream<DataNodeInfo> joinFoundationNode(PathCohesionAnalysis.PathCohesionTreeNode currentNode, AslEncapsulatingQuery query, OwnerProviderTuple parentStructureQuery, AslQuery rootProviderQuery, PathInfo pathInfo, int levelInJson) {
        Optional extractedColumnInfo;
        AslQuery parent = Optional.ofNullable(parentStructureQuery).map(OwnerProviderTuple::owner).orElse(null);
        if (parent instanceof AslStructureQuery) {
            AslStructureQuery sq = (AslStructureQuery)parent;
            v0 = Stream.of(AslExtractedColumn.values()).filter(ec -> ec.getAllowedRmTypes().stream().anyMatch(t -> sq.getRmTypes().contains(t) || sq.isRepresentsOriginalVersionExpression() && "ORIGINAL_VERSION".equals(t))).filter(ec -> levelInJson == ec.getPath().getPathNodes().size()).filter(ec -> currentNode.getPaths().stream().allMatch(p -> p.getPath().endsWith(ec.getPath()))).findFirst().map(ec -> new DataNodeInfo.ExtractedColumnDataNodeInfo(currentNode, parentStructureQuery, rootProviderQuery, (AslExtractedColumn)((Object)ec)));
        } else {
            v0 = extractedColumnInfo = Optional.empty();
        }
        if (extractedColumnInfo.isPresent()) {
            return extractedColumnInfo.stream();
        }
        return AslPathCreator.streamJsonRmDataNodes(currentNode, parentStructureQuery, query, rootProviderQuery, pathInfo, Stream.empty(), levelInJson);
    }

    private AslStructureQuery pathStructureSubQuery(String attribute, List<AndOperatorPredicate> attributePredicates, AslStructureQuery.AslSourceRelation sourceRelation, Collection<String> rmTypes) {
        List<AslField> fields = Arrays.stream(AslStructureColumn.values()).filter(c -> sourceRelation.getDataTable().field(c.getFieldName()) != null).map(AslStructureColumn::field).collect(Collectors.toList());
        fields.add(new AslColumnField(String.class, "entity_attribute", false));
        String sqAlias = this.aliasProvider.uniqueAlias("p_" + attribute + "_");
        AslStructureQuery aslStructureQuery = new AslStructureQuery(sqAlias, sourceRelation, fields, rmTypes, List.of(), attribute, false);
        AslUtils.predicates(attributePredicates, cp -> AslPathCreator.pathStructurePredicateCondition(cp, aslStructureQuery)).ifPresent(aslStructureQuery::addConditionAnd);
        return aslStructureQuery;
    }

    @Nonnull
    private static AslFieldValueQueryCondition<?> pathStructurePredicateCondition(ComparisonOperatorPredicate cp, AslStructureQuery aslStructureQuery) {
        String value = (String)((Object)((StringPrimitive)cp.getValue()).getValue());
        if (AqlObjectPathUtil.ARCHETYPE_NODE_ID.equals((Object)cp.getPath())) {
            return new AslFieldValueQueryCondition<AslRmTypeAndConcept>(AslComplexExtractedColumnField.archetypeNodeIdField(AslField.FieldSource.withOwner(aslStructureQuery)), AslQueryCondition.AslConditionOperator.EQ, List.of(AslRmTypeAndConcept.fromArchetypeNodeId(value)));
        }
        if (AqlObjectPathUtil.NAME_VALUE.equals((Object)cp.getPath())) {
            return new AslFieldValueQueryCondition<String>(AslUtils.findFieldForOwner(AslStructureColumn.ENTITY_NAME, aslStructureQuery.getSelect(), (AslQuery)aslStructureQuery), AslQueryCondition.AslConditionOperator.EQ, List.of(value));
        }
        throw new IllegalArgumentException("Unexpected attribute predicate path: %s".formatted(cp.getPath()));
    }

    private static /* synthetic */ DataNodeInfo lambda$joinAuditDetailsPaths$33(Map pathToNode, Supplier auditDetailsParent, OwnerProviderTuple parent, AslQuery rootProviderSubQuery, Pair p) {
        boolean isAuditDetailsColumn = ((AslExtractedColumn)((Object)p.getRight())).getAllowedRmTypes().contains("AUDIT_DETAILS");
        return new DataNodeInfo.ExtractedColumnDataNodeInfo((PathCohesionAnalysis.PathCohesionTreeNode)pathToNode.get(p.getLeft()), isAuditDetailsColumn ? (OwnerProviderTuple)auditDetailsParent.get() : parent, isAuditDetailsColumn ? ((OwnerProviderTuple)auditDetailsParent.get()).owner() : rootProviderSubQuery, (AslExtractedColumn)((Object)p.getRight()));
    }

    @FunctionalInterface
    static interface PathToField {
        public AslField getField(IdentifiedPath var1);
    }
}

