/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine;

import org.assertj.core.api.Assertions;
import org.ehrbase.openehr.aqlengine.AqlEhrPathPostProcessor;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class AqlEhrPathPostProcessorTest {
    AqlEhrPathPostProcessorTest() {
    }

    @ParameterizedTest
    @CsvSource(textBlock="SELECT e/ehr_status AS s FROM EHR e=>SELECT s AS s FROM EHR e CONTAINS EHR_STATUS s\nSELECT s/uid/value, e/ehr_status/subject/external_ref/id FROM EHR e CONTAINS COMPOSITION s WHERE e/ehr_status/is_modifiable = true=>SELECT s/uid/value, s1/subject/external_ref/id FROM EHR e CONTAINS (EHR_STATUS s1 AND COMPOSITION s) WHERE s1/is_modifiable = true\n", delimiterString="=>")
    void resolveEhrStatus(String srcAql, String expectedAql) {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)srcAql);
        AqlEhrPathPostProcessor.replaceEhrPaths((AqlQuery)aqlQuery);
        Assertions.assertThat((String)aqlQuery.render()).isEqualTo(expectedAql.replaceAll(" +", " "));
    }
}

