/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.util;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.ehrbase.openehr.util.TreeNode;
import org.ehrbase.openehr.util.TreeUtils;
import org.junit.jupiter.api.Test;

class TreeNodeTest {
    TreeNodeTest() {
    }

    @Test
    void testSimpleTree() {
        MyNode root = MyNode.root(0);
        MyNode n1 = root.addChild(1);
        MyNode n11 = n1.addChild(11);
        MyNode n12 = n1.addChild(12);
        MyNode n123 = n12.addChild(123);
        MyNode n13 = n1.addChild(13);
        MyNode n2 = root.addChild(2);
        MyNode n3 = root.addChild(3);
        MyNode n3_1 = n3.addChild(31);
        TreeNodeTest.assertTreeMatches(root, "0\n  1\n    11\n    12\n      123\n    13\n  2\n  3\n    31");
    }

    @Test
    void testMoveChild() {
        MyNode root = TreeNodeTest.parseTree("0\n  1\n    11\n    12\n      123\n    13\n  2\n  3\n    31\n");
        MyNode n1 = (MyNode)((Object)root.getChildren().get(0));
        MyNode n12 = (MyNode)((Object)n1.getChildren().get(1));
        MyNode n3 = (MyNode)((Object)root.getChildren().get(2));
        Assertions.assertThatThrownBy(() -> n12.addChild(root)).isInstanceOf(IllegalArgumentException.class);
        n3.addChild(n12);
        TreeNodeTest.assertTreeMatches(root, "0\n  1\n    11\n    13\n  2\n  3\n    31\n    12\n      123");
    }

    @Test
    void testCreateTree() {
        String tree = "0\n  1\n    11\n    12\n      123\n    13\n  2\n  3\n    31";
        Assertions.assertThat((String)TreeNodeTest.renderTree(TreeNodeTest.parseTree(tree))).matches((CharSequence)tree);
    }

    private static MyNode parseTree(String treeGraph) {
        return (MyNode)TreeUtils.parseTree((String)treeGraph, s -> MyNode.root(Integer.parseInt(s)));
    }

    private static String renderTree(MyNode node) {
        return TreeUtils.renderTree((TreeNode)node, null, n -> Integer.toString(n.id));
    }

    private static AbstractStringAssert<?> assertTreeMatches(MyNode root, String expected) {
        return Assertions.assertThat((String)TreeNodeTest.renderTree(root)).isEqualTo(expected);
    }

    private static final class MyNode
    extends TreeNode<MyNode> {
        public final int id;

        private MyNode(int id) {
            this.id = id;
        }

        public MyNode addChild(int id) {
            return (MyNode)this.addChild(new MyNode(id));
        }

        public static MyNode root(int id) {
            return new MyNode(id);
        }
    }
}

