/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.featurecheck;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.ehrbase.api.exception.AqlFeatureNotImplementedException;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.openehr.aqlengine.AqlConfigurationProperties;
import org.ehrbase.openehr.aqlengine.featurecheck.AqlQueryFeatureCheck;
import org.ehrbase.openehr.dbformat.StructureRmType;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

class AqlQueryFeatureCheckTest {
    AqlQueryFeatureCheckTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT s FROM EHR e CONTAINS EHR_STATUS s", "SELECT e/ehr_id/value FROM EHR e CONTAINS COMPOSITION LIMIT 10 OFFSET 20", "SELECT c from EHR [ehr_id/value='b037bf7c-0ecb-40fb-aada-fc7d559815ea'] CONTAINS COMPOSITION c", "SELECT c from EHR [ehr_id/value='b037bf7c-0ecb-40fb-aada-fc7d559815ea'] CONTAINS COMPOSITION c CONTAINS OBSERVATION", "SELECT c, it from EHR [ehr_id/value='b037bf7c-0ecb-40fb-aada-fc7d559815ea']\nCONTAINS COMPOSITION c CONTAINS OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]\nCONTAINS ITEM_TREE it", "SELECT c from EHR [ehr_id/value='b037bf7c-0ecb-40fb-aada-fc7d559815ea']\nCONTAINS COMPOSITION c\nCONTAINS OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]", "SELECT e/ehr_id/value,\n    c/uid/value, c/name/value, c/archetype_node_id, c/archetype_details/template_id/value,\n    o/name/value, o/archetype_node_id\nFROM EHR e CONTAINS COMPOSITION c CONTAINS OBSERVATION o", "SELECT c from EHR [ehr_id/value='b037bf7c-0ecb-40fb-aada-fc7d559815ea']\nCONTAINS COMPOSITION c\nCONTAINS OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]", "SELECT c from EHR [ehr_id/value='b037bf7c-0ecb-40fb-aada-fc7d559815ea']\nCONTAINS COMPOSITION c\nCONTAINS OBSERVATION[name/value='Blood pressure (Training sample)']", "SELECT c from EHR [ehr_id/value='b037bf7c-0ecb-40fb-aada-fc7d559815ea']\nCONTAINS COMPOSITION c[openEHR-EHR-COMPOSITION.sample_blood_pressure.v1,'Blood pressure (Training sample)']\nCONTAINS OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1,'Blood pressure (Training sample)']", "SELECT c from EHR [ehr_id/value='b037bf7c-0ecb-40fb-aada-fc7d559815ea' OR ehr_id/value!='b037bf7c-0ecb-40fb-aada-fc7d559815ea']\nCONTAINS COMPOSITION c[name/value!='Blood pressure (Training sample)' AND archetype_node_id='openEHR-EHR-COMPOSITION.sample_blood_pressure.v1' OR uid/value='b037bf7c-0ecb-40fb-aada-fc7d559815ea']\nCONTAINS OBSERVATION[name/value!='Blood pressure (Training sample)' AND archetype_node_id='openEHR-EHR-COMPOSITION.sample_blood_pressure.v1' OR name/value!='Blood pressure (Training sample)']", "SELECT o\nFROM EHR e CONTAINS COMPOSITION c CONTAINS OBSERVATION o\nWHERE e/ehr_id/value MATCHES {'b037bf7c-0ecb-40fb-aada-fc7d559815ea'}\n  AND (o/archetype_node_id LIKE 'openEHR-EHR-OBSERVATION.sample_blood_pressure.*'\n    OR o/name/value = 'Blood pressure (Training sample)')\n  AND c/uid/value != 'b037bf7c-0ecb-40fb-aada-fc7d559815ea'\n  AND c/archetype_details/template_id/value = 'some-template.v1'", "SELECT e/ehr_id/value, c1, c2, o, ev, a\nFROM EHR e CONTAINS(\n(COMPOSITION c1\n  CONTAINS OBSERVATION o\n  AND EVALUATION ev)\nAND COMPOSITION c2 CONTAINS ADMIN_ENTRY a)", "SELECT e/ehr_id/value, c1/content/name/value, c1/content/data/name/value, o, ev\nFROM EHR e CONTAINS\nCOMPOSITION c1\n  CONTAINS OBSERVATION o\n  CONTAINS EVALUATION ev\n  WHERE c1/content/name/value = 'My Observation'", "SELECT e/ehr_id/value, c/content/name/value\nFROM EHR e CONTAINS COMPOSITION c\nORDER BY e/ehr_id/value, c/content/name/value", "   SELECT c/context/start_time\n   FROM COMPOSITION c\n   ORDER BY c/context/start_time\n", "    SELECT ec/start_time/value\n    FROM EHR e CONTAINS COMPOSITION c CONTAINS EVENT_CONTEXT ec\n    ORDER BY ec/start_time ASC\n", "    SELECT e/ehr_id/value, c/content\n    FROM EHR e CONTAINS COMPOSITION c\n", "SELECT c/setting/defining_code/code_string FROM EVENT_CONTEXT c", "    SELECT\n    o/name/mappings,\n    o/name/mappings/target,\n    o/name/mappings/purpose/mappings,\n    o/name/mappings/purpose/mappings/target\n    FROM OBSERVATION o\n", "SELECT c/start_time/value, e/value/value, e/value/magnitude FROM EVENT_CONTEXT c CONTAINS ELEMENT e", "   SELECT c\n   FROM EVENT_CONTEXT c CONTAINS ELEMENT e\n   WHERE e/value = '1' AND c/start_time < '2023-10-13'\n", "    SELECT l/name/value\n    FROM EHR e\n    CONTAINS EHR_STATUS\n    CONTAINS ELEMENT l\n", "    SELECT s/subject/external_ref/id/value, s/other_details/items[at0001]/value/id\n    FROM EHR e\n    CONTAINS EHR_STATUS s\n", "   SELECT s/other_details/items[at0001]/value/id\n   FROM EHR e\n   CONTAINS EHR_STATUS s\n   WHERE e/ehr_id/value = '10f23be7-fd39-4e71-a0a5-9d1624d662b7'\n", "   SELECT t FROM ENTRY t\n", "   SELECT\n       e/ehr_id/value,\n       -- All allowed usages of aggregate functions\n       COUNT(*),\n       COUNT(DISTINCT c/uid/value),\n       COUNT(el),\n       COUNT(el/name/mappings),\n       COUNT(el/value),\n       COUNT(el/value/value),\n       MAX(el/value/value),\n       MIN(el/value/value),\n       MAX(el/value),\n       MIN(el/value),\n       AVG(el/value/value),\n       SUM(el/value/value)\n   FROM EHR e CONTAINS COMPOSITION c CONTAINS ELEMENT el\n", "SELECT 1 FROM EHR e", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'b037bf7c-0ecb-40fb-aada-fc7d559815ea::node::1'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'b037bf7c-0ecb-40fb-aada-fc7d559815ea::::1'", "SELECT c[openEHR-EHR-COMPOSITION.sample_blood_pressure.v1,'Blood pressure (Training sample)'] FROM COMPOSITION c", "SELECT e/ehr_id/value, e/time_created, e/time_created/value FROM EHR e WHERE e/time_created > '2021-01-02T12:13:14+01:00' ORDER BY e/time_created", "    SELECT\n     e/ehr_id/value,\n     e/system_id,\n     e/system_id/value\n    FROM EHR e\n    WHERE e/system_id/value = 'abc'\n    ORDER BY e/system_id/value\n"})
    void ensureQuerySupported(String aql) {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.runEnsureQuerySupported(aql));
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT f FROM FOLDER f", "  SELECT f/uid/value, f/name/value, f/archetype_node_id\n  FROM FOLDER f[openEHR-EHR-FOLDER.generic.v1]\n", "  SELECT f2/uid/value, f2/name/value\n  FROM FOLDER f1[openEHR-EHR-FOLDER.generic.v1,'root']\n  CONTAINS FOLDER f2[openEHR-EHR-FOLDER.generic.v1,'Encounter']\n", "  SELECT e/ehr_id/value, f/uid/value\n  FROM EHR e\n  CONTAINS FOLDER f[openEHR-EHR-FOLDER.generic.v1,'Encounter']\n", "  SELECT c/uid/value, f/name/value\n  FROM FOLDER f\n  CONTAINS COMPOSITION c\n"})
    void ensureQuerySupportedAqlOnFolderEnabled(String aql) {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.runEnsureQuerySupportedAqlOnFolderEnabled(aql));
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT f/items FROM FOLDER f", "SELECT f/folders/items FROM FOLDER f", "SELECT f/items/namespace FROM FOLDER f", "SELECT f/items/type FROM FOLDER f", "SELECT f/items/id FROM FOLDER f", "SELECT f/items/id/value FROM FOLDER f"})
    void ensureQueryNotSupportedAqlOnFolderEnabled(String aql) {
        org.junit.jupiter.api.Assertions.assertThrows(AqlFeatureNotImplementedException.class, () -> this.runEnsureQuerySupportedAqlOnFolderEnabled(aql));
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT e FROM EHR e", "SELECT e/ehr_id FROM EHR e", "SELECT e[ehr_status/subject/external_ref/id/value='abc']/ehr_id/value FROM EHR e", "SELECT c[category/defining_code/code_string='433'] FROM COMPOSITION c", "SELECT e/ehr_status FROM EHR e", "SELECT e/compositions FROM EHR e", "SELECT e/directory FROM EHR e", "SELECT e/folders FROM EHR e", "   SELECT f\n   FROM FOLDER f\n", "   SELECT c\n   FROM COMPOSITION c\n   WHERE c/uid/value = c/name/value\n", "   SELECT c\n   FROM COMPOSITION c\n   WHERE c/uid = '1'\n", "   SELECT c\n   FROM COMPOSITION c\n   WHERE EXISTS c/uid/value\n", "   SELECT c\n   FROM COMPOSITION c\n   ORDER BY c/context/start_time/value\n", "SELECT o\nFROM EHR e CONTAINS COMPOSITION c CONTAINS OBSERVATION o\nWHERE e/ehr_id/value MATCHES {'b037bf7c-0ecb-40fb-aada-fc7d559815ea'}\n  AND (o/archetype_node_id LIKE 'openEHR-EHR-OBSERVATION.sample_blood_pressure.*'\n    OR o/name/value = 'Blood pressure (Training sample)')\n  AND c/uid/value != 'b037bf7c-0ecb-40fb-aada-fc7d559815ea'\n  AND EXISTS c/name/value\n  AND c/archetype_details/template_id/value = 'some-template.v1'", "   SELECT e/ehr_id/value, AVG(c/context/start_time)\n   FROM EHR e CONTAINS COMPOSITION c\n", "   SELECT e/ehr_id/value, SUM(c/context/start_time)\n   FROM EHR e CONTAINS COMPOSITION c\n", "   SELECT e/ehr_id/value, MAX(c/uid/value)\n   FROM EHR e CONTAINS COMPOSITION c\n", "   SELECT e/ehr_id/value, MIN(c/uid/value)\n   FROM EHR e CONTAINS COMPOSITION c\n", "   SELECT e/ehr_id/value, AVG(c/uid/value)\n   FROM EHR e CONTAINS COMPOSITION c\n", "   SELECT e/ehr_id/value, SUM(c/uid/value)\n   FROM EHR e CONTAINS COMPOSITION c\n", "SELECT e/ehr_id/value FROM EHR e WHERE e/time_created/value > '2021-01-02T12:13:14+01:00'", "SELECT e/ehr_id/value FROM EHR e ORDER BY e/time_created/value"})
    void ensureQueryNotSupported(String aql) {
        org.junit.jupiter.api.Assertions.assertThrows(AqlFeatureNotImplementedException.class, () -> this.runEnsureQuerySupported(aql));
    }

    @ParameterizedTest
    @ValueSource(strings={"   SELECT c/content/content/name/value\n   FROM COMPOSITION c\n", "   SELECT c\n   FROM COMPOSITION c\n   WHERE c/content/content/name/value = 'invalid'\n"})
    void ensureInvalidPathRejected(String aql) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runEnsureQuerySupported(aql)).isInstanceOf(IllegalAqlException.class)).hasMessageEndingWith(" is not a valid RM path");
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT c FROM COMPOSITION c WHERE c/uid/value = 'foo'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'foo::node::1'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'foo::node'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'foo::::'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'foo::::1'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = ''", "SELECT c FROM COMPOSITION c WHERE c/uid/value = '::node::1'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = '::node'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = '::::'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = '::::1'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'b037bf7c-0ecb-40fb-aada-fc7d559815ea::invalid::1'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'b037bf7c-0ecb-40fb-aada-fc7d559815ea::node::foo'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'b037bf7c-0ecb-40fb-aada-fc7d559815ea::node::0'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'b037bf7c-0ecb-40fb-aada-fc7d559815ea::::foo'", "SELECT c FROM COMPOSITION c WHERE c/uid/value = 'b037bf7c-0ecb-40fb-aada-fc7d559815ea::::0'"})
    void ensureInvalidConditionRejected(String aql) {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalAqlException.class, () -> this.runEnsureQuerySupported(aql));
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT c FROM COMPOSITION c CONTAINS EHR_STATUS", "SELECT c FROM COMPOSITION c CONTAINS ELEMENT CONTAINS EHR_STATUS", "SELECT e FROM EHR CONTAINS COMPOSITION CONTAINS EHR_STATUS CONTAINS ELEMENT e"})
    void ensureContainsRejected(String aql) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runEnsureQuerySupported(aql)).isInstanceOf(IllegalAqlException.class)).hasMessageContainingAll(new CharSequence[]{"Structure ", " cannot CONTAIN ", " (of structure "});
    }

    @ParameterizedTest
    @EnumSource(value=StructureRmType.class, mode=EnumSource.Mode.INCLUDE, names={"INSTRUCTION_DETAILS", "FEEDER_AUDIT_DETAILS"})
    void ensureContainsRejectedNonStructureEntries(StructureRmType structureRmType) {
        String aql = "SELECT f FROM COMPOSITION f CONTAINS %s".formatted(structureRmType.name());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runEnsureQuerySupported(aql)).isInstanceOf(AqlFeatureNotImplementedException.class)).hasMessage("Not implemented: CONTAINS %s is currently not supported".formatted(structureRmType.name()));
    }

    @Test
    void ensureContainsRejectedExperimentalAqlOnFolderDisabled() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runEnsureQuerySupported("SELECT f FROM FOLDER f")).isInstanceOf(AqlFeatureNotImplementedException.class)).hasMessageContainingAll(new CharSequence[]{"CONTAINS FOLDER is an experimental feature and currently disabled."});
    }

    @ParameterizedTest
    @ValueSource(strings={"SELECT f FROM COMPOSITION CONTAINS FOLDER f", "SELECT f FROM EHR_STATUS CONTAINS FOLDER f"})
    void ensureContainsRejectedExperimentalAqlOnFolder(String aql) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runEnsureQuerySupportedAqlOnFolderEnabled(aql)).isInstanceOf(IllegalAqlException.class)).hasMessageContainingAll(new CharSequence[]{"Structure ", " cannot CONTAIN ", " (of structure "});
    }

    @ParameterizedTest
    @EnumSource(value=StructureRmType.class, mode=EnumSource.Mode.EXCLUDE, names={"FOLDER", "COMPOSITION", "INSTRUCTION_DETAILS", "FEEDER_AUDIT_DETAILS"})
    void ensureContainsExperimentalAqlOnFolderRestrictedToTypes(StructureRmType structureRmType) {
        String aql = "SELECT f FROM FOLDER f CONTAINS %s".formatted(structureRmType.name());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runEnsureQuerySupportedAqlOnFolderEnabled(aql)).isInstanceOf(AqlFeatureNotImplementedException.class)).hasMessage("Not implemented: FOLDER CONTAINS %s is currently not supported".formatted(structureRmType.name()));
    }

    @ParameterizedTest
    @ValueSource(strings={"   SELECT c/uid/value\n   FROM VERSION cv CONTAINS COMPOSITION c\n", "   SELECT c/uid/value\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n", "   SELECT e/ehr_id/value, c/uid/value\n   FROM EHR e CONTAINS VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n", "   SELECT\n     cv/uid/value,\n     cv/commit_audit/time_committed,\n     cv/commit_audit/time_committed/value,\n     cv/commit_audit/system_id,\n     cv/commit_audit/description,\n     cv/commit_audit/description/value,\n     cv/commit_audit/change_type,\n     cv/commit_audit/change_type/value,\n     cv/commit_audit/change_type/defining_code/code_string,\n     cv/commit_audit/change_type/defining_code/preferred_term,\n     cv/commit_audit/change_type/defining_code/terminology_id/value,\n     cv/contribution/id/value\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n   WHERE cv/uid/value = 'b037bf7c-0ecb-40fb-aada-fc7d559815ea::node::2'\n     AND cv/commit_audit/time_committed < '2021'\n     AND cv/commit_audit/system_id = 'system'\n     AND cv/commit_audit/description/value = 'description'\n     AND cv/commit_audit/change_type/value = 'ct'\n     AND cv/commit_audit/change_type/defining_code/code_string = 'ct'\n     AND cv/commit_audit/change_type/defining_code/preferred_term = 'ct'\n     AND cv/commit_audit/change_type/defining_code/terminology_id/value = 'ct'\n     AND cv/contribution/id/value = 'c037bf7c-0ecb-40fb-aada-fc7d559815eb'\n   ORDER BY\n     cv/commit_audit/change_type/defining_code/code_string,\n     cv/commit_audit/change_type/defining_code/preferred_term,\n     cv/commit_audit/change_type/value,\n     cv/commit_audit/description/value,\n     cv/commit_audit/time_committed,\n     cv/uid/value\n", "   SELECT es/uid/value\n   FROM VERSION cv[LATEST_VERSION] CONTAINS EHR_STATUS es\n", "   SELECT e/ehr_id/value, c1/uid/value, c2/uid/value\n   FROM EHR e CONTAINS\n     (VERSION[LATEST_VERSION] CONTAINS COMPOSITION c1)\n     OR (VERSION[LATEST_VERSION] CONTAINS COMPOSITION c2)\n", "   SELECT e/ehr_id/value, c1/uid/value, c2/uid/value\n   FROM EHR e CONTAINS\n     (VERSION[LATEST_VERSION] CONTAINS COMPOSITION c1)\n     AND (VERSION[LATEST_VERSION] CONTAINS COMPOSITION c2)\n"})
    void ensureVersionSupported(String aql) {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.runEnsureQuerySupported(aql));
    }

    @ParameterizedTest
    @ValueSource(strings={"   SELECT cv/commit_audit/time_committed/value\n   FROM VERSION cv[LATEST_VERSION]\n", "   SELECT el/name/value\n   FROM VERSION cv[LATEST_VERSION] CONTAINS ELEMENT el\n", "   SELECT c/name/value\n   FROM VERSION cv[LATEST_VERSION] CONTAINS VERSION cv2[LATEST_VERSION] CONTAINS COMPOSITION c\n", "   SELECT c/name/value\n   FROM COMPOSITION c CONTAINS VERSION cv[LATEST_VERSION]\n"})
    void checkIllegalVersion(String aql) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runEnsureQuerySupported(aql)).isInstanceOf(IllegalAqlException.class)).message().isNotBlank();
    }

    @ParameterizedTest
    @ValueSource(strings={"   SELECT c/uid/value\n   FROM VERSION cv[ALL_VERSIONS] CONTAINS COMPOSITION c\n", "   SELECT c/uid/value\n   FROM VERSION cv[commit_audit/time_committed > '2021-12-13'] CONTAINS COMPOSITION c\n", "   SELECT f/uid/value\n   FROM VERSION cv[LATEST_VERSION] CONTAINS FOLDER f\n", "   SELECT c1/name/value, c2/name/value\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c1 OR COMPOSITION c2\n", "   SELECT c1/name/value, c2/name/value\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c1 AND COMPOSITION c2\n", "   SELECT cv/preceding_version_uid\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n", "   SELECT cv/other_input_version_uids\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n", "   SELECT cv/data\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n", "   SELECT cv/attestations\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n", "   SELECT cv/lifecycle_state\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n", "   SELECT cv/signature\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n", "   SELECT cv\n   FROM VERSION cv[LATEST_VERSION] CONTAINS COMPOSITION c\n"})
    void ensureVersionNotSupported(String aql) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runEnsureQuerySupported(aql)).isInstanceOf(AqlFeatureNotImplementedException.class)).hasMessageStartingWith("Not implemented: ");
    }

    @Test
    void ensureVersionSupportedAqlOnFolderEnabled() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.runEnsureQuerySupportedAqlOnFolderEnabled("   SELECT f/uid/value\n   FROM VERSION cv[LATEST_VERSION] CONTAINS FOLDER f\n"));
    }

    private void runEnsureQuerySupported(String aql) {
        this.runEnsureQuerySupported(this.propertiesWithAqlOnFolderEnabled(false), aql);
    }

    private void runEnsureQuerySupportedAqlOnFolderEnabled(String aql) {
        this.runEnsureQuerySupported(this.propertiesWithAqlOnFolderEnabled(true), aql);
    }

    private void runEnsureQuerySupported(AqlConfigurationProperties aqlFeature, String aql) {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)aql);
        AqlQueryFeatureCheck aqlQueryFeatureCheck = new AqlQueryFeatureCheck(() -> "node", aqlFeature);
        aqlQueryFeatureCheck.ensureQuerySupported(aqlQuery);
    }

    private AqlConfigurationProperties propertiesWithAqlOnFolderEnabled(boolean aqlOnFolderEnabled) {
        return new AqlConfigurationProperties(false, new AqlConfigurationProperties.Experimental(new AqlConfigurationProperties.Experimental.AqlOnFolder(aqlOnFolderEnabled)));
    }
}

