/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.pathanalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.ehrbase.openehr.aqlengine.pathanalysis.ANode;
import org.ehrbase.openehr.aqlengine.pathanalysis.FoundationType;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathAnalysis;
import org.ehrbase.openehr.dbformat.RmAttributeAlias;
import org.ehrbase.openehr.sdk.aql.dto.operand.LongPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.junit.jupiter.api.Test;

class PathAnalysisTest {
    PathAnalysisTest() {
    }

    @Test
    void compositionTypes() {
        Assertions.assertThat((Collection)PathAnalysis.AttributeInfos.rmTypes).isNotEmpty();
    }

    @Test
    void baseTypesByAttribute() {
        Map cut = PathAnalysis.AttributeInfos.baseTypesByAttribute;
        Assertions.assertThat((Map)cut).isNotEmpty();
        Assertions.assertThat((Map)cut).containsKey((Object)"other_participations");
        Assertions.assertThat((Map)cut).containsEntry((Object)"other_participations", Set.of("CARE_ENTRY", "ADMIN_ENTRY", "INSTRUCTION", "OBSERVATION", "ENTRY", "ACTION", "EVALUATION"));
    }

    @Test
    void analyzeAqlPathInvalid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ANode node = PathAnalysis.analyzeAqlPathTypes((String)"COMPOSITION", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"path/links/non/existent/attributes"), null);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(": non");
    }

    @Test
    void analyzeAqlPath() {
        ANode node = PathAnalysis.analyzeAqlPathTypes((String)"COMPOSITION", null, null, null, null);
        Assertions.assertThat((Collection)node.candidateTypes).containsExactly((Object[])new String[]{"COMPOSITION"});
        Assertions.assertThat((Map)node.attributes).isEmpty();
        node = PathAnalysis.analyzeAqlPathTypes((String)"CARE_ENTRY", PathAnalysisTest.archetypeNodeIdCondition("openEHR-EHR-OBSERVATION.my-observation.v3"), null, null, null);
        Assertions.assertThat((Collection)node.candidateTypes).containsExactly((Object[])new String[]{"OBSERVATION"});
        Assertions.assertThat((Map)node.attributes).containsOnlyKeys((Object[])new String[]{"archetype_node_id"});
        node = PathAnalysis.analyzeAqlPathTypes((String)"CARE_ENTRY", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"state"), null);
        Assertions.assertThat((Collection)node.candidateTypes).containsExactly((Object[])new String[]{"OBSERVATION"});
        Assertions.assertThat((Map)node.attributes).containsOnlyKeys((Object[])new String[]{"state"});
        node = PathAnalysis.analyzeAqlPathTypes((String)"CARE_ENTRY", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"data"), null);
        Assertions.assertThat((Collection)node.candidateTypes).containsExactly((Object[])new String[]{"OBSERVATION", "EVALUATION"});
        Assertions.assertThat((Map)node.attributes).containsOnlyKeys((Object[])new String[]{"data"});
        node = PathAnalysis.analyzeAqlPathTypes((String)"CARE_ENTRY", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"data/events/state"), null);
        Assertions.assertThat((Collection)node.candidateTypes).containsExactly((Object[])new String[]{"OBSERVATION"});
        Assertions.assertThat((Map)node.attributes).containsOnlyKeys((Object[])new String[]{"data"});
        node = PathAnalysis.analyzeAqlPathTypes((String)"ITEM_STRUCTURE", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"item/value"), null);
        Assertions.assertThat((Collection)node.candidateTypes).containsExactly((Object[])new String[]{"ITEM_SINGLE"});
        Assertions.assertThat((Map)node.attributes).containsOnlyKeys((Object[])new String[]{"item"});
        ANode item = (ANode)node.attributes.get("item");
        Assertions.assertThat((Collection)item.candidateTypes).containsExactly((Object[])new String[]{"ELEMENT"});
        Assertions.assertThat((Map)item.attributes).containsOnlyKeys((Object[])new String[]{"value"});
        ANode elementValue = (ANode)item.attributes.get("value");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)elementValue.candidateTypes).isNotEmpty()).allMatch(v -> v.startsWith("DV_"));
        node = PathAnalysis.analyzeAqlPathTypes((String)"ITEM_STRUCTURE", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"item/value[defining_code/terminology_id/value='openehr']/value"), null);
        Assertions.assertThat((Collection)node.candidateTypes).containsExactly((Object[])new String[]{"ITEM_SINGLE"});
        Assertions.assertThat((Map)node.attributes).containsOnlyKeys((Object[])new String[]{"item"});
        item = (ANode)node.attributes.get("item");
        Assertions.assertThat((Collection)item.candidateTypes).containsExactly((Object[])new String[]{"ELEMENT"});
        Assertions.assertThat((Map)item.attributes).containsOnlyKeys((Object[])new String[]{"value"});
        elementValue = (ANode)item.attributes.get("value");
        Assertions.assertThat((Collection)elementValue.candidateTypes).allMatch(v -> v.startsWith("DV_"));
        Assertions.assertThat((Map)elementValue.attributes).containsOnlyKeys((Object[])new String[]{"value", "defining_code"});
        ANode valueValue = (ANode)elementValue.attributes.get("value");
        Assertions.assertThat((Collection)valueValue.candidateTypes).containsExactly((Object[])new String[]{FoundationType.STRING.name()});
        node = PathAnalysis.analyzeAqlPathTypes((String)"ITEM_STRUCTURE", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"item/value[value=10.0]/value"), null);
        Assertions.assertThat((Collection)node.candidateTypes).containsExactly((Object[])new String[]{"ITEM_SINGLE"});
        Assertions.assertThat((Map)node.attributes).containsOnlyKeys((Object[])new String[]{"item"});
        item = (ANode)node.attributes.get("item");
        Assertions.assertThat((Collection)item.candidateTypes).containsExactly((Object[])new String[]{"ELEMENT"});
        Assertions.assertThat((Map)item.attributes).containsOnlyKeys((Object[])new String[]{"value"});
        elementValue = (ANode)item.attributes.get("value");
        Assertions.assertThat((Collection)elementValue.candidateTypes).containsExactly((Object[])new String[]{"DV_SCALE", "DV_ORDINAL"});
        Set candidateTypes = PathAnalysis.getCandidateTypes((PathPredicateOperand)new LongPrimitive(Long.valueOf(10L)));
        ANode node2 = PathAnalysis.analyzeAqlPathTypes((String)"ITEM_STRUCTURE", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"item/value/value"), (Set)candidateTypes);
        Assertions.assertThat((Collection)node2.candidateTypes).containsExactly((Object[])new String[]{"ITEM_SINGLE"});
        Assertions.assertThat((Map)node2.attributes).containsOnlyKeys((Object[])new String[]{"item"});
        ANode item2 = (ANode)node2.attributes.get("item");
        Assertions.assertThat((Collection)item2.candidateTypes).containsExactly((Object[])new String[]{"ELEMENT"});
        Assertions.assertThat((Map)item2.attributes).containsOnlyKeys((Object[])new String[]{"value"});
        ANode elementValue2 = (ANode)item2.attributes.get("value");
        Assertions.assertThat((Collection)elementValue2.candidateTypes).containsExactly((Object[])new String[]{"DV_SCALE", "DV_ORDINAL"});
    }

    private static List<AndOperatorPredicate> archetypeNodeIdCondition(String archetypeNodeId) {
        if (archetypeNodeId == null) {
            return null;
        }
        return new ArrayList<AndOperatorPredicate>(List.of(new AndOperatorPredicate(List.of(new ComparisonOperatorPredicate(AqlObjectPathUtil.ARCHETYPE_NODE_ID, ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, (PathPredicateOperand)new StringPrimitive(archetypeNodeId))))));
    }

    @Test
    void createAttributeInfos() {
        ANode rootNode = PathAnalysis.analyzeAqlPathTypes((String)"ITEM_STRUCTURE", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"item/value/value"), (Set)PathAnalysis.getCandidateTypes((PathPredicateOperand)new LongPrimitive(Long.valueOf(10L))));
        Map attributeInfos = PathAnalysis.createAttributeInfos((ANode)rootNode);
        Assertions.assertThat((Map)attributeInfos).hasSize(3);
        Assertions.assertThat(attributeInfos.values()).map(Map::size).allMatch(i -> i == 1);
        rootNode = PathAnalysis.analyzeAqlPathTypes((String)"ITEM_STRUCTURE", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"item[value/value>3]/value[value < 100]/value"), (Set)PathAnalysis.getCandidateTypes((PathPredicateOperand)new LongPrimitive(Long.valueOf(10L))));
        attributeInfos = PathAnalysis.createAttributeInfos((ANode)rootNode);
        Assertions.assertThat((Map)attributeInfos).hasSize(3);
        Assertions.assertThat(attributeInfos.values()).map(Map::size).allMatch(i -> i == 1);
        rootNode = PathAnalysis.analyzeAqlPathTypes((String)"ITEM_STRUCTURE", null, null, (AqlObjectPath)AqlObjectPath.parse((String)"item[name/value='My Item']/value[value < 100]/value"), (Set)PathAnalysis.getCandidateTypes((PathPredicateOperand)new LongPrimitive(Long.valueOf(10L))));
        attributeInfos = PathAnalysis.createAttributeInfos((ANode)rootNode);
        Assertions.assertThat((Map)attributeInfos).hasSize(4);
        Assertions.assertThat(attributeInfos.values()).flatExtracting(Map::values).hasSize(5);
    }

    @Test
    void testRmAttributeAlias() {
        List<String> synthetic = List.of("_magnitude", "_type", "_index");
        List rmAttributes = RmAttributeAlias.VALUES.stream().map(RmAttributeAlias::attribute).filter(s -> !synthetic.contains(s)).collect(Collectors.toList());
        rmAttributes.addAll(List.of("timeCreated", "ehrId", "ehrStatus", "compositions"));
        Assertions.assertThat(PathAnalysis.AttributeInfos.attributeInfos.keySet()).containsAll(rmAttributes);
        Assertions.assertThat(rmAttributes).containsAll(PathAnalysis.AttributeInfos.attributeInfos.keySet());
    }
}

