/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.pathanalysis;

import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathCohesionAnalysis;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.util.TreeNode;
import org.ehrbase.openehr.util.TreeUtils;
import org.junit.jupiter.api.Test;

class PathCohesionAnalysisTest {
    PathCohesionAnalysisTest() {
    }

    @Test
    void simplePath() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT c/uid/value FROM COMPOSITION c"));
        Assertions.assertThat(map).containsOnlyKeys((Object[])new String[]{"c"});
        PathCohesionAnalysis.PathCohesionTreeNode n = map.get("c");
        PathCohesionAnalysisTest.assertTreeMatches(n, "COMPOSITION\n  uid\n    value");
    }

    @Test
    void multiContains() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT c/uid/value, ev/name/value\nFROM EHR e contains COMPOSITION c CONTAINS ( (OBSERVATION o CONTAINS CLUSTER cl) OR EVALUATION ev )\nWHERE cl/name/value = 'Values'\nORDER BY ev/name/value\n"));
        Assertions.assertThat(map).containsOnlyKeys((Object[])new String[]{"c", "ev", "cl"});
        PathCohesionAnalysis.PathCohesionTreeNode n = (PathCohesionAnalysis.PathCohesionTreeNode)map.values().stream().iterator().next();
        PathCohesionAnalysisTest.assertTreeMatches(map.get("c"), "COMPOSITION\n  uid\n    value");
        PathCohesionAnalysisTest.assertTreeMatches(map.get("ev"), "EVALUATION\n  name\n    value");
        PathCohesionAnalysisTest.assertTreeMatches(map.get("cl"), "CLUSTER\n  name\n    value");
    }

    @Test
    void simpleWithPredicates() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("\nSELECT\nc/content[at0001]/data/events[at0002, 'Irrelevant']/items[name/value='All Items']/items[openEHR-EHR-CLUSTER.myCluster.v1]/items[openEHR-EHR-ELEMENT.myElement.v1, 'Data']/value\nFROM COMPOSITION c"));
        Assertions.assertThat(map).containsOnlyKeys((Object[])new String[]{"c"});
        PathCohesionAnalysis.PathCohesionTreeNode n = map.get("c");
        PathCohesionAnalysisTest.assertTreeMatches(n, "COMPOSITION\n  content[at0001]\n    data\n      events[at0002]\n        items[name/value='All Items']\n          items[openEHR-EHR-CLUSTER.myCluster.v1]\n            items[openEHR-EHR-ELEMENT.myElement.v1, 'Data']\n              value");
    }

    @Test
    void containsPredicate() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT c/uid FROM COMPOSITION c[openEHR-EHR-CLUSTER.myComp.v1]"));
        Assertions.assertThat(map).containsOnlyKeys((Object[])new String[]{"c"});
        PathCohesionAnalysis.PathCohesionTreeNode n = map.get("c");
        PathCohesionAnalysisTest.assertTreeMatches(n, "COMPOSITION[openEHR-EHR-CLUSTER.myComp.v1]\n  uid");
    }

    @Test
    void ignoreRootPredicate() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT c[openEHR-EHR-CLUSTER.myComp.v1]/uid FROM COMPOSITION c"));
        Assertions.assertThat(map).containsOnlyKeys((Object[])new String[]{"c"});
        PathCohesionAnalysis.PathCohesionTreeNode n = map.get("c");
        PathCohesionAnalysisTest.assertTreeMatches(n, "COMPOSITION\n  uid");
    }

    @Test
    void notMergingRootPredicate() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT c[name/value='My Comp']/uid FROM COMPOSITION c[openEHR-EHR-CLUSTER.myComp.v1]"));
        Assertions.assertThat(map).containsOnlyKeys((Object[])new String[]{"c"});
        PathCohesionAnalysis.PathCohesionTreeNode n = map.get("c");
        PathCohesionAnalysisTest.assertTreeMatches(n, "COMPOSITION[openEHR-EHR-CLUSTER.myComp.v1]\n  uid");
    }

    @Test
    void simpleAttributes() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT\n  t/items[at0004]/name/value AS SystolicName,\n  t/items[at0004]/value/magnitude AS SystolicValue\nFROM OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]\nCONTAINS ITEM_TREE t"));
        PathCohesionAnalysisTest.assertTreeMatches(map.get("t"), "ITEM_TREE\n  items[at0004]\n    name\n      value\n    value\n      magnitude");
    }

    @Test
    void simpleNodeAttributes() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT\n  t/items[at0004]/name/value AS SystolicName,\n  t/items[at0004]/value/magnitude AS SystolicValue,\n  t/items[at0004]/value/units AS SystolicUnit,\n  t/items[at0005]/name/value AS DiastolicName,\n  t/items[at0005]/value/magnitude AS DiastolicValue\nFROM OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]\nCONTAINS ITEM_TREE t"));
        PathCohesionAnalysisTest.assertTreeMatches(map.get("t"), "ITEM_TREE\n  items[at0004]\n    name\n      value\n    value\n      magnitude\n      units\n  items[at0005]\n    name\n      value\n    value\n      magnitude");
    }

    @Test
    void baseAttributes() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT\n  t/items/name/value AS Name,\n  t/items/value/magnitude AS Value,\n  t/items[at0005]/name/value AS DiastolicName,\n  t/items[at0005]/value/magnitude AS DiastolicValue,\n  t/items[at0005]/value/units AS DiastolicUnit\nFROM OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]\nCONTAINS ITEM_TREE t"));
        PathCohesionAnalysisTest.assertTreeMatches(map.get("t"), "ITEM_TREE\n  items\n    name\n      value\n    value\n      magnitude\n      units");
    }

    @Test
    void archetypeAttributes() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT\n  t/items[openEHR-EHR-ELEMENT.blood_pressure.v2]/name/value AS Name,\n  t/items[openEHR-EHR-ELEMENT.blood_pressure.v2, 'Systolic']/value/magnitude AS SystolicValue,\n  t/items[at0005, 'Diastolic']/name/value AS DiastolicName,\n  t/items[at0005]/value/magnitude AS DiastolicValue,\n  t/items[at0005]/value/units AS DiastolicUnit\nFROM OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]\nCONTAINS ITEM_TREE t"));
        PathCohesionAnalysisTest.assertTreeMatches(map.get("t"), "ITEM_TREE\n  items[at0005]\n    name\n      value\n    value\n      magnitude\n      units\n  items[openEHR-EHR-ELEMENT.blood_pressure.v2]\n    name\n      value\n    value\n      magnitude");
    }

    @Test
    void nameAttributes() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT\n  t/items[name/value='Systolic']/name/value AS Name,\n  t/items[name/value='Systolic']/value/magnitude AS SystolicValue,\n  t/items[name/value='Diastolic']/name/value AS DiastolicName,\n  t/items[name/value='Diastolic']/value/magnitude AS DiastolicValue,\n  t/items[name/value='Diastolic']/value/units AS DiastolicUnit\nFROM OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]\nCONTAINS ITEM_TREE t"));
        PathCohesionAnalysisTest.assertTreeMatches(map.get("t"), "ITEM_TREE\n  items[name/value='Diastolic']\n    name\n      value\n    value\n      magnitude\n      units\n  items[name/value='Systolic']\n    name\n      value\n    value\n      magnitude");
    }

    @Test
    void mixedAttributes() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT\n  t/items[openEHR-EHR-ELEMENT.blood_pressure.v2]/name/value AS Name,\n  t/items[openEHR-EHR-ELEMENT.blood_pressure.v2, 'Systolic']/value/magnitude AS SystolicValue,\n  t/items[name/value='Diastolic']/name/value AS DiastolicName,\n  t/items[at0005]/value/magnitude AS DiastolicValue,\n  t/items[at0005]/value/units AS DiastolicUnit\nFROM OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]\nCONTAINS ITEM_TREE t"));
        PathCohesionAnalysisTest.assertTreeMatches(map.get("t"), "ITEM_TREE\n  items\n    name\n      value\n    value\n      magnitude\n      units");
    }

    @Test
    void irrelevantPredicates() {
        Map<String, PathCohesionAnalysis.PathCohesionTreeNode> map = PathCohesionAnalysisTest.byIdentifier(PathCohesionAnalysisTest.analyzePathCohesion("SELECT\n  t/items[archetype_node_id=at0004 and value/magnitude > 3 and name/value='Systolic']/name/value AS SystolicName,\n  t/items[at0004]/value/magnitude AS SystolicValue\nFROM OBSERVATION[openEHR-EHR-OBSERVATION.sample_blood_pressure.v1]\nCONTAINS ITEM_TREE t"));
        PathCohesionAnalysisTest.assertTreeMatches(map.get("t"), "ITEM_TREE\n  items[at0004]\n    name\n      value\n    value\n      magnitude");
    }

    private static Map<AbstractContainmentExpression, PathCohesionAnalysis.PathCohesionTreeNode> analyzePathCohesion(String aqlStr) {
        return PathCohesionAnalysis.analyzePathCohesion((AqlQuery)AqlQuery.parse((String)aqlStr));
    }

    private static Map<String, PathCohesionAnalysis.PathCohesionTreeNode> byIdentifier(Map<AbstractContainmentExpression, PathCohesionAnalysis.PathCohesionTreeNode> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> ((AbstractContainmentExpression)e.getKey()).getIdentifier(), Map.Entry::getValue));
    }

    private static String renderTree(PathCohesionAnalysis.PathCohesionTreeNode node) {
        return TreeUtils.renderTree((TreeNode)node, Comparator.comparing(n -> new AqlObjectPath(new AqlObjectPath.PathNode[]{n.getAttribute()}).render()), n -> new AqlObjectPath(new AqlObjectPath.PathNode[]{n.getAttribute()}).render());
    }

    private static AbstractStringAssert<?> assertTreeMatches(PathCohesionAnalysis.PathCohesionTreeNode root, String expected) {
        return Assertions.assertThat((String)PathCohesionAnalysisTest.renderTree(root)).isEqualTo(expected);
    }
}

