/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.ehrbase.jooq.pg.tables.CompData;
import org.ehrbase.jooq.pg.tables.CompVersion;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.sql.ConditionUtils;
import org.jooq.Condition;
import org.jooq.Table;
import org.jooq.impl.QOM;
import org.junit.jupiter.api.Test;

class ConditionUtilsTest {
    ConditionUtilsTest() {
    }

    @Test
    void testComplexExtractedColumnConditionVoIdIn() {
        AslStructureQuery q = new AslStructureQuery("asq", AslStructureQuery.AslSourceRelation.COMPOSITION, List.of(AslStructureColumn.VO_ID.field(), AslStructureColumn.RM_ENTITY.field(), AslStructureColumn.SYS_VERSION.field()), List.of("CO"), List.of(), null, true);
        AslField.FieldSource fieldSource = new AslField.FieldSource((AslQuery)q, (AslQuery)q, (AslQuery)q);
        AslComplexExtractedColumnField field = new AslComplexExtractedColumnField(AslExtractedColumn.VO_ID, fieldSource);
        AslFieldValueQueryCondition fvId = new AslFieldValueQueryCondition((AslField)field, AslQueryCondition.AslConditionOperator.IN, List.of("a", "c"));
        AslFieldValueQueryCondition fvVersion = new AslFieldValueQueryCondition((AslField)field, AslQueryCondition.AslConditionOperator.IN, List.of("b::local.ehrbase.org::142", "d::::2"));
        AslFieldValueQueryCondition fvMixed = new AslFieldValueQueryCondition((AslField)field, AslQueryCondition.AslConditionOperator.IN, List.of("a", "b::local.ehrbase.org::142", "c", "d::::2"));
        AslComplexExtractedColumnField ecf = new AslComplexExtractedColumnField(field.getExtractedColumn(), fieldSource);
        Condition conditionId = ConditionUtils.complexExtractedColumnCondition((boolean)false, (AslFieldValueQueryCondition)fvId, (AslComplexExtractedColumnField)ecf, (Table)CompData.COMP_DATA, (Table)CompVersion.COMP_VERSION);
        Condition conditionVersion = ConditionUtils.complexExtractedColumnCondition((boolean)false, (AslFieldValueQueryCondition)fvVersion, (AslComplexExtractedColumnField)ecf, (Table)CompData.COMP_DATA, (Table)CompVersion.COMP_VERSION);
        Condition conditionMixed = ConditionUtils.complexExtractedColumnCondition((boolean)false, (AslFieldValueQueryCondition)fvMixed, (AslComplexExtractedColumnField)ecf, (Table)CompData.COMP_DATA, (Table)CompVersion.COMP_VERSION);
        Assertions.assertThat((Object)conditionMixed).isInstanceOf(QOM.Or.class);
        Assertions.assertThat((Object)conditionId).isInstanceOf(QOM.InList.class);
        Assertions.assertThat((Object)conditionVersion).isInstanceOf(QOM.InList.class);
        Assertions.assertThat((String)conditionId.toString()).doesNotContain(new CharSequence[]{"row"});
        Assertions.assertThat((String)conditionVersion.toString()).contains(new CharSequence[]{"row", "142"});
        Assertions.assertThat((String)conditionMixed.toString()).isEqualToIgnoringWhitespace((CharSequence)"(%s or %s)".formatted(conditionId, conditionVersion));
    }

    @Test
    void escapeAsJsonString() {
        Assertions.assertThat((String)ConditionUtils.escapeAsJsonString(null)).isNull();
        Assertions.assertThat((String)ConditionUtils.escapeAsJsonString((String)" Test ")).isEqualTo("\" Test \"");
        Assertions.assertThat((String)ConditionUtils.escapeAsJsonString((String)"")).isEqualTo("\"\"");
        Assertions.assertThat((String)ConditionUtils.escapeAsJsonString((String)"\"Test\"")).isEqualTo("\"\\\"Test\\\"\"");
        Assertions.assertThat((String)ConditionUtils.escapeAsJsonString((String)"\"Test\"")).isEqualTo("\"\\\"Test\\\"\"");
        Assertions.assertThat((String)ConditionUtils.escapeAsJsonString((String)"C:\\temp\\")).isEqualTo("\"C:\\\\temp\\\\\"");
        Assertions.assertThat((String)ConditionUtils.escapeAsJsonString((String)"Cluck Ol' Hen")).isEqualTo("\"Cluck Ol' Hen\"");
    }
}

