/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.ehrbase.api.knowledge.KnowledgeCacheService;
import org.ehrbase.openehr.aqlengine.asl.AqlSqlLayer;
import org.ehrbase.openehr.aqlengine.asl.AslGraph;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class AqlSqlLayerTest {
    private final KnowledgeCacheService mockKnowledgeCacheService = (KnowledgeCacheService)Mockito.mock((Object[])new KnowledgeCacheService[0]);

    @BeforeEach
    void setUp() {
        Mockito.reset((Object[])new KnowledgeCacheService[]{this.mockKnowledgeCacheService});
        Mockito.when((Object)this.mockKnowledgeCacheService.findUuidByTemplateId(ArgumentMatchers.anyString())).thenReturn(Optional.of(UUID.randomUUID()));
    }

    @Disabled
    @Test
    void printAslGraph() {
        AslRootQuery aslQuery = this.buildSqlQuery("SELECT\nc/feeder_audit,\nc/uid/value,\nc/context/other_context[at0004]/items[at0014]/value\nFROM EHR e CONTAINS COMPOSITION c\nWHERE e/ehr_id/value = 'e6fad8ba-fb4f-46a2-bf82-66edb43f142f'\n");
        System.out.println(AslGraph.createAslGraph(aslQuery));
    }

    @Test
    void testDataQueryPlacedLast() {
        AslRootQuery aslQuery = this.buildSqlQuery("    SELECT\n    c/content,\n    c/content[at0001],\n    c[openEHR-EHR-COMPOSITION.test.v0]/content[at0002],\n    c/uid/value,\n    c/context/other_context[at0004]/items[at0014]/value\n    FROM EHR e CONTAINS COMPOSITION c\n    WHERE e/ehr_id/value = 'e6fad8ba-fb4f-46a2-bf82-66edb43f142f'\n");
        List<AslQuery> queries = aslQuery.getChildren().stream().map(Pair::getLeft).toList();
        Assertions.assertThat(queries).hasSize(4);
        Assertions.assertThat((Object)queries.get(0)).isInstanceOf(AslStructureQuery.class);
        Assertions.assertThat((Object)queries.get(1)).isInstanceOf(AslStructureQuery.class);
        Assertions.assertThat((Object)queries.get(2)).isInstanceOf(AslEncapsulatingQuery.class);
        Assertions.assertThat((Object)queries.get(3)).isInstanceOf(AslEncapsulatingQuery.class);
        AslField contentField1 = (AslField)aslQuery.getSelect().get(0);
        AslField contentField2 = (AslField)aslQuery.getSelect().get(1);
        AslField contentField3 = (AslField)aslQuery.getSelect().get(2);
        Assertions.assertThat((Object)contentField1).isInstanceOf(AslSubqueryField.class);
        Assertions.assertThat((List)((AslSubqueryField)contentField1).getFilterConditions()).isEmpty();
        Assertions.assertThat((Object)contentField2).isInstanceOf(AslSubqueryField.class);
        Assertions.assertThat((List)((AslSubqueryField)contentField2).getFilterConditions()).hasSize(1);
        Assertions.assertThat((Object)contentField3).isInstanceOf(AslSubqueryField.class);
        Assertions.assertThat((List)((AslSubqueryField)contentField3).getFilterConditions()).hasSize(2);
        Assertions.assertThat((Object)((AslField)aslQuery.getSelect().getLast())).isInstanceOf(AslRmPathField.class);
    }

    @Test
    void clusterDataSingleSelection() {
        AslRootQuery aslQuery = this.buildSqlQuery("SELECT\n    cluster/items[at0001]/value/data\nFROM COMPOSITION CONTAINS CLUSTER cluster[openEHR-EHR-CLUSTER.media_file.v1]\n");
        List<AslQuery> queries = aslQuery.getChildren().stream().map(Pair::getLeft).toList();
        Assertions.assertThat(queries).hasSize(3);
        Assertions.assertThat((Object)queries.get(0)).isInstanceOf(AslStructureQuery.class);
        Assertions.assertThat((Object)queries.get(1)).isInstanceOf(AslStructureQuery.class);
        Assertions.assertThat((Object)queries.get(2)).isInstanceOf(AslEncapsulatingQuery.class);
        Assertions.assertThat((Object)((AslField)aslQuery.getSelect().getFirst())).isInstanceOf(AslRmPathField.class);
    }

    private AslRootQuery buildSqlQuery(String query) {
        AqlQuery aqlQuery = AqlQueryParser.parse((String)query);
        AqlQueryWrapper queryWrapper = AqlQueryWrapper.create((AqlQuery)aqlQuery);
        AqlSqlLayer aqlSqlLayer = new AqlSqlLayer(this.mockKnowledgeCacheService, () -> "node");
        return aqlSqlLayer.buildAslRootQuery(queryWrapper);
    }
}

