/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.openehr.aqlengine.AqlQueryParsingPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.ExistsCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LikeCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LogicalOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.MatchesCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.NotCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.WhereCondition;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentNotOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentVersionExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.BooleanPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.ColumnExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.ComparisonLeftOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.DoublePrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.LikeOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.LongPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.MatchesOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Operand;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.QueryParameter;
import org.ehrbase.openehr.sdk.aql.dto.operand.SingleRowFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.TemporalPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.TerminologyFunction;
import org.ehrbase.openehr.sdk.aql.dto.orderby.OrderByExpression;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectClause;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectExpression;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.springframework.stereotype.Component;

@Component
public class AqlParameterPostProcessor
implements AqlQueryParsingPostProcessor {
    @Override
    public void afterParseAql(AqlQuery aqlQuery, AqlQueryRequest request, AqlQueryContext ctx) {
        AqlParameterPostProcessor.replaceParameters(aqlQuery, request.parameters());
    }

    public int getOrder() {
        return -2000;
    }

    public static void replaceParameters(AqlQuery aqlQuery, Map<String, Object> parameterMap) {
        if (MapUtils.isNotEmpty(parameterMap)) {
            SelectParams.replaceParameters(aqlQuery.getSelect(), parameterMap);
            ContainmentParams.replaceParameters(aqlQuery.getFrom(), parameterMap);
            WhereParams.replaceParameters(aqlQuery.getWhere(), parameterMap);
            OrderByParams.replaceParameters(parameterMap, aqlQuery.getOrderBy());
        }
    }

    public static void replaceIdentifiedPathParameters(IdentifiedPath identifiedPath, Map<String, Object> parameterMap) {
        Optional.of(identifiedPath).map(IdentifiedPath::getRootPredicate).stream().flatMap(Collection::stream).map(AndOperatorPredicate::getOperands).flatMap(Collection::stream).forEach(co -> ObjectPathParams.replaceComparisonOperatorParameters(co, parameterMap));
        ObjectPathParams.replaceParameters(identifiedPath.getPath(), parameterMap).ifPresent(arg_0 -> ((IdentifiedPath)identifiedPath).setPath(arg_0));
    }

    private static Stream<Primitive> replaceOperandParameters(Operand operand, Map<String, Object> parameterMap) {
        Operand operand2 = operand;
        Objects.requireNonNull(operand2);
        Operand operand3 = operand2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{QueryParameter.class, IdentifiedPath.class, SingleRowFunction.class, TerminologyFunction.class, Primitive.class}, (Object)operand3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                QueryParameter qp = (QueryParameter)operand3;
                yield AqlParameterPostProcessor.resolveParameters(qp, parameterMap);
            }
            case 1 -> {
                IdentifiedPath path = (IdentifiedPath)operand3;
                AqlParameterPostProcessor.replaceIdentifiedPathParameters(path, parameterMap);
                yield null;
            }
            case 2 -> {
                SingleRowFunction func = (SingleRowFunction)operand3;
                AqlParameterPostProcessor.replaceFunctionParameters(func, parameterMap);
                yield null;
            }
            case 3 -> {
                TerminologyFunction __ = (TerminologyFunction)operand3;
                yield null;
            }
            case 4 -> {
                Primitive __ = (Primitive)operand3;
                yield null;
            }
        };
    }

    private static void replaceFunctionParameters(SingleRowFunction func, Map<String, Object> parameterMap) {
        Utils.reviseList(func.getOperandList(), o -> AqlParameterPostProcessor.replaceOperandParameters(o, parameterMap));
    }

    private static Stream<Primitive> resolveParameters(QueryParameter param, Map<String, Object> parameterMap) {
        Object paramValue;
        String paramName = param.getName();
        Object object = paramValue = parameterMap.get(paramName);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Collection.class}, (Object)object, n)) {
            case 0 -> {
                Collection c = (Collection)object;
                yield c.stream().map(e -> AqlParameterPostProcessor.toPrimitive(param.getName(), e));
            }
            case -1 -> throw new AqlParseException("Missing parameter '%s'".formatted(paramName));
            default -> Stream.of(AqlParameterPostProcessor.toPrimitive(param.getName(), paramValue));
        };
    }

    private static Primitive toPrimitive(String name, Object paramValue) {
        Object object = paramValue;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Number.class, String.class, Boolean.class}, (Object)object, n)) {
            case -1 -> throw new AqlParseException("Missing parameter '%s'".formatted(name));
            case 0 -> {
                Integer i = (Integer)object;
                yield new LongPrimitive(Long.valueOf(i.longValue()));
            }
            case 1 -> {
                Long i = (Long)object;
                yield new LongPrimitive(i);
            }
            case 2 -> {
                Number nr = (Number)object;
                yield new DoublePrimitive(Double.valueOf(nr.doubleValue()));
            }
            case 3 -> {
                String str = (String)object;
                yield Utils.stringToPrimitive(str);
            }
            case 4 -> {
                Boolean b = (Boolean)object;
                yield new BooleanPrimitive(b);
            }
            default -> throw new IllegalArgumentException("Type of parameter '%s' is not supported".formatted(name));
        };
    }

    private static <T> T ensureSingleElement(Stream<T> singleElementStream, Consumer<T> elementConsumer) {
        if (singleElementStream == null) {
            return null;
        }
        Iterator it = singleElementStream.iterator();
        if (it.hasNext()) {
            Object first = it.next();
            if (it.hasNext()) {
                throw new AqlParseException("One of the parameters does not support multiple values");
            }
            elementConsumer.accept(first);
            return first;
        }
        throw new AqlParseException("Empty parameter replacement results");
    }

    private static final class SelectParams {
        private SelectParams() {
        }

        public static void replaceParameters(SelectClause selectClause, Map<String, Object> parameterMap) {
            selectClause.getStatement().stream().map(SelectExpression::getColumnExpression).forEach(ce -> {
                ColumnExpression columnExpression = ce;
                Objects.requireNonNull(columnExpression);
                ColumnExpression selector0$temp = columnExpression;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleRowFunction.class, AggregateFunction.class, IdentifiedPath.class, Primitive.class, TerminologyFunction.class}, (Object)selector0$temp, index$1)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        SingleRowFunction func = (SingleRowFunction)selector0$temp;
                        AqlParameterPostProcessor.replaceFunctionParameters(func, parameterMap);
                        break;
                    }
                    case 1: {
                        AggregateFunction aFunc = (AggregateFunction)selector0$temp;
                        AqlParameterPostProcessor.replaceIdentifiedPathParameters(aFunc.getIdentifiedPath(), parameterMap);
                        break;
                    }
                    case 2: {
                        IdentifiedPath identifiedPath = (IdentifiedPath)selector0$temp;
                        AqlParameterPostProcessor.replaceIdentifiedPathParameters(identifiedPath, parameterMap);
                        break;
                    }
                    case 3: {
                        Primitive __ = (Primitive)selector0$temp;
                        break;
                    }
                    case 4: {
                        TerminologyFunction terminologyFunction = (TerminologyFunction)selector0$temp;
                    }
                }
            });
        }
    }

    private static final class ContainmentParams {
        private ContainmentParams() {
        }

        public static void replaceParameters(Containment containment, Map<String, Object> parameterMap) {
            Containment containment2 = containment;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContainmentSetOperator.class, ContainmentNotOperator.class, ContainmentClassExpression.class, ContainmentVersionExpression.class}, (Object)containment2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case -1: {
                    break;
                }
                case 0: {
                    ContainmentSetOperator cso = (ContainmentSetOperator)containment2;
                    cso.getValues().forEach(c -> ContainmentParams.replaceParameters(c, parameterMap));
                    break;
                }
                case 1: {
                    ContainmentNotOperator cno = (ContainmentNotOperator)containment2;
                    ContainmentParams.replaceParameters(cno.getContainmentExpression(), parameterMap);
                    break;
                }
                case 2: {
                    ContainmentClassExpression cce = (ContainmentClassExpression)containment2;
                    ContainmentParams.replaceContainmentClassExpressionParameters(cce, parameterMap);
                    break;
                }
                case 3: {
                    ContainmentVersionExpression cve = (ContainmentVersionExpression)containment2;
                    ContainmentParams.replaceContainmentVersionExpressionParameters(cve, parameterMap);
                }
            }
        }

        private static void replaceContainmentClassExpressionParameters(ContainmentClassExpression cce, Map<String, Object> parameterMap) {
            ContainmentParams.streamComparisonOperatorPredicates(cce).forEach(op -> ObjectPathParams.replaceComparisonOperatorParameters(op, parameterMap));
            ContainmentParams.replaceParameters(cce.getContains(), parameterMap);
        }

        private static void replaceContainmentVersionExpressionParameters(ContainmentVersionExpression cve, Map<String, Object> parameterMap) {
            Optional.of(cve).map(ContainmentVersionExpression::getPredicate).ifPresent(op -> ObjectPathParams.replaceComparisonOperatorParameters(op, parameterMap));
            ContainmentParams.replaceParameters(cve.getContains(), parameterMap);
        }

        private static Stream<ComparisonOperatorPredicate> streamComparisonOperatorPredicates(ContainmentClassExpression cce) {
            return Optional.of(cce).filter(AbstractContainmentExpression::hasPredicates).map(AbstractContainmentExpression::getPredicates).stream().flatMap(Collection::stream).map(AndOperatorPredicate::getOperands).flatMap(Collection::stream);
        }
    }

    private static final class WhereParams {
        private WhereParams() {
        }

        public static void replaceParameters(WhereCondition condition, Map<String, Object> parameterMap) {
            WhereCondition whereCondition = condition;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComparisonOperatorCondition.class, NotCondition.class, MatchesCondition.class, LikeCondition.class, LogicalOperatorCondition.class, ExistsCondition.class}, (Object)whereCondition, n)) {
                case -1: {
                    break;
                }
                case 0: {
                    ComparisonOperatorCondition c = (ComparisonOperatorCondition)whereCondition;
                    WhereParams.replaceComparisonLeftOperandParameters(c.getStatement(), parameterMap);
                    AqlParameterPostProcessor.ensureSingleElement(AqlParameterPostProcessor.replaceOperandParameters(c.getValue(), parameterMap), arg_0 -> ((ComparisonOperatorCondition)c).setValue(arg_0));
                    break;
                }
                case 1: {
                    NotCondition c = (NotCondition)whereCondition;
                    WhereParams.replaceParameters(c.getConditionDto(), parameterMap);
                    break;
                }
                case 2: {
                    MatchesCondition c = (MatchesCondition)whereCondition;
                    Utils.reviseList(c.getValues(), o -> WhereParams.replaceMatchesParameters(o, parameterMap));
                    break;
                }
                case 3: {
                    LikeCondition c = (LikeCondition)whereCondition;
                    WhereParams.replaceLikeOperandParameters(c.getValue(), parameterMap).ifPresent(arg_0 -> ((LikeCondition)c).setValue(arg_0));
                    break;
                }
                case 4: {
                    LogicalOperatorCondition c = (LogicalOperatorCondition)whereCondition;
                    c.getValues().forEach(v -> WhereParams.replaceParameters(v, parameterMap));
                    break;
                }
                case 5: {
                    ExistsCondition __ = (ExistsCondition)whereCondition;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(condition));
                }
            }
        }

        private static Optional<LikeOperand> replaceLikeOperandParameters(LikeOperand value, Map<String, Object> parameterMap) {
            if (value instanceof QueryParameter) {
                QueryParameter qp = (QueryParameter)value;
                return Optional.of(qp.getName()).map(parameterMap::get).map(Object::toString).map(Utils::stringToPrimitive).or(() -> Optional.of(new StringPrimitive(null)));
            }
            return Optional.empty();
        }

        private static Stream<Primitive> replaceMatchesParameters(MatchesOperand operand, Map<String, Object> parameterMap) {
            if (operand instanceof QueryParameter) {
                QueryParameter qp = (QueryParameter)operand;
                return AqlParameterPostProcessor.resolveParameters(qp, parameterMap);
            }
            return null;
        }

        private static void replaceComparisonLeftOperandParameters(ComparisonLeftOperand statement, Map<String, Object> parameterMap) {
            ComparisonLeftOperand comparisonLeftOperand = statement;
            Objects.requireNonNull(comparisonLeftOperand);
            ComparisonLeftOperand comparisonLeftOperand2 = comparisonLeftOperand;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleRowFunction.class, IdentifiedPath.class, TerminologyFunction.class}, (Object)comparisonLeftOperand2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    SingleRowFunction func = (SingleRowFunction)comparisonLeftOperand2;
                    AqlParameterPostProcessor.replaceFunctionParameters(func, parameterMap);
                    break;
                }
                case 1: {
                    IdentifiedPath path = (IdentifiedPath)comparisonLeftOperand2;
                    AqlParameterPostProcessor.replaceIdentifiedPathParameters(path, parameterMap);
                    break;
                }
                case 2: {
                    TerminologyFunction terminologyFunction = (TerminologyFunction)comparisonLeftOperand2;
                }
            }
        }
    }

    private static final class OrderByParams {
        private OrderByParams() {
        }

        public static void replaceParameters(Map<String, Object> parameterMap, List<OrderByExpression> orderBy) {
            if (orderBy != null) {
                orderBy.stream().map(OrderByExpression::getStatement).forEach(path -> AqlParameterPostProcessor.replaceIdentifiedPathParameters(path, parameterMap));
            }
        }
    }

    private static final class ObjectPathParams {
        private ObjectPathParams() {
        }

        public static Optional<AqlObjectPath> replaceParameters(AqlObjectPath path, Map<String, Object> parameterMap) {
            if (path == null) {
                return Optional.empty();
            }
            return Utils.replaceChildParameters(path.getPathNodes(), ObjectPathParams::replacePathNodeParameters, parameterMap).map(AqlObjectPath::new);
        }

        private static Optional<ComparisonOperatorPredicate> replaceComparisonOperatorPredicateParameters(ComparisonOperatorPredicate n, Map<String, Object> parameterMap) {
            Optional<AqlObjectPath> replacedPath = ObjectPathParams.replaceParameters(n.getPath(), parameterMap);
            PathPredicateOperand pathPredicateOperand = n.getValue();
            Objects.requireNonNull(pathPredicateOperand);
            PathPredicateOperand pathPredicateOperand2 = pathPredicateOperand;
            int n2 = 0;
            Optional<PathPredicateOperand> replacedValue = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{QueryParameter.class, Primitive.class, AqlObjectPath.class}, (Object)pathPredicateOperand2, n2)) {
                case 0 -> {
                    QueryParameter qp = (QueryParameter)pathPredicateOperand2;
                    yield Optional.of((PathPredicateOperand)AqlParameterPostProcessor.ensureSingleElement(AqlParameterPostProcessor.resolveParameters(qp, parameterMap), p -> ObjectPathParams.validateParameterSyntax(n.getPath(), p)));
                }
                case 1 -> {
                    Primitive __ = (Primitive)pathPredicateOperand2;
                    yield Optional.empty();
                }
                case 2 -> {
                    AqlObjectPath p = (AqlObjectPath)pathPredicateOperand2;
                    yield ObjectPathParams.replaceParameters(p, parameterMap).map(PathPredicateOperand.class::cast);
                }
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(n.getValue()));
            };
            if (replacedPath.isEmpty() && replacedValue.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new ComparisonOperatorPredicate(replacedPath.orElse(n.getPath()), n.getOperator(), replacedValue.orElse(n.getValue())));
        }

        private static void validateParameterSyntax(AqlObjectPath path, Primitive p) {
            if (AqlObjectPathUtil.ARCHETYPE_NODE_ID.equals((Object)path)) {
                if (p instanceof StringPrimitive) {
                    StringPrimitive sp = (StringPrimitive)p;
                    try {
                        AslRmTypeAndConcept.fromArchetypeNodeId((String)((Object)sp.getValue()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new AqlParseException("Invalid parameter for %s".formatted(AqlObjectPathUtil.ARCHETYPE_NODE_ID));
                    }
                } else {
                    throw new AqlParseException("Invalid parameter type for %s".formatted(AqlObjectPathUtil.ARCHETYPE_NODE_ID));
                }
            }
        }

        private static Optional<AndOperatorPredicate> replaceAndOperatorPredicateParameters(AndOperatorPredicate and, Map<String, Object> parameterMap) {
            return Utils.replaceChildParameters(and.getOperands(), ObjectPathParams::replaceComparisonOperatorPredicateParameters, parameterMap).map(AndOperatorPredicate::new);
        }

        private static Optional<AqlObjectPath.PathNode> replacePathNodeParameters(AqlObjectPath.PathNode node, Map<String, Object> parameterMap) {
            return Utils.replaceChildParameters(node.getPredicateOrOperands(), ObjectPathParams::replaceAndOperatorPredicateParameters, parameterMap).map(l -> new AqlObjectPath.PathNode(node.getAttribute(), l));
        }

        public static void replaceComparisonOperatorParameters(ComparisonOperatorPredicate op, Map<String, Object> parameterMap) {
            Optional<AqlObjectPath> newPath = ObjectPathParams.replaceParameters(op.getPath(), parameterMap);
            PathPredicateOperand pathPredicateOperand = op.getValue();
            int n = 0;
            Primitive newValue = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{QueryParameter.class, Primitive.class, AqlObjectPath.class}, (Object)pathPredicateOperand, n)) {
                case -1 -> throw new NullPointerException("Missing value for path " + op.getPath().render());
                case 0 -> {
                    QueryParameter qp = (QueryParameter)pathPredicateOperand;
                    yield AqlParameterPostProcessor.ensureSingleElement(AqlParameterPostProcessor.resolveParameters(qp, parameterMap), p -> ObjectPathParams.validateParameterSyntax(op.getPath(), p));
                }
                case 1 -> {
                    Primitive __ = (Primitive)pathPredicateOperand;
                    yield null;
                }
                case 2 -> {
                    AqlObjectPath path = (AqlObjectPath)pathPredicateOperand;
                    yield ObjectPathParams.replaceParameters(path, parameterMap);
                }
                default -> throw new IllegalArgumentException("Unexpected type of value: " + op.getValue().getClass().getSimpleName());
            };
            newPath.ifPresent(arg_0 -> ((ComparisonOperatorPredicate)op).setPath(arg_0));
            if (newValue != null) {
                op.setValue((PathPredicateOperand)newValue);
            }
        }
    }

    static final class Utils {
        Utils() {
        }

        public static StringPrimitive stringToPrimitive(String str) {
            if (TemporalPrimitivePattern.matches(str)) {
                return TemporalPrimitive.fromString((String)str);
            }
            return new StringPrimitive(str);
        }

        public static <T> void reviseList(List<T> list, Function<T, Stream<? extends T>> replacementFunc) {
            if (list.isEmpty()) {
                return;
            }
            ListIterator<T> li = list.listIterator();
            while (li.hasNext()) {
                Stream<Object> replacementsStream = replacementFunc.apply(li.next());
                if (replacementsStream == null) continue;
                li.remove();
                replacementsStream.forEach(li::add);
            }
            if (list.isEmpty()) {
                throw new AqlParseException("Parameter replacement resulted in empty operand list");
            }
        }

        public static <C> Optional<List<C>> replaceChildParameters(List<C> children, BiFunction<C, Map<String, Object>, Optional<C>> childReplacementFunc, Map<String, Object> parameterMap) {
            ModifiedElement[] modifiedElements = (ModifiedElement[])IntStream.range(0, children.size()).mapToObj(i -> ((Optional)childReplacementFunc.apply(children.get(i), parameterMap)).map(m -> new ModifiedElement<Object>(i, m))).flatMap(Optional::stream).toArray(ModifiedElement[]::new);
            if (modifiedElements.length == 0) {
                return Optional.empty();
            }
            Object[] newChildren = children.toArray();
            for (ModifiedElement modifiedNode : modifiedElements) {
                newChildren[modifiedNode.index()] = modifiedNode.node();
            }
            return Optional.of(List.of(newChildren));
        }
    }

    static final class TemporalPrimitivePattern {
        static final Pattern TEMPORAL_PATTERN;

        private TemporalPrimitivePattern() {
        }

        private static String nonCapturing(String ... content) {
            return Arrays.stream(content).collect(Collectors.joining("", "(?:", ")"));
        }

        private static String or(String ... content) {
            return String.join((CharSequence)"|", content);
        }

        private static String optional(String ... content) {
            return TemporalPrimitivePattern.nonCapturing(content) + "?";
        }

        public static boolean matches(String input) {
            return TEMPORAL_PATTERN.matcher(input).matches();
        }

        static {
            String MINUTE;
            String DIGIT = "[0-9]";
            String YEAR = DIGIT + DIGIT + DIGIT + DIGIT;
            String MONTH = TemporalPrimitivePattern.nonCapturing(TemporalPrimitivePattern.or("[0][1-9]", "[1][0-2]"));
            String DAY = TemporalPrimitivePattern.nonCapturing(TemporalPrimitivePattern.or("[0][1-9]", "[12][0-9]", "[3][0-1]"));
            String HOUR = TemporalPrimitivePattern.nonCapturing(TemporalPrimitivePattern.or("[01][0-9]", "[2][0-3]"));
            String SECOND = MINUTE = "[0-5][0-9]";
            String DATE_SHORT = YEAR + MONTH + DAY;
            String DATE_LONG = YEAR + "-" + MONTH + "-" + DAY;
            String TIME_SHORT = HOUR + MINUTE + SECOND;
            String TIME_LONG = HOUR + ":" + MINUTE + ":" + SECOND;
            String FRACTIONAL_SECONDS = "\\." + TemporalPrimitivePattern.nonCapturing(DIGIT) + "{1,9}";
            String TIMEZONE = TemporalPrimitivePattern.or("Z", TemporalPrimitivePattern.nonCapturing("[-+]", HOUR, TemporalPrimitivePattern.optional("[:]?" + MINUTE)));
            TEMPORAL_PATTERN = Pattern.compile(TemporalPrimitivePattern.or(DATE_LONG + TemporalPrimitivePattern.optional("T", TIME_LONG, TemporalPrimitivePattern.optional(FRACTIONAL_SECONDS), TemporalPrimitivePattern.optional(TIMEZONE)), DATE_SHORT + TemporalPrimitivePattern.optional("T", TIME_SHORT, TemporalPrimitivePattern.optional(FRACTIONAL_SECONDS), TemporalPrimitivePattern.optional(TIMEZONE)), TemporalPrimitivePattern.nonCapturing(TemporalPrimitivePattern.or(TIME_SHORT, TIME_LONG)) + TemporalPrimitivePattern.optional(FRACTIONAL_SECONDS) + TemporalPrimitivePattern.optional(TIMEZONE)));
        }
    }

    private record ModifiedElement<T>(int index, T node) {
    }
}

