/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.pathanalysis;

import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.ehrbase.openehr.aqlengine.pathanalysis.ANode;
import org.ehrbase.openehr.aqlengine.pathanalysis.FoundationType;
import org.ehrbase.openehr.sdk.aql.dto.operand.BooleanPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.DoublePrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.LongPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.TemporalPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;

public class PathAnalysis {
    static final ArchieRMInfoLookup RM_INFOS = ArchieRMInfoLookup.getInstance();

    static void validateAttributeNamesExist(ANode rootNode) {
        Iterator<ANode> nodeIt = PathAnalysis.iterateNodes(rootNode);
        while (nodeIt.hasNext()) {
            ANode node = nodeIt.next();
            node.attributes.keySet().forEach(att -> {
                if (!AttributeInfos.attributeInfos.containsKey(att)) {
                    throw new IllegalArgumentException("Unknown attribute: %s".formatted(att));
                }
            });
        }
    }

    private PathAnalysis() {
    }

    static Stream<String> resolveConcreteTypeNames(String abstractType) {
        RMTypeInfo typeInfo = RM_INFOS.getTypeInfo(abstractType);
        if (typeInfo == null) {
            return Stream.of(abstractType);
        }
        Set concreteTypes = typeInfo.getAllDescendantClasses();
        concreteTypes.add(typeInfo);
        concreteTypes.removeIf(i -> Modifier.isAbstract(i.getJavaClass().getModifiers()));
        return concreteTypes.stream().map(RMTypeInfo::getRmName);
    }

    static Optional<String> rmTypeFromArchetype(String archetypeNodeId) {
        return Optional.ofNullable(archetypeNodeId).filter(s -> s.startsWith("openEHR-EHR-")).map(s -> {
            try {
                return new ArchetypeHRID(archetypeNodeId);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).map(ArchetypeHRID::getRmClass);
    }

    static Set<String> getCandidateTypes(PathPredicateOperand value) {
        if (value instanceof Primitive) {
            Primitive p = (Primitive)value;
            if (p.getValue() == null) {
                return null;
            }
            if (value instanceof DoublePrimitive || value instanceof LongPrimitive) {
                return Stream.of(FoundationType.DOUBLE, FoundationType.INTEGER, FoundationType.LONG).map(Enum::name).collect(Collectors.toSet());
            }
            if (value instanceof BooleanPrimitive) {
                return Stream.of(FoundationType.BOOLEAN).map(Enum::name).collect(Collectors.toSet());
            }
            if (value instanceof StringPrimitive) {
                if (value instanceof TemporalPrimitive) {
                    return Stream.of(FoundationType.STRING, FoundationType.TEMPORAL, FoundationType.TEMPORAL_ACCESSOR, FoundationType.TEMPORAL_AMOUNT).map(Enum::name).collect(Collectors.toSet());
                }
                return Stream.of(FoundationType.STRING, FoundationType.CHAR, FoundationType.URI).map(Enum::name).collect(Collectors.toSet());
            }
            throw new IllegalArgumentException("Unknown primitive type %s".formatted(value.getClass().getName()));
        }
        return null;
    }

    public static Map<ANode, Map<String, AttInfo>> createAttributeInfos(ANode rootNode) {
        HashMap<ANode, Map<String, AttInfo>> infos = new HashMap<ANode, Map<String, AttInfo>>();
        Iterator<ANode> nodeIt = PathAnalysis.iterateNodes(rootNode);
        while (nodeIt.hasNext()) {
            ANode node = nodeIt.next();
            Map<String, AttInfo> attInfos = node.attributes.entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()), (Object)PathAnalysis.createAttributeInfo(node, (String)e.getKey(), (ANode)e.getValue()))).filter(p -> p.getValue() != null).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            if (attInfos.isEmpty()) continue;
            infos.put(node, attInfos);
        }
        return infos;
    }

    private static Iterator<ANode> iterateNodes(ANode rootNode) {
        final LinkedList<ANode> stack = new LinkedList<ANode>();
        stack.add(rootNode);
        return new Iterator<ANode>(){

            @Override
            public boolean hasNext() {
                return !stack.isEmpty();
            }

            @Override
            public ANode next() {
                ANode node = (ANode)stack.remove();
                stack.addAll(node.attributes.values());
                return node;
            }
        };
    }

    private static AttInfo createAttributeInfo(ANode node, String attName, ANode childNode) {
        return AttributeInfos.attributeInfos.getOrDefault(attName, Map.of()).entrySet().stream().filter(e -> node.candidateTypes.contains(e.getKey())).map(Map.Entry::getValue).filter(a -> !Collections.disjoint(childNode.candidateTypes, a.targetTypes)).reduce((a, b) -> new AttInfo(a.multipleValued || b.multipleValued, a.nullable || b.nullable, (Set<String>)SetUtils.union(a.targetTypes, b.targetTypes))).orElse(null);
    }

    public static ANode analyzeAqlPathTypes(String rootType, List<AndOperatorPredicate> variablePredicates, List<AndOperatorPredicate> rootPredicates, AqlObjectPath path, Set<String> candidateTypes) {
        ANode rootNode = new ANode(rootType, variablePredicates, rootPredicates);
        PathAnalysis.appendPath(rootNode, path, candidateTypes);
        PathAnalysis.validateAttributeNamesExist(rootNode);
        while (PathAnalysis.applyChildAttributeConstraints(rootNode)) {
        }
        return rootNode;
    }

    private static boolean applyChildAttributeConstraints(ANode node) {
        if (node.attributes.isEmpty() || node.candidateTypes != null && node.candidateTypes.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Map.Entry<String, ANode> att : node.attributes.entrySet()) {
            changed |= PathAnalysis.applyAttributeConstraints(node, att.getKey(), att.getValue());
            changed |= PathAnalysis.applyChildAttributeConstraints(att.getValue());
        }
        return changed;
    }

    private static boolean applyAttributeConstraints(ANode parentNode, String attName, ANode childNode) {
        Map<String, Set<String>> typeConstellations = AttributeInfos.typedAttributes.get(attName);
        if (typeConstellations == null) {
            parentNode.candidateTypes = new HashSet<String>();
            childNode.candidateTypes = new HashSet<String>();
            return true;
        }
        if (parentNode.candidateTypes == null) {
            if (childNode.candidateTypes == null) {
                parentNode.candidateTypes = new HashSet<String>(typeConstellations.keySet());
                childNode.candidateTypes = new HashSet<String>(typeConstellations.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
            } else {
                Set childConstraints = typeConstellations.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                childNode.candidateTypes.removeIf(t -> !childConstraints.contains(t));
                parentNode.candidateTypes = typeConstellations.entrySet().stream().filter(e -> CollectionUtils.containsAny((Collection)((Collection)e.getValue()), childNode.candidateTypes)).map(Map.Entry::getKey).collect(Collectors.toSet());
            }
            return true;
        }
        boolean changed = parentNode.candidateTypes.removeIf(t -> {
            Set supportedChildTypes = (Set)typeConstellations.get(t);
            if (CollectionUtils.isEmpty((Collection)supportedChildTypes)) {
                return true;
            }
            if (childNode.candidateTypes == null) {
                return false;
            }
            return !CollectionUtils.containsAny(childNode.candidateTypes, (Collection)supportedChildTypes);
        });
        Set childConstraints = typeConstellations.entrySet().stream().filter(e -> parentNode.candidateTypes.contains(e.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
        if (childNode.candidateTypes == null) {
            childNode.candidateTypes = childConstraints;
            changed = true;
        } else {
            changed |= childNode.candidateTypes.removeIf(t -> !childConstraints.contains(t));
        }
        return changed;
    }

    static void appendPath(ANode root, AqlObjectPath path, Set<String> candidateTypes) {
        if (path == null) {
            return;
        }
        Iterator nodeIt = path.getPathNodes().iterator();
        ANode n = root;
        while (nodeIt.hasNext()) {
            n = PathAnalysis.addAttributes(n, (AqlObjectPath.PathNode)nodeIt.next());
        }
        if (candidateTypes != null) {
            if (n.candidateTypes == null) {
                n.candidateTypes = new HashSet<String>(candidateTypes);
            } else {
                n.candidateTypes.removeIf(t -> !candidateTypes.contains(t));
            }
        }
    }

    private static ANode addAttributes(ANode root, AqlObjectPath.PathNode child) {
        String attName = child.getAttribute();
        ANode childANode = root.attributes.get(attName);
        if (childANode == null) {
            childANode = new ANode((String)null, null, (List<AndOperatorPredicate>)child.getPredicateOrOperands());
            root.attributes.put(attName, childANode);
        } else {
            childANode.constrainByArchetype(child.getPredicateOrOperands());
            childANode.addPredicateConstraints(child.getPredicateOrOperands());
        }
        return childANode;
    }

    public static class AttributeInfos {
        static final Set<String> rmTypes;
        static final Map<String, Set<String>> baseTypesByAttribute;
        static final Map<String, Map<String, Set<String>>> typedAttributes;
        static final Map<String, Map<String, AttInfo>> attributeInfos;

        private static void addEhrAttributes(Set<String> rmTypes, Map<String, Set<String>> baseTypesByAttribute, Map<String, Map<String, Set<String>>> typedAttributes, Map<String, Map<String, AttInfo>> attributeInfos) {
            String baseType = "EHR";
            rmTypes.add(baseType);
            AttributeInfos.addAttribute("ehrId", baseType, Set.of("HIER_OBJECT_ID"), baseTypesByAttribute, typedAttributes, attributeInfos);
            AttributeInfos.addAttribute("timeCreated", baseType, Set.of("DV_DATE_TIME"), baseTypesByAttribute, typedAttributes, attributeInfos);
            AttributeInfos.addAttribute("ehrStatus", baseType, Set.of("EHR_STATUS"), baseTypesByAttribute, typedAttributes, attributeInfos);
            AttributeInfos.addAttribute("compositions", baseType, Set.of("COMPOSITION"), baseTypesByAttribute, typedAttributes, attributeInfos);
        }

        private static void addAttribute(String attribute, String baseType, Set<String> targetTypes, Map<String, Set<String>> baseTypesByAttribute, Map<String, Map<String, Set<String>>> typedAttributes, Map<String, Map<String, AttInfo>> attributeInfos) {
            baseTypesByAttribute.computeIfAbsent(attribute, k -> new HashSet()).add(baseType);
            typedAttributes.computeIfAbsent(attribute, k -> new HashMap()).computeIfAbsent(baseType, k -> new HashSet()).addAll(targetTypes);
            attributeInfos.computeIfAbsent(attribute, k -> new HashMap()).put(baseType, new AttInfo(false, false, targetTypes));
        }

        private static <K, V> Map<K, V> unmodifiableCopy(Map<K, V> map) {
            if (map == null) {
                return null;
            }
            HashMap ret = new HashMap();
            map.forEach((k, v) -> {
                Map map = v;
                Objects.requireNonNull(map);
                Map selector0$temp = map;
                int index$1 = 0;
                ret.put(k, switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, Set.class}, (Object)selector0$temp, index$1)) {
                    case 0 -> {
                        Map m = selector0$temp;
                        yield AttributeInfos.unmodifiableCopy(m);
                    }
                    case 1 -> {
                        Set s = (Set)((Object)selector0$temp);
                        yield AttributeInfos.unmodifiableCopy(s);
                    }
                    default -> v;
                });
            });
            return Map.copyOf(ret);
        }

        private static <V> Set<V> unmodifiableCopy(Set<V> set) {
            if (set == null) {
                return null;
            }
            HashSet ret = new HashSet();
            set.forEach(v -> {
                Map map = v;
                Objects.requireNonNull(map);
                Map selector0$temp = map;
                int index$1 = 0;
                ret.add(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, Set.class}, (Object)selector0$temp, index$1)) {
                    case 0 -> {
                        Map m = selector0$temp;
                        yield AttributeInfos.unmodifiableCopy(m);
                    }
                    case 1 -> {
                        Set s = (Set)((Object)selector0$temp);
                        yield AttributeInfos.unmodifiableCopy(s);
                    }
                    default -> v;
                });
            });
            return Set.copyOf(ret);
        }

        private static List<String> calculateContainedTypes(String rootType) {
            LinkedList<RMTypeInfo> remainingTypes = new LinkedList<RMTypeInfo>();
            remainingTypes.add(RM_INFOS.getTypeInfo(rootType));
            HashSet<RMTypeInfo> seen = new HashSet<RMTypeInfo>();
            seen.add((RMTypeInfo)remainingTypes.peek());
            ArrayList<String> typeNames = new ArrayList<String>();
            while (!remainingTypes.isEmpty()) {
                RMTypeInfo typeInfo = (RMTypeInfo)remainingTypes.poll();
                typeNames.add(typeInfo.getRmName());
                typeInfo.getDirectDescendantClasses().stream().filter(seen::add).forEach(remainingTypes::add);
                typeInfo.getAttributes().values().stream().filter(ti -> !ti.isComputed()).map(RMAttributeInfo::getTypeNameInCollection).map(arg_0 -> ((ArchieRMInfoLookup)RM_INFOS).getTypeInfo(arg_0)).filter(Objects::nonNull).filter(seen::add).forEach(remainingTypes::add);
            }
            return typeNames;
        }

        private static Map<String, Set<String>> calculateBaseTypesByAttribute(Set<String> rmTypes) {
            return rmTypes.stream().map(arg_0 -> ((ArchieRMInfoLookup)RM_INFOS).getTypeInfo(arg_0)).filter(Objects::nonNull).flatMap(t -> t.getAttributes().values().stream().filter(a -> !a.isComputed()).map(a -> Pair.of((Object)t.getRmName(), (Object)a))).collect(Collectors.groupingBy(p -> ((RMAttributeInfo)p.getRight()).getRmName(), Collectors.mapping(p -> (String)p.getLeft(), Collectors.toSet())));
        }

        static Map<String, Map<String, Set<String>>> calculateTypedAttributes(Set<String> rmTypes) {
            return rmTypes.stream().map(arg_0 -> ((ArchieRMInfoLookup)RM_INFOS).getTypeInfo(arg_0)).filter(Objects::nonNull).flatMap(t -> t.getAttributes().values().stream().filter(a -> !a.isComputed()).flatMap(a -> PathAnalysis.resolveConcreteTypeNames(a.getTypeNameInCollection()).map(vt -> Triple.of((Object)t.getRmName(), (Object)a.getRmName(), (Object)vt)))).collect(Collectors.groupingBy(Triple::getMiddle, Collectors.groupingBy(Triple::getLeft, Collectors.mapping(Triple::getRight, Collectors.toSet()))));
        }

        private static Map<String, Map<String, AttInfo>> calculateAttributeInfos(Map<String, Map<String, Set<String>>> typedAttributes) {
            return typedAttributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, f -> {
                RMAttributeInfo attributeInfo = RM_INFOS.getAttributeInfo((String)f.getKey(), (String)e.getKey());
                return new AttInfo(attributeInfo.isMultipleValued(), attributeInfo.isNullable(), (Set)f.getValue());
            }))));
        }

        static {
            LinkedHashSet<String> typesModifiable = new LinkedHashSet<String>();
            Stream.of("EHR_STATUS", "COMPOSITION", "FOLDER", "ORIGINAL_VERSION").map(AttributeInfos::calculateContainedTypes).forEach(typesModifiable::addAll);
            Map<String, Set<String>> baseTypesByAttributeModifiable = AttributeInfos.calculateBaseTypesByAttribute(typesModifiable);
            Map<String, Map<String, Set<String>>> typedAttributesModifiable = AttributeInfos.calculateTypedAttributes(typesModifiable);
            Map<String, Map<String, AttInfo>> attributeInfosModifiable = AttributeInfos.calculateAttributeInfos(typedAttributesModifiable);
            AttributeInfos.addEhrAttributes(typesModifiable, baseTypesByAttributeModifiable, typedAttributesModifiable, attributeInfosModifiable);
            rmTypes = Collections.unmodifiableSet(typesModifiable);
            baseTypesByAttribute = AttributeInfos.unmodifiableCopy(baseTypesByAttributeModifiable);
            typedAttributes = AttributeInfos.unmodifiableCopy(typedAttributesModifiable);
            attributeInfos = AttributeInfos.unmodifiableCopy(attributeInfosModifiable);
        }
    }

    public record AttInfo(boolean multipleValued, boolean nullable, Set<String> targetTypes) {
    }
}

