/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.querywrapper;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.openehr.aqlengine.pathanalysis.PathInfo;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsChain;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsSetOperationWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.ContainsWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.RmContainsWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.contains.VersionContainsWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.orderby.OrderByWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.select.SelectWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ComparisonOperatorConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.ConditionWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.where.LogicalOperatorConditionWrapper;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.ExistsCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LikeCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LogicalOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.MatchesCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.NotCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.WhereCondition;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentVersionExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.ColumnExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.orderby.OrderByExpression;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectExpression;
import org.ehrbase.openehr.sdk.aql.util.AqlUtil;

public final class AqlQueryWrapper {
    private final boolean distinct;
    private final List<SelectWrapper> selects;
    private final ContainsChain containsChain;
    private final ConditionWrapper where;
    private final List<OrderByWrapper> orderBy;
    private final Long limit;
    private final Long offset;
    private final Map<ContainsWrapper, PathInfo> pathInfos;

    public AqlQueryWrapper(boolean distinct, List<SelectWrapper> selects, ContainsChain containsChain, ConditionWrapper where, List<OrderByWrapper> orderBy, Long limit, Long offset, Map<ContainsWrapper, PathInfo> pathInfos) {
        this.distinct = distinct;
        this.selects = selects;
        this.containsChain = containsChain;
        this.where = where;
        this.orderBy = orderBy;
        this.limit = limit;
        this.offset = offset;
        this.pathInfos = pathInfos;
    }

    public Stream<SelectWrapper> nonPrimitiveSelects() {
        return this.selects.stream().filter(sd -> sd.type() != SelectWrapper.SelectType.PRIMITIVE);
    }

    public static AqlQueryWrapper create(AqlQuery aqlQuery) {
        LinkedHashMap<AbstractContainmentExpression, ContainsWrapper> containsDescs = new LinkedHashMap<AbstractContainmentExpression, ContainsWrapper>();
        AbstractContainmentExpression fromRoot = (AbstractContainmentExpression)aqlQuery.getFrom();
        AqlUtil.streamContainments((Containment)fromRoot).filter(ContainmentClassExpression.class::isInstance).map(ContainmentClassExpression.class::cast).forEach(c -> containsDescs.put((AbstractContainmentExpression)c, new RmContainsWrapper((ContainmentClassExpression)c)));
        AqlUtil.streamContainments((Containment)fromRoot).filter(ContainmentVersionExpression.class::isInstance).map(ContainmentVersionExpression.class::cast).forEach(c -> containsDescs.put((AbstractContainmentExpression)c, new VersionContainsWrapper(c.getIdentifier(), (RmContainsWrapper)containsDescs.get(c.getContains()))));
        ContainsChain fromClause = AqlQueryWrapper.buildContainsChain((Containment)fromRoot, containsDescs);
        List<SelectWrapper> selects = aqlQuery.getSelect().getStatement().stream().map(s -> AqlQueryWrapper.buildSelectDescriptor(containsDescs, s)).toList();
        ConditionWrapper where = Optional.of(aqlQuery).map(AqlQuery::getWhere).map(w -> AqlQueryWrapper.buildWhereDescriptor(w, containsDescs, false)).orElse(null);
        List<OrderByWrapper> orderBy = CollectionUtils.emptyIfNull((Collection)aqlQuery.getOrderBy()).stream().map(o -> AqlQueryWrapper.buildOrderByDescriptor(o, containsDescs)).toList();
        Map<ContainsWrapper, PathInfo> pathInfos = PathInfo.createPathInfos(aqlQuery, containsDescs);
        return new AqlQueryWrapper(aqlQuery.getSelect().isDistinct(), selects, fromClause, where, orderBy, aqlQuery.getLimit(), aqlQuery.getOffset(), pathInfos);
    }

    private static OrderByWrapper buildOrderByDescriptor(OrderByExpression expression, Map<AbstractContainmentExpression, ContainsWrapper> containsDescs) {
        return new OrderByWrapper(expression.getStatement(), expression.getSymbol(), containsDescs.get(expression.getStatement().getRoot()));
    }

    private static ContainsChain buildContainsChain(Containment root, Map<AbstractContainmentExpression, ContainsWrapper> containsDescs) {
        ContainsSetOperationWrapper setOperator;
        ArrayList<ContainsWrapper> chain = new ArrayList<ContainsWrapper>();
        Containment next = root;
        while (next instanceof AbstractContainmentExpression) {
            AbstractContainmentExpression c2 = (AbstractContainmentExpression)next;
            chain.add(containsDescs.get(next));
            if (next instanceof ContainmentVersionExpression) {
                next = ((AbstractContainmentExpression)c2.getContains()).getContains();
                continue;
            }
            next = c2.getContains();
        }
        if (next instanceof ContainmentSetOperator) {
            ContainmentSetOperator o = (ContainmentSetOperator)next;
            setOperator = new ContainsSetOperationWrapper(o.getSymbol(), o.getValues().stream().map(c -> AqlQueryWrapper.buildContainsChain(c, containsDescs)).toList());
        } else {
            setOperator = null;
        }
        return new ContainsChain(chain, setOperator);
    }

    private static SelectWrapper buildSelectDescriptor(Map<AbstractContainmentExpression, ContainsWrapper> containsDescs, SelectExpression s) {
        ColumnExpression columnExpression = s.getColumnExpression();
        Objects.requireNonNull(columnExpression);
        ColumnExpression columnExpression2 = columnExpression;
        int n = 0;
        Pair typeAndPath = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentifiedPath.class, AggregateFunction.class, Primitive.class}, (Object)columnExpression2, n)) {
            case 0 -> {
                IdentifiedPath i = (IdentifiedPath)columnExpression2;
                yield Pair.of((Object)((Object)SelectWrapper.SelectType.PATH), (Object)i);
            }
            case 1 -> {
                AggregateFunction af = (AggregateFunction)columnExpression2;
                yield Pair.of((Object)((Object)SelectWrapper.SelectType.AGGREGATE_FUNCTION), (Object)af.getIdentifiedPath());
            }
            case 2 -> {
                Primitive __ = (Primitive)columnExpression2;
                yield Pair.of((Object)((Object)SelectWrapper.SelectType.PRIMITIVE), null);
            }
            default -> throw new IllegalArgumentException("Unknown ColumnExpression type in SELECT");
        };
        return new SelectWrapper(s, (SelectWrapper.SelectType)((Object)typeAndPath.getLeft()), Optional.of(typeAndPath).map(Pair::getRight).map(IdentifiedPath::getRoot).map(containsDescs::get).orElse(null));
    }

    private static ConditionWrapper buildWhereDescriptor(WhereCondition where, Map<AbstractContainmentExpression, ContainsWrapper> containsDescs, boolean negate) {
        WhereCondition whereCondition = where;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComparisonOperatorCondition.class, MatchesCondition.class, LikeCondition.class, ExistsCondition.class, LogicalOperatorCondition.class, NotCondition.class}, (Object)whereCondition, n)) {
            case 0 -> {
                ComparisonOperatorCondition c = (ComparisonOperatorCondition)whereCondition;
                yield new ComparisonOperatorConditionWrapper(new ComparisonOperatorConditionWrapper.IdentifiedPathWrapper(containsDescs.get(((IdentifiedPath)c.getStatement()).getRoot()), (IdentifiedPath)c.getStatement()), ConditionWrapper.ComparisonConditionOperator.valueOf(c.getSymbol().name(), negate), (Primitive)c.getValue());
            }
            case 1 -> {
                MatchesCondition c = (MatchesCondition)whereCondition;
                if (negate) {
                    yield new LogicalOperatorConditionWrapper(ConditionWrapper.LogicalConditionOperator.AND, c.getValues().stream().map(Primitive.class::cast).map(v -> new ComparisonOperatorConditionWrapper(new ComparisonOperatorConditionWrapper.IdentifiedPathWrapper((ContainsWrapper)containsDescs.get(c.getStatement().getRoot()), c.getStatement()), ConditionWrapper.ComparisonConditionOperator.NEQ, (Primitive)v)).toList());
                }
                yield new ComparisonOperatorConditionWrapper(new ComparisonOperatorConditionWrapper.IdentifiedPathWrapper(containsDescs.get(c.getStatement().getRoot()), c.getStatement()), ConditionWrapper.ComparisonConditionOperator.MATCHES, c.getValues().stream().map(Primitive.class::cast).toList());
            }
            case 2 -> {
                LikeCondition c = (LikeCondition)whereCondition;
                ComparisonOperatorConditionWrapper condition = new ComparisonOperatorConditionWrapper(new ComparisonOperatorConditionWrapper.IdentifiedPathWrapper(containsDescs.get(c.getStatement().getRoot()), c.getStatement()), ConditionWrapper.ComparisonConditionOperator.LIKE, (Primitive)c.getValue());
                if (negate) {
                    yield new LogicalOperatorConditionWrapper(ConditionWrapper.LogicalConditionOperator.NOT, List.of(condition));
                }
                yield condition;
            }
            case 3 -> {
                ExistsCondition c = (ExistsCondition)whereCondition;
                ComparisonOperatorConditionWrapper comparisonOperatorConditionDescriptor = new ComparisonOperatorConditionWrapper(new ComparisonOperatorConditionWrapper.IdentifiedPathWrapper(containsDescs.get(c.getValue().getRoot()), c.getValue()), ConditionWrapper.ComparisonConditionOperator.EXISTS, List.of());
                if (negate) {
                    yield new LogicalOperatorConditionWrapper(ConditionWrapper.LogicalConditionOperator.NOT, List.of(comparisonOperatorConditionDescriptor));
                }
                yield comparisonOperatorConditionDescriptor;
            }
            case 4 -> {
                LogicalOperatorCondition c = (LogicalOperatorCondition)whereCondition;
                ConditionWrapper.LogicalConditionOperator v1 = switch (c.getSymbol()) {
                    default -> throw new MatchException(null, null);
                    case LogicalOperatorCondition.ConditionLogicalOperatorSymbol.OR -> {
                        if (negate) {
                            yield ConditionWrapper.LogicalConditionOperator.AND;
                        }
                        yield ConditionWrapper.LogicalConditionOperator.OR;
                    }
                    case LogicalOperatorCondition.ConditionLogicalOperatorSymbol.AND -> negate ? ConditionWrapper.LogicalConditionOperator.OR : ConditionWrapper.LogicalConditionOperator.AND;
                };
                yield new LogicalOperatorConditionWrapper(v1, c.getValues().stream().map(w -> AqlQueryWrapper.buildWhereDescriptor(w, containsDescs, negate)).toList());
            }
            case 5 -> {
                NotCondition c = (NotCondition)whereCondition;
                yield AqlQueryWrapper.buildWhereDescriptor(c.getConditionDto(), containsDescs, !negate);
            }
            case -1 -> throw new IllegalArgumentException("Encountered null reference instead of WhereCondition object");
            default -> throw new IllegalArgumentException("Unknown WhereCondition class: %s".formatted(where.getClass()));
        };
    }

    public boolean distinct() {
        return this.distinct;
    }

    public List<SelectWrapper> selects() {
        return this.selects;
    }

    public ContainsChain containsChain() {
        return this.containsChain;
    }

    public ConditionWrapper where() {
        return this.where;
    }

    public List<OrderByWrapper> orderBy() {
        return this.orderBy;
    }

    public Long limit() {
        return this.limit;
    }

    public Long offset() {
        return this.offset;
    }

    public Map<ContainsWrapper, PathInfo> pathInfos() {
        return this.pathInfos;
    }

    public String toString() {
        return "AqlQueryWrapper[distinct=" + this.distinct + ", selects=" + String.valueOf(this.selects) + ", containsChain=" + String.valueOf(this.containsChain) + ", where=" + String.valueOf(this.where) + ", orderBy=" + String.valueOf(this.orderBy) + ", limit=" + this.limit + ", offset=" + this.offset + ", pathInfos=" + String.valueOf(this.pathInfos) + "]";
    }
}

