/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.LongStream;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.api.exception.BadGatewayException;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.service.AqlQueryService;
import org.ehrbase.openehr.aqlengine.AqlQueryParsingPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.AqlSqlLayer;
import org.ehrbase.openehr.aqlengine.asl.AslPostProcessor;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.featurecheck.AqlQueryFeatureCheck;
import org.ehrbase.openehr.aqlengine.querywrapper.AqlQueryWrapper;
import org.ehrbase.openehr.aqlengine.querywrapper.select.SelectWrapper;
import org.ehrbase.openehr.aqlengine.repository.AqlQueryRepository;
import org.ehrbase.openehr.aqlengine.repository.PreparedQuery;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.sdk.aql.render.AqlRenderer;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryResultDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.query.ResultHolder;
import org.ehrbase.openehr.sdk.validation.terminology.ExternalTerminologyValidation;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class AqlQueryServiceImp
implements AqlQueryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AqlQueryRepository aqlQueryRepository;
    private final ExternalTerminologyValidation tsAdapter;
    private final AqlSqlLayer aqlSqlLayer;
    private final AqlQueryFeatureCheck aqlQueryFeatureCheck;
    private final ObjectMapper objectMapper;
    private final AqlQueryContext aqlQueryContext;
    private final List<AqlQueryParsingPostProcessor> aqlPostProcessors;
    private final List<AslPostProcessor> aslPostProcessors;

    @Autowired
    public AqlQueryServiceImp(AqlQueryRepository aqlQueryRepository, ExternalTerminologyValidation tsAdapter, AqlSqlLayer aqlSqlLayer, AqlQueryFeatureCheck aqlQueryFeatureCheck, ObjectMapper objectMapper, AqlQueryContext aqlQueryContext, List<AqlQueryParsingPostProcessor> aqlPostProcessors, List<AslPostProcessor> aslPostProcessors) {
        this.aqlQueryRepository = aqlQueryRepository;
        this.tsAdapter = tsAdapter;
        this.aqlSqlLayer = aqlSqlLayer;
        this.aqlQueryFeatureCheck = aqlQueryFeatureCheck;
        this.objectMapper = objectMapper;
        this.aqlQueryContext = aqlQueryContext;
        this.aqlPostProcessors = aqlPostProcessors;
        this.aslPostProcessors = aslPostProcessors;
    }

    public QueryResultDto query(AqlQueryRequest aqlQuery) {
        return this.queryAql(aqlQuery);
    }

    private QueryResultDto queryAql(AqlQueryRequest aqlQueryRequest) {
        try {
            AqlQuery aqlQuery = AqlQueryParser.parse((String)aqlQueryRequest.queryString());
            this.aqlPostProcessors.forEach(p -> p.afterParseAql(aqlQuery, aqlQueryRequest, this.aqlQueryContext));
            try {
                List<List<Object>> resultData;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(this.objectMapper.writeValueAsString((Object)aqlQuery));
                }
                AqlQueryWrapper queryWrapper = AqlQueryWrapper.create(aqlQuery);
                AslRootQuery aslQuery = this.aqlSqlLayer.buildAslRootQuery(queryWrapper);
                this.aslPostProcessors.forEach(p -> p.afterBuildAsl(aslQuery, aqlQuery, queryWrapper, aqlQueryRequest));
                List<SelectWrapper> nonPrimitiveSelects = queryWrapper.nonPrimitiveSelects().toList();
                if (this.aqlQueryContext.showExecutedAql()) {
                    this.aqlQueryContext.setExecutedAql(AqlRenderer.render((AqlQuery)aqlQuery));
                }
                Optional.of(queryWrapper).map(AqlQueryWrapper::limit).map(Long::intValue).ifPresent(limit -> {
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.FETCH, limit);
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.OFFSET, (Object)Optional.of(queryWrapper).map(AqlQueryWrapper::offset).map(Long::intValue).orElse(0));
                });
                PreparedQuery preparedQuery = this.aqlQueryRepository.prepareQuery(aslQuery, nonPrimitiveSelects);
                if (this.aqlQueryContext.showExecutedSql()) {
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.EXECUTED_SQL, (Object)AqlQueryRepository.getQuerySql(preparedQuery));
                }
                if (this.aqlQueryContext.showQueryPlan()) {
                    boolean analyze = !this.aqlQueryContext.isDryRun();
                    String explainedQuery = this.aqlQueryRepository.explainQuery(analyze, preparedQuery);
                    TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(this){};
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.QUERY_PLAN, this.objectMapper.readValue(explainedQuery, (TypeReference)typeRef));
                }
                if (this.aqlQueryContext.isDryRun()) {
                    resultData = List.of();
                } else {
                    resultData = this.executeQuery(preparedQuery, queryWrapper, nonPrimitiveSelects);
                    this.aqlQueryContext.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.RESULT_SIZE, (Object)resultData.size());
                }
                return this.formatResult(queryWrapper.selects(), resultData);
            }
            catch (JsonProcessingException | IllegalArgumentException e) {
                throw new InternalServerException(e.getMessage(), e);
            }
        }
        catch (RestClientException e) {
            throw new BadGatewayException(AqlQueryServiceImp.errorMessage("Bad gateway", (Exception)((Object)e)), (Throwable)e);
        }
        catch (DataAccessException e) {
            throw new InternalServerException(AqlQueryServiceImp.errorMessage("Data Access Error", (Exception)((Object)e)), (Throwable)e);
        }
        catch (AqlParseException e) {
            throw new IllegalAqlException(AqlQueryServiceImp.errorMessage("Could not parse AQL query", (Exception)((Object)e)), (Throwable)e);
        }
    }

    private List<List<Object>> executeQuery(PreparedQuery preparedQuery, AqlQueryWrapper queryWrapper, List<SelectWrapper> nonPrimitiveSelects) {
        List<List<Object>> resultData = this.aqlQueryRepository.executeQuery(preparedQuery);
        List<SelectWrapper> selects = queryWrapper.selects();
        if (nonPrimitiveSelects.isEmpty()) {
            resultData = LongStream.range(0L, (Long)resultData.getFirst().getFirst()).mapToObj(i -> new ArrayList(selects.size())).toList();
        }
        int s = selects.size();
        for (int i2 = 0; i2 < s; ++i2) {
            SelectWrapper sd = selects.get(i2);
            if (sd.type() != SelectWrapper.SelectType.PRIMITIVE) continue;
            Constable value = sd.getPrimitive().getValue();
            for (List<Object> row : resultData) {
                row.add(i2, value);
            }
        }
        return resultData;
    }

    private QueryResultDto formatResult(List<SelectWrapper> selectFields, List<List<Object>> resultData) {
        String[] columnNames = new String[selectFields.size()];
        LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
        int s = selectFields.size();
        for (int i = 0; i < s; ++i) {
            SelectWrapper namePath = selectFields.get(i);
            columnNames[i] = Optional.of(namePath).map(SelectWrapper::getSelectAlias).orElse("#" + i);
            columns.put(columnNames[i], namePath.getSelectPath().orElse(null));
        }
        QueryResultDto dto = new QueryResultDto();
        dto.setVariables(columns);
        dto.setResultSet(resultData.stream().map(r -> {
            ResultHolder fieldMap = new ResultHolder();
            int s = r.size();
            for (int i = 0; i < s; ++i) {
                fieldMap.putResult(columnNames[i], r.get(i));
            }
            return fieldMap;
        }).toList());
        return dto;
    }

    private static String errorMessage(String prefix, Exception e) {
        return prefix + ": " + Optional.of(e).map(Throwable::getCause).orElse(e).getMessage();
    }
}

