/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.asl;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslAndQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslDescendantCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFalseQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotNullQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslOrQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslPathChildCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslTrueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslFolderItemIdVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslOrderByField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslAuditDetailsJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslDelegatingJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslFolderItemJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslEncapsulatingQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslPathDataQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslRootQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;

public class AslGraph {
    public static String createAslGraph(AslRootQuery query) {
        return StringUtils.join((Object[])new String[]{AslGraph.indented(0, "AslRootQuery"), AslGraph.selectGraph(1, query.getSelect()), AslGraph.indented(1, "FROM"), query.getChildren().stream().map(s -> AslGraph.sqToGraph(2, (AslQuery)s.getLeft(), (AslJoin)s.getRight())).collect(Collectors.joining()), AslGraph.section(1, query.getCondition(), Objects::nonNull, __ -> "WHERE", AslGraph::conditionToGraph), AslGraph.section(1, query.getGroupByFields(), CollectionUtils::isNotEmpty, __ -> "GROUP BY", (l, fs) -> fs.stream().map(f -> AslGraph.indented(l, AslGraph.fieldToGraph(l, f))).collect(Collectors.joining())), AslGraph.section(1, query.getOrderByFields(), CollectionUtils::isNotEmpty, __ -> "ORDER BY", (l, fs) -> fs.stream().map(f -> AslGraph.orderByToGraph(l, f)).collect(Collectors.joining())), AslGraph.section(1, query.getLimit(), Objects::nonNull, arg_0 -> AslGraph.lambda$createAslGraph$8("LIMIT %d", arg_0), (l, v) -> ""), AslGraph.section(1, query.getOffset(), Objects::nonNull, arg_0 -> AslGraph.lambda$createAslGraph$10("OFFSET %d", arg_0), (l, v) -> "")});
    }

    private static String selectGraph(int level, List<AslField> select) {
        return AslGraph.indented(level, "SELECT") + AslGraph.indented(level + 1, select.stream(), s -> AslGraph.fieldToGraph(level + 1, s));
    }

    private static <T> String sqToGraph(int level, AslQuery subquery, AslJoin join) {
        String fromStructure = AslGraph.section(level + 1, subquery, AslStructureQuery.class::isInstance, sq -> "FROM " + ((AslStructureQuery)sq).getType().name(), (l, sq) -> "");
        String fromEncapsulating = AslGraph.section(level + 2, subquery, AslEncapsulatingQuery.class::isInstance, __ -> "FROM", (l, sq) -> AslGraph.indented(l, ((AslEncapsulatingQuery)sq).getChildren().stream(), c -> AslGraph.sqToGraph(l + 1, (AslQuery)c.getLeft(), (AslJoin)c.getRight())));
        String base = AslGraph.section(level + 1, subquery, AslDataQuery.class::isInstance, sq -> "BASE " + ((AslDataQuery)sq).getBase().getAlias(), (l, sq) -> "");
        String joinStr = Optional.ofNullable(join).map(j -> AslGraph.indented(level + 1, String.valueOf(j.getJoinType()) + " " + j.getLeft().getAlias() + " -> " + j.getRight().getAlias()) + AslGraph.section(level + 2, j.getOn(), CollectionUtils::isNotEmpty, c -> "on", AslGraph::conditionsToGraph)).orElse("");
        AslQuery aslQuery = subquery;
        Objects.requireNonNull(aslQuery);
        AslQuery aslQuery2 = aslQuery;
        int n = 0;
        String queryComment = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslPathDataQuery.class}, (Object)aslQuery2, n)) {
            case 0 -> {
                AslPathDataQuery pq = (AslPathDataQuery)aslQuery2;
                yield pq.getPathNodes(pq.getDataField()).stream().map(p -> p.getAttribute() + String.valueOf(p.getPredicateOrOperands())).collect(Collectors.joining(".", " -- ", ""));
            }
            default -> "";
        };
        return AslGraph.indented(level == 2 ? 2 : 0, subquery.getAlias() + ": " + AslGraph.typeName(subquery) + queryComment) + AslGraph.selectGraph(level + 1, subquery.getSelect()) + base + AslGraph.section(level + 1, subquery.getCondition(), Objects::nonNull, c -> "WHERE", AslGraph::conditionToGraph) + fromStructure + fromEncapsulating + AslGraph.section(level + 1, subquery.getStructureConditions(), CollectionUtils::isNotEmpty, c -> "STRUCTURE CONDITIONS", (l, cs) -> cs.stream().map(c -> AslGraph.conditionToGraph(level + 2, c)).collect(Collectors.joining())) + joinStr;
    }

    private static <T> String section(int level, T t, Predicate<T> condition, Function<T, String> header, BiFunction<Integer, T, String> body) {
        Optional<String> heading;
        if (!condition.test(t)) {
            return "";
        }
        return heading.orElse("") + body.apply(level + ((heading = Optional.of(header.apply(t)).filter(StringUtils::isNotBlank).map(h -> AslGraph.indented(level, h))).isPresent() ? 1 : 0), (Integer)t);
    }

    private static String typeName(AslQuery subquery) {
        String simpleName = subquery.getClass().getSimpleName();
        return StringUtils.removeStart((String)simpleName, (String)"Asl");
    }

    private static String conditionToGraph(int level, AslQueryCondition condition) {
        AslQueryCondition aslQueryCondition = condition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslNotQueryCondition.class, AslFieldValueQueryCondition.class, AslFalseQueryCondition.class, AslTrueQueryCondition.class, AslOrQueryCondition.class, AslAndQueryCondition.class, AslNotNullQueryCondition.class, AslFieldJoinCondition.class, AslDescendantCondition.class, AslPathChildCondition.class}, (Object)aslQueryCondition, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> "";
            case 0 -> {
                AslNotQueryCondition c = (AslNotQueryCondition)aslQueryCondition;
                yield AslGraph.indented(level, "NOT") + AslGraph.conditionToGraph(level + 1, c.getCondition());
            }
            case 1 -> {
                AslFieldValueQueryCondition c = (AslFieldValueQueryCondition)aslQueryCondition;
                yield AslGraph.indented(level, AslGraph.fieldToGraph(level + 1, c.getField()) + " " + String.valueOf(c.getOperator()) + " " + String.valueOf(c.getValues()));
            }
            case 2 -> {
                AslFalseQueryCondition aslFalseQueryCondition = (AslFalseQueryCondition)aslQueryCondition;
                yield AslGraph.indented(level, "false");
            }
            case 3 -> {
                AslTrueQueryCondition aslTrueQueryCondition = (AslTrueQueryCondition)aslQueryCondition;
                yield AslGraph.indented(level, "true");
            }
            case 4 -> {
                AslOrQueryCondition c = (AslOrQueryCondition)aslQueryCondition;
                yield AslGraph.indented(level, "OR") + c.getOperands().stream().map(op -> AslGraph.conditionToGraph(level + 1, op)).collect(Collectors.joining());
            }
            case 5 -> {
                AslAndQueryCondition c = (AslAndQueryCondition)aslQueryCondition;
                yield AslGraph.indented(level, "AND") + c.getOperands().stream().map(op -> AslGraph.conditionToGraph(level + 1, op)).collect(Collectors.joining());
            }
            case 6 -> {
                AslNotNullQueryCondition c = (AslNotNullQueryCondition)aslQueryCondition;
                yield AslGraph.indented(level, "NOT_NULL " + AslGraph.fieldToGraph(level + 1, c.getField()));
            }
            case 7 -> {
                AslFieldJoinCondition c = (AslFieldJoinCondition)aslQueryCondition;
                yield AslGraph.indented(level, "AslFieldJoinCondition %s.%s %s %s.%s".formatted(c.getLeftOwner().getAlias(), c.getLeftField().getAliasedName(), c.getOperator(), c.getRightOwner().getAlias(), c.getRightField().getAliasedName()));
            }
            case 8 -> {
                AslDescendantCondition c = (AslDescendantCondition)aslQueryCondition;
                yield AslGraph.indented(level, "DescendantCondition %s %s -> %s %s".formatted(c.getParentRelation(), c.getLeftOwner().getAlias(), c.getDescendantRelation(), c.getRightOwner().getAlias()));
            }
            case 9 -> {
                AslPathChildCondition c = (AslPathChildCondition)aslQueryCondition;
                yield AslGraph.indented(level, "PathChildCondition %s %s -> %s %s".formatted(c.getParentRelation(), c.getLeftOwner().getAlias(), c.getChildRelation(), c.getRightOwner().getAlias()));
            }
        };
    }

    private static String conditionsToGraph(int level, List<AslJoinCondition> joinConditions) {
        return joinConditions.stream().map(jc -> {
            AslJoinCondition aslJoinCondition = jc;
            Objects.requireNonNull(aslJoinCondition);
            AslJoinCondition selector0$temp = aslJoinCondition;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslPathFilterJoinCondition.class, AslDelegatingJoinCondition.class, AslAuditDetailsJoinCondition.class, AslFolderItemJoinCondition.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    AslPathFilterJoinCondition c = (AslPathFilterJoinCondition)selector0$temp;
                    yield "PathFilterJoinCondition %s ->\n%s".formatted(c.getLeftOwner().getAlias(), AslGraph.conditionToGraph(level + 2, c.getCondition()));
                }
                case 1 -> {
                    AslDelegatingJoinCondition c = (AslDelegatingJoinCondition)selector0$temp;
                    yield "DelegatingJoinCondition %s ->\n%s".formatted(c.getLeftOwner().getAlias(), AslGraph.conditionToGraph(level + 2, (AslQueryCondition)c.getDelegate()));
                }
                case 2 -> {
                    AslAuditDetailsJoinCondition c = (AslAuditDetailsJoinCondition)selector0$temp;
                    yield "AuditDetailsJoinCondition %s -> %s".formatted(c.getLeftOwner().getAlias(), c.getRightOwner().getAlias());
                }
                case 3 -> {
                    AslFolderItemJoinCondition c = (AslFolderItemJoinCondition)selector0$temp;
                    yield "FolderItemJoinCondition FOLDER -> %s [%s.vo_id in %s.data.items[].id.value]".formatted(c.descendantRelation(), c.getRightOwner().getAlias(), c.getLeftOwner().getAlias());
                }
            };
        }).map(s -> AslGraph.indented(level, s)).collect(Collectors.joining());
    }

    private static String orderByToGraph(int level, AslOrderByField sortOrderPair) {
        return AslGraph.fieldToGraph(level, sortOrderPair.field()) + " " + String.valueOf(sortOrderPair.direction());
    }

    private static String fieldToGraph(int level, AslField field) {
        String providerAlias = field.getInternalProvider() != null ? field.getInternalProvider().getAlias() + "." : "";
        AslField aslField = field;
        Objects.requireNonNull(aslField);
        AslField aslField2 = aslField;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslColumnField.class, AslComplexExtractedColumnField.class, AslAggregatingField.class, AslSubqueryField.class, AslConstantField.class, AslFolderItemIdVirtualField.class, AslRmPathField.class}, (Object)aslField2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslColumnField f = (AslColumnField)aslField2;
                yield providerAlias + f.getAliasedName() + Optional.of(f).map(AslField::getExtractedColumn).map(e -> " -- " + e.getPath().render()).orElse("");
            }
            case 1 -> {
                AslComplexExtractedColumnField f = (AslComplexExtractedColumnField)aslField2;
                yield providerAlias + "??" + Optional.of(f).map(AslField::getExtractedColumn).map(e -> " -- COMPLEX " + e.name() + " " + e.getPath().render()).orElse("");
            }
            case 2 -> {
                AslAggregatingField f = (AslAggregatingField)aslField2;
                yield "%s(%s%s)".formatted(f.getFunction(), f.isDistinct() ? "DISTINCT " : "", Optional.of(f).map(AslAggregatingField::getBaseField).map(bf -> AslGraph.fieldToGraph(level, bf)).orElse("*"));
            }
            case 3 -> {
                AslSubqueryField f = (AslSubqueryField)aslField2;
                yield AslGraph.sqToGraph(level + 1, f.getBaseQuery(), null) + (String)(f.getFilterConditions().isEmpty() ? "" : AslGraph.indented(level + 1, "Filter:") + f.getFilterConditions().stream().map(c -> AslGraph.conditionToGraph(level + 2, c)).collect(Collectors.joining("\n", "", "")));
            }
            case 4 -> {
                AslConstantField f = (AslConstantField)aslField2;
                yield "CONSTANT (%s): %s".formatted(f.getType().getSimpleName(), f.getValue());
            }
            case 5 -> {
                AslFolderItemIdVirtualField f = (AslFolderItemIdVirtualField)aslField2;
                yield providerAlias + f.aliasedName() + " -- FOLDER.items";
            }
            case 6 -> {
                AslRmPathField f = (AslRmPathField)aslField2;
                yield providerAlias + f.getSrcField().getAliasedName() + f.getPathInJson().stream().map(AqlObjectPath.PathNode::getAttribute).collect(Collectors.joining(" -> ", " -> ", ""));
            }
        };
    }

    private static <T> String indented(int level, Stream<T> entries, Function<T, String> toString) {
        String prefix = StringUtils.repeat((String)"  ", (int)level);
        return entries.map(toString::apply).collect(Collectors.joining("\n" + prefix, prefix, "\n"));
    }

    private static <T> String indented(int level, String str) {
        String prefix = StringUtils.repeat((String)"  ", (int)level);
        return prefix + str + "\n";
    }

    private static /* synthetic */ String lambda$createAslGraph$10(String rec$, Object xva$0) {
        return "OFFSET %d".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$createAslGraph$8(String rec$, Object xva$0) {
        return "LIMIT %d".formatted(xva$0);
    }
}

