/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.aqlengine.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.util.AdditionalSQLFunctions;
import org.ehrbase.openehr.aqlengine.asl.model.AslExtractedColumn;
import org.ehrbase.openehr.aqlengine.asl.model.AslRmTypeAndConcept;
import org.ehrbase.openehr.aqlengine.asl.model.AslStructureColumn;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslAndQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslDescendantCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslDvOrderedValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFalseQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslFieldValueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotNullQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslNotQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslOrQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslPathChildCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslProvidesJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.condition.AslTrueQueryCondition;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslAggregatingField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslComplexExtractedColumnField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslConstantField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslFolderItemIdVirtualField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslRmPathField;
import org.ehrbase.openehr.aqlengine.asl.model.field.AslSubqueryField;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslAuditDetailsJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslDelegatingJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslFolderItemJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoin;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.join.AslPathFilterJoinCondition;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslQuery;
import org.ehrbase.openehr.aqlengine.asl.model.query.AslStructureQuery;
import org.ehrbase.openehr.aqlengine.sql.AqlSqlQueryBuilder;
import org.ehrbase.openehr.aqlengine.sql.FieldUtils;
import org.ehrbase.openehr.dbformat.RmAttributeAlias;
import org.ehrbase.openehr.dbformat.RmTypeAlias;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.Param;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.DSL;

final class ConditionUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final EnumSet<AslStructureQuery.AslSourceRelation> SUPPORTED_DESCENDANT_PARENT_RELATIONS = EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS, AslStructureQuery.AslSourceRelation.FOLDER, AslStructureQuery.AslSourceRelation.EHR);
    private static final EnumSet<AslStructureQuery.AslSourceRelation> SUPPORTED_DESCENDANT_CONDITIONS = EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS, AslStructureQuery.AslSourceRelation.FOLDER);

    private ConditionUtils() {
    }

    public static Condition buildJoinCondition(AslJoin aslJoin, AqlSqlQueryBuilder.AslQueryTables aslQueryToTable) {
        Table<?> sqlLeft = aslQueryToTable.getDataTable(aslJoin.getLeft());
        Table<?> sqlRight = aslQueryToTable.getDataTable(aslJoin.getRight());
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        block6: for (AslJoinCondition jc : aslJoin.getOn()) {
            AslJoinCondition aslJoinCondition;
            Objects.requireNonNull(jc);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslDelegatingJoinCondition.class, AslPathFilterJoinCondition.class, AslAuditDetailsJoinCondition.class, AslFolderItemJoinCondition.class}, (Object)aslJoinCondition, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    AslDelegatingJoinCondition desc = (AslDelegatingJoinCondition)aslJoinCondition;
                    ConditionUtils.addDelegatingJoinConditions(desc, conditions, sqlLeft, sqlRight);
                    continue block6;
                }
                case 1: {
                    AslPathFilterJoinCondition filterCondition = (AslPathFilterJoinCondition)aslJoinCondition;
                    conditions.add(ConditionUtils.buildCondition(filterCondition.getCondition(), aslQueryToTable, true));
                    continue block6;
                }
                case 2: {
                    AslAuditDetailsJoinCondition ac = (AslAuditDetailsJoinCondition)aslJoinCondition;
                    conditions.add(FieldUtils.field(sqlLeft, aslJoin.getLeft(), ac.getLeftOwner(), AslStructureColumn.AUDIT_ID.getFieldName(), UUID.class, true).eq(FieldUtils.field(sqlRight, aslJoin.getRight(), ac.getRightOwner(), Tables.AUDIT_DETAILS.ID.getName(), UUID.class, true)));
                    continue block6;
                }
                case 3: 
            }
            AslFolderItemJoinCondition c = (AslFolderItemJoinCondition)aslJoinCondition;
            conditions.add(ConditionUtils.joinFolderItemIdEqualVoIdCondition(c, sqlLeft, sqlRight));
        }
        return conditions.stream().reduce(DSL.noCondition(), DSL::and);
    }

    private static void addDelegatingJoinConditions(AslDelegatingJoinCondition joinCondition, List<Condition> conditions, Table<?> sqlLeft, Table<?> sqlRight) {
        Stream<Condition> stream;
        AslProvidesJoinCondition aslProvidesJoinCondition = joinCondition.getDelegate();
        Objects.requireNonNull(aslProvidesJoinCondition);
        AslProvidesJoinCondition aslProvidesJoinCondition2 = aslProvidesJoinCondition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslPathChildCondition.class, AslFieldJoinCondition.class, AslDescendantCondition.class}, (Object)aslProvidesJoinCondition2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AslPathChildCondition c = (AslPathChildCondition)aslProvidesJoinCondition2;
                stream = ConditionUtils.pathChildConditions(c, sqlLeft, sqlRight, true);
                break;
            }
            case 1: {
                AslFieldJoinCondition c = (AslFieldJoinCondition)aslProvidesJoinCondition2;
                stream = ConditionUtils.fieldJoinCondition(c, sqlLeft, sqlRight, true);
                break;
            }
            case 2: {
                AslDescendantCondition c = (AslDescendantCondition)aslProvidesJoinCondition2;
                stream = ConditionUtils.descendantConditions(c, sqlLeft, sqlRight, true);
            }
        }
        stream.forEach(conditions::add);
    }

    private static Stream<Condition> pathChildConditions(AslPathChildCondition dc, Table<?> sqlLeft, Table<?> sqlRight, boolean isJoinCondition) {
        AslStructureQuery.AslSourceRelation parentRelation = dc.getParentRelation();
        if (!EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS, AslStructureQuery.AslSourceRelation.FOLDER).contains((Object)parentRelation)) {
            throw new IllegalArgumentException("unexpected parent relation type %s".formatted(new Object[]{parentRelation}));
        }
        if (!EnumSet.of(AslStructureQuery.AslSourceRelation.COMPOSITION, AslStructureQuery.AslSourceRelation.EHR_STATUS, AslStructureQuery.AslSourceRelation.FOLDER).contains((Object)dc.getChildRelation())) {
            throw new IllegalArgumentException("unexpected descendant relation type %s".formatted(new Object[]{dc.getChildRelation()}));
        }
        return switch (parentRelation) {
            default -> throw new MatchException(null, null);
            case AslStructureQuery.AslSourceRelation.EHR_STATUS -> Stream.of(ConditionUtils.joinColumnEqualCondition(AslStructureColumn.EHR_ID, dc, sqlLeft, sqlRight, isJoinCondition), ConditionUtils.joinNumEqualParentNumCondition(dc, sqlLeft, sqlRight, isJoinCondition));
            case AslStructureQuery.AslSourceRelation.COMPOSITION -> Stream.of(ConditionUtils.joinColumnEqualCondition(AslStructureColumn.VO_ID, dc, sqlLeft, sqlRight, isJoinCondition), ConditionUtils.joinNumEqualParentNumCondition(dc, sqlLeft, sqlRight, isJoinCondition));
            case AslStructureQuery.AslSourceRelation.FOLDER -> Stream.of(ConditionUtils.joinColumnEqualCondition(AslStructureColumn.EHR_ID, dc, sqlLeft, sqlRight, isJoinCondition), ConditionUtils.joinColumnEqualCondition(AslStructureColumn.EHR_FOLDER_IDX, dc, sqlLeft, sqlRight, isJoinCondition), ConditionUtils.joinNumEqualParentNumCondition(dc, sqlLeft, sqlRight, isJoinCondition));
            case AslStructureQuery.AslSourceRelation.AUDIT_DETAILS -> throw new IllegalArgumentException("Path child condition not applicable to AUDIT_DETAILS");
            case AslStructureQuery.AslSourceRelation.EHR -> throw new IllegalArgumentException("Path child condition not applicable to EHR");
        };
    }

    private static Stream<Condition> fieldJoinCondition(AslFieldJoinCondition ic, Table<?> sqlLeft, Table<?> sqlRight, boolean isJoinCondition) {
        Field<?> lf = FieldUtils.field(sqlLeft, ic.getLeftField(), true);
        Field<?> rf = FieldUtils.field(sqlRight, ic.getRightField(), isJoinCondition);
        return Stream.of(switch (ic.getOperator()) {
            default -> throw new MatchException(null, null);
            case AslQueryCondition.AslConditionOperator.LIKE -> lf.like(rf);
            case AslQueryCondition.AslConditionOperator.IN -> lf.in(new Field[]{rf});
            case AslQueryCondition.AslConditionOperator.EQ -> lf.eq(rf);
            case AslQueryCondition.AslConditionOperator.NEQ -> lf.ne(rf);
            case AslQueryCondition.AslConditionOperator.GT_EQ -> lf.ge(rf);
            case AslQueryCondition.AslConditionOperator.GT -> lf.gt(rf);
            case AslQueryCondition.AslConditionOperator.LT_EQ -> lf.le(rf);
            case AslQueryCondition.AslConditionOperator.LT -> lf.lt(rf);
            case AslQueryCondition.AslConditionOperator.IS_NULL -> lf.isNull();
            case AslQueryCondition.AslConditionOperator.IS_NOT_NULL -> lf.isNotNull();
        });
    }

    private static Stream<Condition> descendantConditions(AslDescendantCondition dc, Table<?> sqlLeft, Table<?> sqlRight, boolean isJoinCondition) {
        AslStructureQuery.AslSourceRelation parentRelation = dc.getParentRelation();
        if (!SUPPORTED_DESCENDANT_PARENT_RELATIONS.contains((Object)parentRelation)) {
            throw new IllegalArgumentException("unexpected parent relation type %s".formatted(new Object[]{parentRelation}));
        }
        AslStructureQuery.AslSourceRelation descendantRelation = dc.getDescendantRelation();
        if (!SUPPORTED_DESCENDANT_CONDITIONS.contains((Object)descendantRelation)) {
            throw new IllegalArgumentException("unexpected descendant relation type %s".formatted(new Object[]{descendantRelation}));
        }
        return switch (parentRelation) {
            default -> throw new MatchException(null, null);
            case AslStructureQuery.AslSourceRelation.EHR -> Stream.of(FieldUtils.field(sqlLeft, dc.getLeftProvider(), dc.getLeftOwner(), "id", UUID.class, true).eq(FieldUtils.field(sqlRight, dc.getRightProvider(), dc.getRightOwner(), AslStructureColumn.EHR_ID.getFieldName(), UUID.class, isJoinCondition)));
            case AslStructureQuery.AslSourceRelation.EHR_STATUS -> Stream.of(ConditionUtils.joinColumnEqualCondition(AslStructureColumn.EHR_ID, dc, sqlLeft, sqlRight, isJoinCondition), ConditionUtils.joinNumCapBetweenCondition(dc, sqlLeft, sqlRight, isJoinCondition));
            case AslStructureQuery.AslSourceRelation.COMPOSITION -> Stream.of(ConditionUtils.joinColumnEqualCondition(AslStructureColumn.VO_ID, dc, sqlLeft, sqlRight, isJoinCondition), ConditionUtils.joinNumCapBetweenCondition(dc, sqlLeft, sqlRight, isJoinCondition));
            case AslStructureQuery.AslSourceRelation.FOLDER -> Stream.of(ConditionUtils.joinColumnEqualCondition(AslStructureColumn.EHR_ID, dc, sqlLeft, sqlRight, isJoinCondition), ConditionUtils.joinColumnEqualCondition(AslStructureColumn.EHR_FOLDER_IDX, dc, sqlLeft, sqlRight, isJoinCondition), ConditionUtils.joinNumCapBetweenCondition(dc, sqlLeft, sqlRight, isJoinCondition));
            case AslStructureQuery.AslSourceRelation.AUDIT_DETAILS -> throw new IllegalArgumentException("Descendant condition not applicable to AUDIT_DETAILS");
        };
    }

    public static Condition buildCondition(AslQueryCondition c, AqlSqlQueryBuilder.AslQueryTables tables, boolean useAliases) {
        AslQueryCondition aslQueryCondition = c;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslAndQueryCondition.class, AslOrQueryCondition.class, AslNotQueryCondition.class, AslFalseQueryCondition.class, AslTrueQueryCondition.class, AslNotNullQueryCondition.class, AslFieldValueQueryCondition.class, AslFieldJoinCondition.class, AslDescendantCondition.class, AslPathChildCondition.class}, (Object)aslQueryCondition, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> DSL.noCondition();
            case 0 -> {
                AslAndQueryCondition and = (AslAndQueryCondition)aslQueryCondition;
                yield DSL.and(and.getOperands().stream().map(o -> ConditionUtils.buildCondition(o, tables, useAliases)).toList());
            }
            case 1 -> {
                AslOrQueryCondition or = (AslOrQueryCondition)aslQueryCondition;
                yield DSL.or(or.getOperands().stream().map(o -> ConditionUtils.buildCondition(o, tables, useAliases)).toList());
            }
            case 2 -> {
                AslNotQueryCondition not = (AslNotQueryCondition)aslQueryCondition;
                yield DSL.not((Condition)ConditionUtils.buildCondition(not.getCondition(), tables, useAliases));
            }
            case 3 -> {
                AslFalseQueryCondition __ = (AslFalseQueryCondition)aslQueryCondition;
                yield DSL.falseCondition();
            }
            case 4 -> {
                AslTrueQueryCondition __ = (AslTrueQueryCondition)aslQueryCondition;
                yield DSL.trueCondition();
            }
            case 5 -> {
                AslNotNullQueryCondition nn = (AslNotNullQueryCondition)aslQueryCondition;
                yield ConditionUtils.notNullCondition(tables, useAliases, nn);
            }
            case 6 -> {
                AslFieldValueQueryCondition fv = (AslFieldValueQueryCondition)aslQueryCondition;
                yield ConditionUtils.buildFieldValueCondition(tables, useAliases, fv);
            }
            case 7 -> {
                AslFieldJoinCondition ic = (AslFieldJoinCondition)aslQueryCondition;
                yield DSL.and(ConditionUtils.fieldJoinCondition(ic, tables.getDataTable(ic.getLeftProvider()), tables.getDataTable(ic.getRightProvider()), false).toList());
            }
            case 8 -> {
                AslDescendantCondition dc = (AslDescendantCondition)aslQueryCondition;
                yield DSL.and(ConditionUtils.descendantConditions(dc, tables.getDataTable(dc.getLeftProvider()), dc.getParentRelation() == AslStructureQuery.AslSourceRelation.EHR ? tables.getVersionTable(dc.getRightProvider()) : tables.getDataTable(dc.getRightProvider()), false).toList());
            }
            case 9 -> {
                AslPathChildCondition dc = (AslPathChildCondition)aslQueryCondition;
                yield DSL.and(ConditionUtils.pathChildConditions(dc, tables.getDataTable(dc.getLeftProvider()), dc.getParentRelation() == AslStructureQuery.AslSourceRelation.EHR ? tables.getVersionTable(dc.getRightProvider()) : tables.getDataTable(dc.getRightProvider()), false).toList());
            }
        };
    }

    @Nonnull
    private static Condition notNullCondition(AqlSqlQueryBuilder.AslQueryTables tables, boolean useAliases, AslNotNullQueryCondition nn) {
        AslField field = nn.getField();
        if (field.getExtractedColumn() != null) {
            return DSL.trueCondition();
        }
        if (field instanceof AslColumnField) {
            AslColumnField f = (AslColumnField)field;
            return (f.isVersionTableField() ? tables.getVersionTable(field.getProvider()) : tables.getDataTable(field.getProvider())).field(f.getName(useAliases)).isNotNull();
        }
        throw new IllegalArgumentException("Unsupported field type: %s".formatted(field.getClass().getSimpleName()));
    }

    private static Condition buildFieldValueCondition(AqlSqlQueryBuilder.AslQueryTables tables, boolean useAliases, AslFieldValueQueryCondition fv) {
        AslField field = fv.getField();
        AslQuery internalProvider = field.getInternalProvider();
        Table<?> srcTable = tables.getDataTable(internalProvider);
        if (fv instanceof AslDvOrderedValueQueryCondition) {
            AslDvOrderedValueQueryCondition dvc = (AslDvOrderedValueQueryCondition)fv;
            Field<JSONB> sqlDvOrderedField = FieldUtils.buidDvOrderedField(useAliases, field, srcTable);
            Field sqlMagnitudeField = AdditionalSQLFunctions.jsonb_dv_ordered_magnitude(sqlDvOrderedField);
            Field sqlTypeField = DSL.jsonbGetAttributeAsText(sqlDvOrderedField, (Field)DSL.inline((String)RmAttributeAlias.getAlias((String)"_type")));
            List<String> types = dvc.getTypesToCompare().stream().map(RmTypeAlias::getAlias).toList();
            return ConditionUtils.applyOperator(AslQueryCondition.AslConditionOperator.IN, sqlTypeField, types).and(ConditionUtils.applyOperator(dvc.getOperator(), sqlMagnitudeField, dvc.getValues()));
        }
        AslField aslField = field;
        Objects.requireNonNull(aslField);
        AslField aslField2 = aslField;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AslComplexExtractedColumnField.class, AslColumnField.class, AslConstantField.class, AslAggregatingField.class, AslSubqueryField.class, AslFolderItemIdVirtualField.class, AslRmPathField.class}, (Object)aslField2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                AslComplexExtractedColumnField ecf = (AslComplexExtractedColumnField)aslField2;
                yield ConditionUtils.complexExtractedColumnCondition(useAliases, fv, ecf, srcTable, tables.getVersionTable(internalProvider));
            }
            case 1 -> {
                AslColumnField f = (AslColumnField)aslField2;
                yield ConditionUtils.applyOperator(fv.getOperator(), FieldUtils.field(f.isVersionTableField() ? tables.getVersionTable(internalProvider) : srcTable, f, useAliases), fv.getValues());
            }
            case 2 -> {
                AslConstantField f = (AslConstantField)aslField2;
                yield ConditionUtils.applyOperator(fv.getOperator(), (Field)DSL.inline(f.getValue(), f.getType()), fv.getValues());
            }
            case 3 -> {
                AslAggregatingField __ = (AslAggregatingField)aslField2;
                throw new IllegalArgumentException("AslAggregatingField cannot be used in WHERE");
            }
            case 4 -> {
                AslSubqueryField __ = (AslSubqueryField)aslField2;
                throw new IllegalArgumentException("AslSubqueryField cannot be used in WHERE");
            }
            case 5 -> {
                AslFolderItemIdVirtualField __ = (AslFolderItemIdVirtualField)aslField2;
                throw new IllegalArgumentException("AslFolderItemIdValuesColumnField cannot be used in WHERE");
            }
            case 6 -> {
                AslRmPathField arpf = (AslRmPathField)aslField2;
                Field<JSONB> srcField = FieldUtils.field(Objects.requireNonNull(srcTable), arpf.getSrcField(), JSONB.class, useAliases);
                Field f = FieldUtils.buildJsonbPathField(arpf.getPathInJson(), false, srcField);
                yield ConditionUtils.applyOperator(fv.getOperator(), arpf.getType() == String.class ? DSL.jsonbGetElementAsText(f, (Field)DSL.inline((int)0)) : f, fv.getValues());
            }
        };
    }

    @Nonnull
    static Condition complexExtractedColumnCondition(boolean useAliases, AslFieldValueQueryCondition<?> fv, AslComplexExtractedColumnField ecf, Table<?> dataTable, Table<?> versionTable) {
        return switch (ecf.getExtractedColumn()) {
            default -> throw new MatchException(null, null);
            case AslExtractedColumn.VO_ID -> {
                switch (fv.getOperator()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case IS_NULL: 
                    case IS_NOT_NULL: {
                        yield ConditionUtils.voIdCondition(versionTable, useAliases, null, fv.getOperator(), ecf);
                    }
                    case IN: 
                    case EQ: {
                        yield ConditionUtils.voIdInCondition(versionTable, useAliases, fv.getValues(), true, ecf);
                    }
                    case NEQ: {
                        yield ConditionUtils.voIdInCondition(versionTable, useAliases, fv.getValues(), false, ecf);
                    }
                    case LIKE: 
                    case GT_EQ: 
                    case GT: 
                    case LT_EQ: 
                    case LT: 
                }
                yield ConditionUtils.voIdCondition(versionTable, useAliases, (String)fv.getValues().getFirst(), fv.getOperator(), ecf);
            }
            case AslExtractedColumn.ARCHETYPE_NODE_ID -> {
                AslQueryCondition.AslConditionOperator op = fv.getOperator() == AslQueryCondition.AslConditionOperator.IN ? AslQueryCondition.AslConditionOperator.EQ : fv.getOperator();
                yield fv.getValues().stream().map(AslRmTypeAndConcept.class::cast).map(p -> ConditionUtils.archetypeNodeIdCondition(dataTable, useAliases, ecf, p, op)).reduce(DSL.noCondition(), DSL::or);
            }
            case AslExtractedColumn.TEMPLATE_ID, AslExtractedColumn.NAME_VALUE, AslExtractedColumn.EHR_ID, AslExtractedColumn.ROOT_CONCEPT, AslExtractedColumn.OV_CONTRIBUTION_ID, AslExtractedColumn.OV_TIME_COMMITTED_DV, AslExtractedColumn.OV_TIME_COMMITTED, AslExtractedColumn.AD_SYSTEM_ID, AslExtractedColumn.AD_DESCRIPTION_DV, AslExtractedColumn.AD_DESCRIPTION_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_DV, AslExtractedColumn.AD_CHANGE_TYPE_VALUE, AslExtractedColumn.AD_CHANGE_TYPE_CODE_STRING, AslExtractedColumn.AD_CHANGE_TYPE_PREFERRED_TERM, AslExtractedColumn.AD_CHANGE_TYPE_TERMINOLOGY_ID_VALUE, AslExtractedColumn.EHR_TIME_CREATED_DV, AslExtractedColumn.EHR_TIME_CREATED, AslExtractedColumn.EHR_SYSTEM_ID, AslExtractedColumn.EHR_SYSTEM_ID_DV -> throw new IllegalArgumentException("Extracted column %s is not complex".formatted(new Object[]{ecf.getExtractedColumn()}));
        };
    }

    private static Condition archetypeNodeIdCondition(Table<?> src, boolean aliasedNames, AslComplexExtractedColumnField ecf, AslRmTypeAndConcept rmTypeAndConcept, AslQueryCondition.AslConditionOperator op) {
        return Stream.of(Pair.of((Object)Tables.COMP_DATA.RM_ENTITY, (Object)rmTypeAndConcept.aliasedRmType()), Pair.of((Object)Tables.COMP_DATA.ENTITY_CONCEPT, (Object)rmTypeAndConcept.concept())).filter(p -> p.getValue() != null).map(p1 -> ConditionUtils.applyOperator(op, FieldUtils.field(src, ecf, ((TableField)p1.getKey()).getName(), aliasedNames), List.of((String)p1.getValue()))).reduce(DSL.noCondition(), op == AslQueryCondition.AslConditionOperator.NEQ ? DSL::or : DSL::and);
    }

    @Nonnull
    private static Condition voIdInCondition(Table<?> versionTable, boolean aliasedNames, List<String> ids, boolean notNegated, AslComplexExtractedColumnField field) {
        Condition uidVersionCond;
        if (ids.isEmpty()) {
            return notNegated ? DSL.falseCondition() : DSL.trueCondition();
        }
        if (ids.size() == 1) {
            return ConditionUtils.voIdCondition(versionTable, aliasedNames, ids.getFirst(), notNegated ? AslQueryCondition.AslConditionOperator.EQ : AslQueryCondition.AslConditionOperator.NEQ, field);
        }
        ArrayList uidList = null;
        ArrayList uidVersionList = null;
        for (String id : ids) {
            Pair<String, Integer> voId = ConditionUtils.parseVoId(id);
            Field<?> voIdValueField = ConditionUtils.createVoIdValue(voId);
            if (voId.getRight() == null) {
                if (uidList == null) {
                    uidList = new ArrayList(ids.size());
                }
                uidList.add(voIdValueField);
                continue;
            }
            if (uidVersionList == null) {
                uidVersionList = new ArrayList(ids.size());
            }
            uidVersionList.add(voIdValueField);
        }
        Field<?> uuidField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.VO_ID.getName(), aliasedNames);
        Condition uidCond = uidList == null ? null : uuidField.in(uidList);
        if (uidVersionList == null) {
            uidVersionCond = null;
        } else {
            Field<?> versionField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.SYS_VERSION.getName(), aliasedNames);
            uidVersionCond = DSL.field((SelectField)DSL.row(uuidField, versionField)).in(uidVersionList);
        }
        Condition cond = DSL.or((Condition)uidCond, uidVersionCond);
        if (notNegated) {
            return cond;
        }
        return cond.not();
    }

    @Nonnull
    private static Condition voIdCondition(Table<?> versionTable, boolean aliasedNames, String id, AslQueryCondition.AslConditionOperator op, AslComplexExtractedColumnField field) {
        Field left;
        Field uuidField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.VO_ID.getName(), aliasedNames);
        if (op == AslQueryCondition.AslConditionOperator.IS_NULL) {
            return uuidField.isNull();
        }
        if (op == AslQueryCondition.AslConditionOperator.IS_NOT_NULL) {
            return uuidField.isNotNull();
        }
        Pair<String, Integer> voId = ConditionUtils.parseVoId(id);
        if (voId.getRight() == null) {
            left = uuidField;
        } else {
            Field<?> versionField = FieldUtils.field(versionTable, field, Tables.COMP_VERSION.SYS_VERSION.getName(), aliasedNames);
            left = DSL.field((SelectField)DSL.row(uuidField, versionField));
        }
        Field<?> right = ConditionUtils.createVoIdValue(voId);
        return switch (op) {
            default -> throw new MatchException(null, null);
            case AslQueryCondition.AslConditionOperator.IN, AslQueryCondition.AslConditionOperator.EQ -> left.eq(right);
            case AslQueryCondition.AslConditionOperator.NEQ -> left.ne(right);
            case AslQueryCondition.AslConditionOperator.LT -> left.lt(right);
            case AslQueryCondition.AslConditionOperator.GT -> left.gt(right);
            case AslQueryCondition.AslConditionOperator.GT_EQ -> left.ge(right);
            case AslQueryCondition.AslConditionOperator.LT_EQ -> left.le(right);
            case AslQueryCondition.AslConditionOperator.LIKE, AslQueryCondition.AslConditionOperator.IS_NULL, AslQueryCondition.AslConditionOperator.IS_NOT_NULL -> throw new IllegalArgumentException();
        };
    }

    private static Pair<String, Integer> parseVoId(String id) {
        int uidEndPos = id.indexOf("::");
        if (uidEndPos < 0) {
            return Pair.of((Object)id, null);
        }
        int versionPos = id.indexOf("::", uidEndPos + 2);
        return Pair.of((Object)id.substring(0, uidEndPos), (Object)Integer.parseInt(id.substring(versionPos + 2)));
    }

    private static Field<?> createVoIdValue(Pair<String, Integer> voId) {
        Field uuidField = DSL.inline((String)((String)voId.getLeft())).cast(UUID.class);
        if (voId.getRight() == null) {
            return uuidField;
        }
        Param versionField = DSL.inline((Integer)((Integer)voId.getRight()));
        return DSL.field((SelectField)DSL.row((SelectField)uuidField, (SelectField)versionField));
    }

    private static Condition applyOperator(AslQueryCondition.AslConditionOperator operator, Field field, Collection<?> values) {
        boolean isUuidField;
        Class sqlFieldType = field.getType();
        boolean isJsonbField = JSONB.class.isAssignableFrom(sqlFieldType);
        boolean bl = isUuidField = !isJsonbField && UUID.class.isAssignableFrom(sqlFieldType);
        if (operator == AslQueryCondition.AslConditionOperator.LIKE) {
            String likePattern = (String)values.iterator().next();
            if (isJsonbField) {
                likePattern = ConditionUtils.escapeAsJsonString(likePattern);
            }
            return field.cast(String.class).like(likePattern);
        }
        if (operator == AslQueryCondition.AslConditionOperator.IS_NULL) {
            return field.isNull();
        }
        if (operator == AslQueryCondition.AslConditionOperator.IS_NOT_NULL) {
            return field.isNotNull();
        }
        boolean orderOperator = EnumSet.of(AslQueryCondition.AslConditionOperator.GT_EQ, AslQueryCondition.AslConditionOperator.GT, AslQueryCondition.AslConditionOperator.LT_EQ, AslQueryCondition.AslConditionOperator.LT).contains((Object)operator);
        List<Object> filteredValues = values.stream().map(v -> {
            Object value;
            if (isUuidField && v instanceof String) {
                UUID uuid;
                String s = (String)v;
                try {
                    uuid = UUID.fromString(s);
                }
                catch (IllegalArgumentException e) {
                    uuid = null;
                }
                value = uuid;
            } else {
                value = isJsonbField || orderOperator || sqlFieldType.isInstance(v) || Number.class.isAssignableFrom(sqlFieldType) && v instanceof Number ? v : null;
            }
            return value;
        }).filter(Objects::nonNull).toList();
        return switch (filteredValues.size()) {
            case 0 -> {
                switch (operator) {
                    case IN: 
                    case EQ: {
                        yield DSL.falseCondition();
                    }
                    case NEQ: {
                        yield DSL.trueCondition();
                    }
                    case GT_EQ: 
                    case GT: 
                    case LT_EQ: 
                    case LT: {
                        throw new IllegalArgumentException("%s-Condition needs one value, not 0".formatted(new Object[]{operator}));
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operator));
            }
            case 1 -> {
                Object val = filteredValues.getFirst();
                boolean valueAndFieldTypeCompatible = sqlFieldType.isInstance(val) || Number.class.isAssignableFrom(sqlFieldType) && val instanceof Number;
                Field wrappedValue = isJsonbField || orderOperator && !valueAndFieldTypeCompatible ? AdditionalSQLFunctions.to_jsonb((Object)val) : DSL.inline((Object)val);
                Field wrappedField = !isJsonbField && orderOperator && !valueAndFieldTypeCompatible ? AdditionalSQLFunctions.to_jsonb((Field)field) : field;
                switch (operator) {
                    case IN: 
                    case EQ: {
                        yield field.eq(wrappedValue);
                    }
                    case NEQ: {
                        yield field.ne(wrappedValue);
                    }
                    case GT_EQ: {
                        yield wrappedField.ge(wrappedValue);
                    }
                    case GT: {
                        yield wrappedField.gt(wrappedValue);
                    }
                    case LT_EQ: {
                        yield wrappedField.le(wrappedValue);
                    }
                    case LT: {
                        yield wrappedField.lt(wrappedValue);
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operator));
            }
            default -> {
                switch (operator) {
                    case IN: {
                        yield field.in(filteredValues.stream().map(v -> isJsonbField ? AdditionalSQLFunctions.to_jsonb((Object)v) : DSL.inline((Object)v)).toList());
                    }
                    case EQ: 
                    case NEQ: 
                    case GT_EQ: 
                    case GT: 
                    case LT_EQ: 
                    case LT: {
                        throw new IllegalArgumentException("%s-Condition needs one value, not %d".formatted(new Object[]{operator, filteredValues.size()}));
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)operator));
            }
        };
    }

    private static Condition joinColumnEqualCondition(AslStructureColumn column, AslProvidesJoinCondition dc, Table<?> sqlLeft, Table<?> sqlRight, boolean aliased) {
        String cName = column.getFieldName();
        return FieldUtils.field(sqlLeft, dc.getLeftProvider(), dc.getLeftOwner(), cName, UUID.class, true).eq(FieldUtils.field(sqlRight, dc.getRightProvider(), dc.getRightOwner(), cName, UUID.class, aliased));
    }

    private static Condition joinNumEqualParentNumCondition(AslProvidesJoinCondition dc, Table<?> sqlLeft, Table<?> sqlRight, boolean aliased) {
        String num = AslStructureColumn.NUM.getFieldName();
        String parentNum = AslStructureColumn.PARENT_NUM.getFieldName();
        return FieldUtils.field(sqlLeft, dc.getLeftProvider(), dc.getLeftOwner(), num, Integer.class, true).eq(FieldUtils.field(sqlRight, dc.getRightProvider(), dc.getRightOwner(), parentNum, Integer.class, aliased));
    }

    private static Condition joinNumCapBetweenCondition(AslProvidesJoinCondition dc, Table<?> sqlLeft, Table<?> sqlRight, boolean aliased) {
        String numFieldName = AslStructureColumn.NUM.getFieldName();
        String numCapFieldName = AslStructureColumn.NUM_CAP.getFieldName();
        AslQuery leftProvider = dc.getLeftProvider();
        AslQuery leftOwner = dc.getLeftOwner();
        return FieldUtils.field(sqlRight, dc.getRightProvider(), dc.getRightOwner(), numFieldName, Integer.class, true).between(FieldUtils.field(sqlLeft, leftProvider, leftOwner, numFieldName, Integer.class, aliased).add((Field)DSL.inline((int)1)), FieldUtils.field(sqlLeft, leftProvider, leftOwner, numCapFieldName, Integer.class, aliased));
    }

    private static Condition joinFolderItemIdEqualVoIdCondition(AslFolderItemJoinCondition dc, Table<?> sqlLeft, Table<?> sqlRight) {
        AslQuery leftOwner = dc.getLeftOwner();
        AslQuery rightProvider = dc.rightProvider();
        AslQuery rightOwner = dc.getRightOwner();
        AslFolderItemIdVirtualField column = leftOwner.getSelect().stream().filter(AslFolderItemIdVirtualField.class::isInstance).map(AslFolderItemIdVirtualField.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("AslFolderItemJoinCondition requires an AslFolderItemIdValuesColumnField"));
        return FieldUtils.field(sqlRight, rightProvider, rightOwner, AslStructureColumn.VO_ID.getFieldName(), UUID.class, true).eq(FieldUtils.field(sqlLeft, column, column.getFieldName(), UUID.class, true));
    }

    static String escapeAsJsonString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)string);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e.getMessage(), (IOException)((Object)e));
        }
    }
}

